/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.util.PushdownFunctionUtil;

public class SourceProcedureUniquenessRule
implements ObjectValidationRule {
    private final String ruleName = this.getClass().getName();

    public void validate(EObject eObject, ValidationContext context) {
        if (context.hasRunRule(eObject, this.ruleName)) {
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject);
        if (siblings.size() < 2) {
            return;
        }
        HashMap siblingsBySignature = new HashMap();
        for (EObject sibling : siblings) {
            if (!(sibling instanceof Procedure) || !((Procedure)sibling).isFunction()) continue;
            String signature = this.computeSignature(sibling);
            LinkedList<EObject> existing = (LinkedList<EObject>)siblingsBySignature.get(signature);
            if (existing == null) {
                existing = new LinkedList<EObject>();
                siblingsBySignature.put(signature, existing);
            }
            if (existing.contains(sibling)) continue;
            existing.add(sibling);
        }
        for (String signature : siblingsBySignature.keySet()) {
            List siblingsWithSameSignature = (List)siblingsBySignature.get(signature);
            int numSiblingsWithSameSignature = siblingsWithSameSignature.size();
            if (numSiblingsWithSameSignature <= 1) continue;
            for (EObject sibling : siblingsWithSameSignature) {
                ValidationResultImpl result = new ValidationResultImpl((Object)sibling);
                String msg = this.getDuplicateMessage(numSiblingsWithSameSignature, signature);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
        context.recordRuleRun(eObject, this.ruleName);
    }

    protected String computeSignature(EObject eObject) {
        return PushdownFunctionUtil.getSignature((Procedure)eObject);
    }

    protected String getDuplicateMessage(int numDuplicates, String signature) {
        Object[] params = new Object[]{new Integer(numDuplicates - 1), signature};
        String msg = RelationalPlugin.Util.getString("SourceProcedureUniquenessRule.Same_signature_as_{0}_sibling(s)__{1}", params);
        return msg;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            return parent.eContents();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            return resource.getContents();
        }
        return new ArrayList(1);
    }
}

