/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.relational.aspects.sql.RelationalEntityAspect;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class TableAspect
extends RelationalEntityAspect
implements SqlTableAspect {
    public TableAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean supportsUpdate(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        return table.isSupportsUpdate();
    }

    public int getTableType(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        if (table instanceof View) {
            return 1;
        }
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            ModelAnnotation annot = ((EmfResource)resource).getModelAnnotation();
            if (annot.getModelType() == ModelType.MATERIALIZATION_LITERAL) {
                return 5;
            }
            if (annot.getModelType() == ModelType.VIRTUAL_LITERAL && RelationalUtil.isGlobalTempTable(eObject)) {
                return 6;
            }
        }
        return 0;
    }

    public boolean isSystem(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        return table.isSystem();
    }

    public String getMaterializedTableId(EObject eObject) {
        Table materializedTable;
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        if (table != null && (materializedTable = table.getMaterializedTable()) != null) {
            return ModelerCore.getObjectId((EObject)materializedTable).toString();
        }
        return null;
    }

    public boolean isVirtual(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        try {
            ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation((EObject)table);
            return ma != null && ma.getModelType().getValue() == ModelType.VIRTUAL;
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
            return false;
        }
    }

    public boolean isMaterialized(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        return table.isMaterialized();
    }

    public List getColumns(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table baseTable = (Table)eObject;
        return baseTable.getColumns();
    }

    public Collection getIndexes(EObject eObject) {
        ArrayList<Index> results = new ArrayList<Index>();
        if (eObject instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)eObject;
            for (Column column : baseTable.getColumns()) {
                EList indexesUsingColumn = column.getIndexes();
                for (Index index : indexesUsingColumn) {
                    if (results.contains(index)) continue;
                    results.add(index);
                }
            }
        }
        return results;
    }

    public Collection getForeignKeys(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        if (eObject instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)eObject;
            return baseTable.getForeignKeys();
        }
        return Collections.EMPTY_LIST;
    }

    public Object getPrimaryKey(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        if (eObject instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)eObject;
            return baseTable.getPrimaryKey();
        }
        return null;
    }

    public Collection getUniqueKeys(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        ArrayList<UniqueKey> results = new ArrayList<UniqueKey>();
        if (eObject instanceof BaseTable) {
            BaseTable table = (BaseTable)eObject;
            for (Column column : table.getColumns()) {
                EList ukeysUsingColumn = column.getUniqueKeys();
                for (UniqueKey uniqueKey : ukeysUsingColumn) {
                    if (results.contains(uniqueKey)) continue;
                    results.add(uniqueKey);
                }
            }
        }
        return results;
    }

    public Collection getAccessPatterns(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table baseTable = (Table)eObject;
        return baseTable.getAccessPatterns();
    }

    public int getCardinality(EObject eObject) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table baseTable = (Table)eObject;
        return baseTable.getCardinality();
    }

    public int getColumnSetType() {
        return 5;
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'B';
    }

    public boolean isMappable(EObject eObject, int mappingType) {
        if (this.isVirtual(eObject)) {
            return mappingType == 1;
        }
        return false;
    }

    public boolean canAcceptTransformationSource(EObject target, EObject source) {
        SqlAspect sourceAspect;
        CoreArgCheck.isInstanceOf(Table.class, (Object)target);
        CoreArgCheck.isNotNull((Object)source);
        if (source == target) {
            return false;
        }
        return this.isVirtual(target) && ((sourceAspect = SqlAspectHelper.getSqlAspect((EObject)source)) instanceof SqlTableAspect || sourceAspect instanceof SqlProcedureAspect);
    }

    public boolean canBeTransformationSource(EObject source, EObject target) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)source);
        CoreArgCheck.isNotNull((Object)target);
        if (source == target) {
            return false;
        }
        SqlAspect targetAspect = SqlAspectHelper.getSqlAspect((EObject)target);
        if (targetAspect instanceof SqlTableAspect) {
            return ((SqlTableAspect)targetAspect).isVirtual(target);
        }
        if (targetAspect instanceof SqlProcedureAspect) {
            return ((SqlProcedureAspect)targetAspect).isVirtual(target);
        }
        return false;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public void setSupportsUpdate(EObject eObject, boolean supportsUpdate) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table baseTable = (Table)eObject;
        baseTable.setSupportsUpdate(supportsUpdate);
    }
}

