/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.sql;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.aspects.sql.RelationalEntityAspect;

public class ProcedureParameterAspect
extends RelationalEntityAspect
implements SqlProcedureParameterAspect {
    public ProcedureParameterAspect(MetamodelEntity entity) {
        super(entity);
    }

    public String getDatatypeName(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        EObject dataType = proc.getType();
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)proc, (boolean)true);
        String dtName = dtMgr.getName(dataType);
        return dtName == null ? "" : dtMgr.getName(dataType);
    }

    public EObject getDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getType();
    }

    public String getRuntimeType(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        EObject datatype = proc.getType();
        return datatype == null ? "" : ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true).getRuntimeTypeName(datatype);
    }

    public Object getDefaultValue(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getDefaultValue();
    }

    public int getType(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        DirectionKind direction = proc.getDirection();
        return this.convertDirectionKindToMetadataConstant(direction);
    }

    public int getLength(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getLength();
    }

    public int getPrecision(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getPrecision();
    }

    public int getRadix(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getRadix();
    }

    public int getPosition(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        EList params = proc.getProcedure().getParameters();
        return params.indexOf(eObject) + 1;
    }

    public int getScale(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        return proc.getScale();
    }

    public int getNullType(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        NullableType nullType = proc.getNullable();
        return this.convertNullableTypeToMetadataConstant(nullType);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'F';
    }

    public String getDatatypeObjectID(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        return dtMgr.getUuidString(datatype);
    }

    public boolean isOptional(EObject eObject) {
        return false;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        EObjectImpl eObjectImpl = super.getEObjectImpl(eObject);
        if (eObjectImpl != null) {
            switch (eObjectImpl.eDerivedStructuralFeatureID(eFeature)) {
                case 11: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canSetDatatype() {
        return true;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter procParam = (ProcedureParameter)eObject;
        procParam.setType(datatype);
    }

    public boolean canSetLength() {
        return true;
    }

    public void setLength(EObject eObject, int length) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter procParam = (ProcedureParameter)eObject;
        procParam.setLength(length);
    }

    public boolean canSetNullType() {
        return true;
    }

    public void setNullType(EObject eObject, int nullType) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter procParam = (ProcedureParameter)eObject;
        procParam.setNullable(this.convertMetadataConstantToNullableType(nullType));
    }

    public boolean isInputParam(EObject eObject) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter procParam = (ProcedureParameter)eObject;
        DirectionKind dir = procParam.getDirection();
        return DirectionKind.IN_LITERAL == dir || DirectionKind.INOUT_LITERAL == dir;
    }

    public void setDirection(EObject eObject, int dir) {
        CoreArgCheck.isInstanceOf(ProcedureParameter.class, (Object)eObject);
        ProcedureParameter proc = (ProcedureParameter)eObject;
        proc.setDirection(this.convertMetadataContantToDirectionKind(dir));
    }
}

