/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.ui.wizards;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.xsd.ui.XsdUiPlugin;

public class XsdModelWizard
extends Wizard
implements INewWizard {
    protected XSDPackage xsdPackage = XSDPackage.eINSTANCE;
    protected XSDFactory xsdFactory = this.xsdPackage.getXSDFactory();
    protected XSDModelWizardNewFileCreationPage newFilePage;
    protected XSDModelWizardInitialObjectCreationPage initialObjectPage;
    protected IStructuredSelection initialSelection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.initialSelection = selection;
        this.setDefaultPageImageDescriptor(XsdUiPlugin.INSTANCE.getImageDescriptor("icons/full/wizban/NewXSD"));
    }

    protected EObject createInitialModel() {
        return this.initialObjectPage.createInitialModel();
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = XsdModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            resource.save(Collections.EMPTY_MAP);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)XsdUiPlugin.Util.getString("_UI_OpenEditorError_label", new Object[0]), (String)exception.getMessage());
                XsdUiPlugin.Util.log((Throwable)exception);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFilePage = new XSDModelWizardNewFileCreationPage(XsdUiPlugin.Util.getString("XsdModelWizard.Whatever_13", new Object[0]), this.initialSelection);
        this.newFilePage.setTitle(XsdUiPlugin.Util.getString("_UI_XSDModelWizard_label", new Object[0]));
        this.newFilePage.setDescription(XsdUiPlugin.Util.getString("_UI_XSDModelWizard_description", new Object[0]));
        this.newFilePage.setFileName(String.valueOf(XsdUiPlugin.Util.getString("_UI_XSDEditorFilenameDefaultBase", new Object[0])) + "." + XsdUiPlugin.Util.getString("_UI_XSDEditorFilenameExtension", new Object[0]));
        this.newFilePage.setImageDescriptor(XsdUiPlugin.INSTANCE.getImageDescriptor("icons/full/wizban/NewXSD.gif"));
        this.addPage((IWizardPage)this.newFilePage);
        if (this.initialSelection != null && !this.initialSelection.isEmpty() && (selectedElement = this.initialSelection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IProject || selectedResource instanceof IFolder) {
                this.newFilePage.setContainerFullPath(selectedResource.getFullPath());
                String defModelBaseFilename = XsdUiPlugin.Util.getString("_UI_XSDEditorFilenameDefaultBase", new Object[0]);
                String defModelFilenameExtension = XsdUiPlugin.Util.getString("_UI_XSDEditorFilenameExtension", new Object[0]);
                String modelFilename = String.valueOf(defModelBaseFilename) + "." + defModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defModelBaseFilename) + i + "." + defModelFilenameExtension;
                    ++i;
                }
                this.newFilePage.setFileName(modelFilename);
            }
        }
        this.initialObjectPage = new XSDModelWizardInitialObjectCreationPage(XsdUiPlugin.Util.getString("XsdModelWizard.Whatever2_23", new Object[0]));
        this.initialObjectPage.setTitle(XsdUiPlugin.Util.getString("_UI_XSDModelWizard_label", new Object[0]));
        this.initialObjectPage.setDescription(XsdUiPlugin.Util.getString("_UI_Wizard_initial_object_description", new Object[0]));
        this.initialObjectPage.setImageDescriptor(XsdUiPlugin.INSTANCE.getImageDescriptor("icons/full/wizban/NewXSD.gif"));
        this.addPage((IWizardPage)this.initialObjectPage);
    }

    public IFile getModelFile() {
        return this.newFilePage.getModelFile();
    }

    public class XSDModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Text nestedSchemaPrefixText;
        protected Text nestedSchemaNamespaceText;
        protected Text schemaPrefixText;
        protected Text schemaNamespaceText;

        public XSDModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
        }

        public void createControl(Composite parent) {
            GridData gd = null;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            gd = new GridData();
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            composite.setLayoutData((Object)gd);
            Label schemaPrefixLabel = new Label(composite, 16384);
            schemaPrefixLabel.setText(XsdUiPlugin.Util.getString("_UI_SchemaPrefix_label", new Object[0]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            schemaPrefixLabel.setLayoutData((Object)gd);
            this.schemaPrefixText = new Text(composite, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.schemaPrefixText.setLayoutData((Object)gd);
            this.schemaPrefixText.setText(XsdUiPlugin.Util.getString("XsdModelWizard.this_6", new Object[0]));
            Label schemaNamespaceLabel = new Label(composite, 16384);
            schemaNamespaceLabel.setText(XsdUiPlugin.Util.getString("_UI_SchemaNamespaceURI_label", new Object[0]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            schemaNamespaceLabel.setLayoutData((Object)gd);
            this.schemaNamespaceText = new Text(composite, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.schemaNamespaceText.setLayoutData((Object)gd);
            String nsText = XsdModelWizard.this.getModelFile() == null ? "http://" : "http://" + XsdModelWizard.this.getModelFile().getFullPath();
            this.schemaNamespaceText.setText(nsText);
            Label nestedSchemaPrefixLabel = new Label(composite, 16384);
            nestedSchemaPrefixLabel.setText(XsdUiPlugin.Util.getString("_UI_SchemaForSchemaPrefix_label", new Object[0]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            nestedSchemaPrefixLabel.setLayoutData((Object)gd);
            this.nestedSchemaPrefixText = new Text(composite, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.nestedSchemaPrefixText.setLayoutData((Object)gd);
            this.nestedSchemaPrefixText.setText("xsd");
            Label nestedSchemaNamespaceLabel = new Label(composite, 16384);
            nestedSchemaNamespaceLabel.setText(XsdUiPlugin.Util.getString("_UI_SchemaForSchemaNamespaceURI_label", new Object[0]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            nestedSchemaNamespaceLabel.setLayoutData((Object)gd);
            this.nestedSchemaNamespaceText = new Text(composite, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.nestedSchemaNamespaceText.setLayoutData((Object)gd);
            this.nestedSchemaNamespaceText.setText("http://www.w3.org/2001/XMLSchema");
            this.setControl((Control)composite);
        }

        public boolean isPageComplete() {
            return super.isPageComplete();
        }

        public boolean performFinish() {
            return true;
        }

        public EObject createInitialModel() {
            XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            Map map = xsdSchema.getQNamePrefixToNamespaceMap();
            map.put(this.nestedSchemaPrefixText.getText(), this.nestedSchemaNamespaceText.getText());
            xsdSchema.setSchemaForSchemaQNamePrefix(this.nestedSchemaPrefixText.getText());
            if (this.schemaNamespaceText.getText() != null && this.schemaNamespaceText.getText().trim().length() != 0) {
                xsdSchema.setTargetNamespace(this.schemaNamespaceText.getText());
                map.put(this.schemaPrefixText.getText(), this.schemaNamespaceText.getText());
            }
            return xsdSchema;
        }
    }

    public class XSDModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public XSDModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = XsdUiPlugin.Util.getString("_UI_XSDEditorFilenameExtension", new Object[0]);
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(XsdUiPlugin.Util.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            if (this.getContainerFullPath() == null) {
                return null;
            }
            return this.modelFile == null ? ModelerCore.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }
}

