/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.test.util.JobUtils;

public class AbstractRefactorTest
extends TestCase {
    public AbstractRefactorTest(String name) {
        super(name);
    }

    public static void checkRename(RenameProcessor processor, List<TestChangeStructure> changeList) throws CoreException {
        RefactoringStatusEntry entry;
        RefactoringStatusEntry[] entries;
        AbstractRefactorTest.processTestChanges(changeList);
        JobUtils.waitForIdle((long)2000L);
        AbstractRefactorTest.checkBeforeRefactoring(changeList);
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        AbstractRefactorTest.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
        refactoringStatusEntryArray = entries = status.getEntries();
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        AbstractRefactorTest.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
        AbstractRefactorTest.checkChanges(rootChange, changeList);
    }

    private static void processTestChanges(List<TestChangeStructure> structureList) throws CoreException {
        for (TestChangeStructure tStructure : structureList) {
            IFile file = tStructure.getProject().getFile(tStructure.getFileName());
            String fileContent = FileUtil.readStream((IFile)file);
            for (TestTextChange tChange : tStructure.getTextChanges()) {
                if (tChange.getOffset() != -1) continue;
                int offset = fileContent.indexOf(tChange.getSearchText());
                tChange.setOffset(offset);
            }
        }
    }

    public static void checkMove(RefactoringProcessor processor, IResource oldObject, IResource destinationObject, MoveParticipant participant, List<TestChangeStructure> changeList) throws CoreException {
        RefactoringStatusEntry[] entries;
        AbstractRefactorTest.processTestChanges(changeList);
        JobUtils.waitForIdle((long)2000L);
        AbstractRefactorTest.checkBeforeRefactoring(changeList);
        MoveArguments arguments = new MoveArguments((Object)destinationObject, true);
        boolean initialized = participant.initialize(processor, (Object)oldObject, (RefactoringArguments)arguments);
        AbstractRefactorTest.assertTrue((String)"Participant has not been initialized", (boolean)initialized);
        RefactoringStatus status = participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        AbstractRefactorTest.assertNull((String)"Move processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change mainChange = processor.createChange((IProgressMonitor)new NullProgressMonitor());
        mainChange.perform((IProgressMonitor)new NullProgressMonitor());
        AbstractRefactorTest.checkChanges(rootChange, changeList);
    }

    public static void checkRename(RefactoringProcessor processor, IResource oldObject, String newName, RenameParticipant participant, List<TestChangeStructure> changeList) throws CoreException {
        RefactoringStatusEntry[] entries;
        AbstractRefactorTest.processTestChanges(changeList);
        JobUtils.waitForIdle((long)2000L);
        AbstractRefactorTest.checkBeforeRefactoring(changeList);
        RenameArguments arguments = new RenameArguments(newName, true);
        boolean initialized = participant.initialize(processor, (Object)oldObject, (RefactoringArguments)arguments);
        AbstractRefactorTest.assertTrue((String)"Participant has not been initialized", (boolean)initialized);
        RefactoringStatus status = participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        AbstractRefactorTest.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change mainChange = processor.createChange((IProgressMonitor)new NullProgressMonitor());
        mainChange.perform((IProgressMonitor)new NullProgressMonitor());
        AbstractRefactorTest.checkChanges(rootChange, changeList);
    }

    public static void checkBeforeRefactoring(List<TestChangeStructure> changeList) {
        for (TestChangeStructure changeStructure : changeList) {
            IFile file = changeStructure.getProject().getFile(changeStructure.getFileName());
            String content = null;
            try {
                content = AbstractRefactorTest.readStream(file);
            }
            catch (CoreException e) {
                e.printStackTrace();
                AbstractRefactorTest.fail((String)e.getMessage());
            }
            for (TestTextChange change : changeStructure.getTextChanges()) {
                AbstractRefactorTest.assertNotSame((Object)change.getText(), (Object)content.substring(change.getOffset(), change.getOffset() + change.getLength()));
            }
        }
    }

    public static void checkChanges(CompositeChange rootChange, List<TestChangeStructure> changeList) throws CoreException {
        AbstractRefactorTest.assertNotNull((String)"Root change is null", (Object)rootChange);
        int numberOfChanges = rootChange.getChildren().length;
        int i = 0;
        while (i < rootChange.getChildren().length) {
            Change fileChange = rootChange.getChildren()[i];
            MultiTextEdit edit = null;
            IFile file = null;
            if (fileChange instanceof TextFileChange) {
                edit = (MultiTextEdit)((TextFileChange)fileChange).getEdit();
                file = ((TextFileChange)fileChange).getFile();
            } else if (fileChange instanceof TextFileChange) {
                edit = (MultiTextEdit)((TextFileChange)fileChange).getEdit();
                file = ((TextFileChange)fileChange).getFile();
            }
            TestChangeStructure testChangeStructure = AbstractRefactorTest.findChange(changeList, file);
            if (testChangeStructure != null) {
                AbstractRefactorTest.assertEquals((int)testChangeStructure.size(), (int)edit.getChildrenSize());
            }
            ++i;
        }
        rootChange.perform((IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle((long)2000L);
        for (TestChangeStructure changeStructure : changeList) {
            IFile file = changeStructure.getProject().getFile(changeStructure.getFileName());
            String content = null;
            content = AbstractRefactorTest.readStream(file);
            for (TestTextChange testTextChange : changeStructure.getTextChanges()) {
                AbstractRefactorTest.assertEquals((String)("There is unexpected change in resource - " + file.getName()), (String)testTextChange.getText(), (String)content.substring(testTextChange.getOffset(), testTextChange.getOffset() + testTextChange.getLength()));
            }
        }
        AbstractRefactorTest.assertEquals((String)"There is unexpected number of changes", (int)changeList.size(), (int)numberOfChanges);
    }

    public static TestChangeStructure findChange(List<TestChangeStructure> changeList, IFile file) {
        for (TestChangeStructure tcs : changeList) {
            if (!tcs.getFileName().equals("/" + file.getFullPath().removeFirstSegments(1).toString())) continue;
            return tcs;
        }
        return null;
    }

    public static String readStream(InputStream is) {
        StringBuffer sb = new StringBuffer("");
        try {
            int l;
            byte[] b = new byte[4096];
            while ((l = is.read(b, 0, b.length)) >= 0) {
                sb.append(new String(b, 0, l));
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractRefactorTest.fail((String)e.getMessage());
        }
        return sb.toString();
    }

    public static String readStream(IFile file) throws CoreException {
        String content = null;
        InputStream in = null;
        try {
            in = file.getContents();
            content = AbstractRefactorTest.readStream(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    AbstractRefactorTest.fail((String)e.getMessage());
                }
            }
        }
        return content;
    }

    public static class TestChangeStructure {
        private IProject project;
        private String fileName;
        ArrayList<TestTextChange> textChanges = new ArrayList();

        public TestChangeStructure(IProject project, String fileName) {
            this.project = project;
            this.fileName = fileName;
        }

        public IProject getProject() {
            return this.project;
        }

        public String getFileName() {
            return this.fileName;
        }

        public ArrayList<TestTextChange> getTextChanges() {
            return this.textChanges;
        }

        public void addTextChange(TestTextChange change) {
            this.textChanges.add(change);
        }

        public int size() {
            return this.textChanges.size();
        }
    }

    public static class TestTextChange {
        private String searchText;
        private int offset;
        private int length;
        private String text;

        public TestTextChange(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public TestTextChange(String searchText, int length, String text) {
            this.offset = -1;
            this.searchText = searchText;
            this.length = length;
            this.text = text;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            return this.text;
        }
    }
}

