/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Base64BinaryValue
extends AtomicValue {
    private byte[] binaryValue;

    public Base64BinaryValue(CharSequence s) throws XPathException {
        Base64Decoder decoder = new Base64Decoder();
        try {
            decoder.translate(s);
        }
        catch (IllegalArgumentException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("FORG0001");
            throw err;
        }
        this.binaryValue = decoder.getByteArray();
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    public Base64BinaryValue(CharSequence s, AtomicType type) {
        Base64Decoder decoder = new Base64Decoder();
        decoder.translate(s);
        this.binaryValue = decoder.getByteArray();
        this.typeLabel = type;
    }

    public Base64BinaryValue(byte[] value) {
        this.binaryValue = value;
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        Base64BinaryValue v = new Base64BinaryValue(this.binaryValue);
        v.typeLabel = typeLabel;
        return v;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BASE64_BINARY;
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 528: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 527: {
                return new HexBinaryValue(this.binaryValue);
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert base64Binary to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    @Override
    public String getPrimitiveStringValue() {
        Base64Encoder encoder = new Base64Encoder();
        encoder.translate(this.binaryValue);
        return new String(encoder.getCharArray());
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    @Override
    public Comparable getSchemaComparable() {
        return new Base64BinaryComparable();
    }

    @Override
    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    @Override
    public boolean equals(Object other) {
        return Arrays.equals(this.binaryValue, ((Base64BinaryValue)other).binaryValue);
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    protected static int byteArrayHashCode(byte[] value) {
        long h = 0L;
        int i = 0;
        while (i < Math.min(value.length, 64)) {
            h = h << 1 ^ (long)value[i];
            ++i;
        }
        return (int)(h >> 32 ^ h);
    }

    private class Base64BinaryComparable
    implements Comparable {
        private Base64BinaryComparable() {
        }

        public Base64BinaryValue getBase64BinaryValue() {
            return Base64BinaryValue.this;
        }

        public int compareTo(Object o) {
            if (o instanceof Base64BinaryComparable && Arrays.equals(this.getBase64BinaryValue().binaryValue, ((Base64BinaryComparable)o).getBase64BinaryValue().binaryValue)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return Base64BinaryValue.this.hashCode();
        }
    }

    private static final class Base64Decoder {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private byte[] token = new byte[4];
        private byte[] bytes = new byte[3];
        private int token_length = 0;
        private static final byte NUL = 127;
        private static final byte EOF = 126;
        private static final byte SP = 125;
        private static final byte[] map;

        static {
            byte[] byArray = new byte[256];
            byArray[0] = 127;
            byArray[1] = 127;
            byArray[2] = 127;
            byArray[3] = 127;
            byArray[4] = 127;
            byArray[5] = 127;
            byArray[6] = 127;
            byArray[7] = 127;
            byArray[8] = 127;
            byArray[9] = 125;
            byArray[10] = 125;
            byArray[11] = 127;
            byArray[12] = 127;
            byArray[13] = 125;
            byArray[14] = 127;
            byArray[15] = 127;
            byArray[16] = 127;
            byArray[17] = 127;
            byArray[18] = 127;
            byArray[19] = 127;
            byArray[20] = 127;
            byArray[21] = 127;
            byArray[22] = 127;
            byArray[23] = 127;
            byArray[24] = 127;
            byArray[25] = 127;
            byArray[26] = 127;
            byArray[27] = 127;
            byArray[28] = 127;
            byArray[29] = 127;
            byArray[30] = 127;
            byArray[31] = 127;
            byArray[32] = 125;
            byArray[33] = 127;
            byArray[34] = 127;
            byArray[35] = 127;
            byArray[36] = 127;
            byArray[37] = 127;
            byArray[38] = 127;
            byArray[39] = 127;
            byArray[40] = 127;
            byArray[41] = 127;
            byArray[42] = 127;
            byArray[43] = 62;
            byArray[44] = 127;
            byArray[45] = 127;
            byArray[46] = 127;
            byArray[47] = 63;
            byArray[48] = 52;
            byArray[49] = 53;
            byArray[50] = 54;
            byArray[51] = 55;
            byArray[52] = 56;
            byArray[53] = 57;
            byArray[54] = 58;
            byArray[55] = 59;
            byArray[56] = 60;
            byArray[57] = 61;
            byArray[58] = 127;
            byArray[59] = 127;
            byArray[60] = 127;
            byArray[61] = 126;
            byArray[62] = 127;
            byArray[63] = 127;
            byArray[64] = 127;
            byArray[66] = 1;
            byArray[67] = 2;
            byArray[68] = 3;
            byArray[69] = 4;
            byArray[70] = 5;
            byArray[71] = 6;
            byArray[72] = 7;
            byArray[73] = 8;
            byArray[74] = 9;
            byArray[75] = 10;
            byArray[76] = 11;
            byArray[77] = 12;
            byArray[78] = 13;
            byArray[79] = 14;
            byArray[80] = 15;
            byArray[81] = 16;
            byArray[82] = 17;
            byArray[83] = 18;
            byArray[84] = 19;
            byArray[85] = 20;
            byArray[86] = 21;
            byArray[87] = 22;
            byArray[88] = 23;
            byArray[89] = 24;
            byArray[90] = 25;
            byArray[91] = 127;
            byArray[92] = 127;
            byArray[93] = 127;
            byArray[94] = 127;
            byArray[95] = 127;
            byArray[96] = 127;
            byArray[97] = 26;
            byArray[98] = 27;
            byArray[99] = 28;
            byArray[100] = 29;
            byArray[101] = 30;
            byArray[102] = 31;
            byArray[103] = 32;
            byArray[104] = 33;
            byArray[105] = 34;
            byArray[106] = 35;
            byArray[107] = 36;
            byArray[108] = 37;
            byArray[109] = 38;
            byArray[110] = 39;
            byArray[111] = 40;
            byArray[112] = 41;
            byArray[113] = 42;
            byArray[114] = 43;
            byArray[115] = 44;
            byArray[116] = 45;
            byArray[117] = 46;
            byArray[118] = 47;
            byArray[119] = 48;
            byArray[120] = 49;
            byArray[121] = 50;
            byArray[122] = 51;
            byArray[123] = 127;
            byArray[124] = 127;
            byArray[125] = 127;
            byArray[126] = 127;
            byArray[127] = 127;
            byArray[128] = 127;
            byArray[129] = 127;
            byArray[130] = 127;
            byArray[131] = 127;
            byArray[132] = 127;
            byArray[133] = 127;
            byArray[134] = 127;
            byArray[135] = 127;
            byArray[136] = 127;
            byArray[137] = 127;
            byArray[138] = 127;
            byArray[139] = 127;
            byArray[140] = 127;
            byArray[141] = 127;
            byArray[142] = 127;
            byArray[143] = 127;
            byArray[144] = 127;
            byArray[145] = 127;
            byArray[146] = 127;
            byArray[147] = 127;
            byArray[148] = 127;
            byArray[149] = 127;
            byArray[150] = 127;
            byArray[151] = 127;
            byArray[152] = 127;
            byArray[153] = 127;
            byArray[154] = 127;
            byArray[155] = 127;
            byArray[156] = 127;
            byArray[157] = 127;
            byArray[158] = 127;
            byArray[159] = 127;
            byArray[160] = 127;
            byArray[161] = 127;
            byArray[162] = 127;
            byArray[163] = 127;
            byArray[164] = 127;
            byArray[165] = 127;
            byArray[166] = 127;
            byArray[167] = 127;
            byArray[168] = 127;
            byArray[169] = 127;
            byArray[170] = 127;
            byArray[171] = 127;
            byArray[172] = 127;
            byArray[173] = 127;
            byArray[174] = 127;
            byArray[175] = 127;
            byArray[176] = 127;
            byArray[177] = 127;
            byArray[178] = 127;
            byArray[179] = 127;
            byArray[180] = 127;
            byArray[181] = 127;
            byArray[182] = 127;
            byArray[183] = 127;
            byArray[184] = 127;
            byArray[185] = 127;
            byArray[186] = 127;
            byArray[187] = 127;
            byArray[188] = 127;
            byArray[189] = 127;
            byArray[190] = 127;
            byArray[191] = 127;
            byArray[192] = 127;
            byArray[193] = 127;
            byArray[194] = 127;
            byArray[195] = 127;
            byArray[196] = 127;
            byArray[197] = 127;
            byArray[198] = 127;
            byArray[199] = 127;
            byArray[200] = 127;
            byArray[201] = 127;
            byArray[202] = 127;
            byArray[203] = 127;
            byArray[204] = 127;
            byArray[205] = 127;
            byArray[206] = 127;
            byArray[207] = 127;
            byArray[208] = 127;
            byArray[209] = 127;
            byArray[210] = 127;
            byArray[211] = 127;
            byArray[212] = 127;
            byArray[213] = 127;
            byArray[214] = 127;
            byArray[215] = 127;
            byArray[216] = 127;
            byArray[217] = 127;
            byArray[218] = 127;
            byArray[219] = 127;
            byArray[220] = 127;
            byArray[221] = 127;
            byArray[222] = 127;
            byArray[223] = 127;
            byArray[224] = 127;
            byArray[225] = 127;
            byArray[226] = 127;
            byArray[227] = 127;
            byArray[228] = 127;
            byArray[229] = 127;
            byArray[230] = 127;
            byArray[231] = 127;
            byArray[232] = 127;
            byArray[233] = 127;
            byArray[234] = 127;
            byArray[235] = 127;
            byArray[236] = 127;
            byArray[237] = 127;
            byArray[238] = 127;
            byArray[239] = 127;
            byArray[240] = 127;
            byArray[241] = 127;
            byArray[242] = 127;
            byArray[243] = 127;
            byArray[244] = 127;
            byArray[245] = 127;
            byArray[246] = 127;
            byArray[247] = 127;
            byArray[248] = 127;
            byArray[249] = 127;
            byArray[250] = 127;
            byArray[251] = 127;
            byArray[252] = 127;
            byArray[253] = 127;
            byArray[254] = 127;
            byArray[255] = 127;
            map = byArray;
        }

        private Base64Decoder() {
        }

        private void decode_token() {
            int num = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
            this.bytes[0] = (byte)(0xFF & num >> 16);
            this.bytes[1] = (byte)(0xFF & num >> 8);
            this.bytes[2] = (byte)(0xFF & num);
            this.out.write(this.bytes, 0, 3);
        }

        private void decode_final_token() {
            byte b0 = this.token[0];
            byte b1 = this.token[1];
            byte b2 = this.token[2];
            byte b3 = this.token[3];
            int eq_count = 0;
            if (b0 == 126) {
                b0 = 0;
                ++eq_count;
            }
            if (b1 == 126) {
                b1 = 0;
                ++eq_count;
            }
            if (b2 == 126) {
                b2 = 0;
                ++eq_count;
            }
            if (b3 == 126) {
                b3 = 0;
                ++eq_count;
            }
            if (eq_count > 2) {
                throw new IllegalArgumentException("The number of '=' signs at the end of a base64 value must not exceed 2");
            }
            if (eq_count == 2 && (b1 & 0xF) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '==' then the last character must be one of [AQgw]");
            }
            if (eq_count == 1 && (b2 & 3) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '=' then the last character must be one of [AEIMQUYcgkosw048]");
            }
            int num = b0 << 18 | b1 << 12 | b2 << 6 | b3;
            this.out.write((byte)(num >> 16));
            if (eq_count <= 1) {
                this.out.write((byte)(num >> 8 & 0xFF));
                if (eq_count == 0) {
                    this.out.write((byte)(num & 0xFF));
                }
            }
        }

        public final void translate(CharSequence str) throws IllegalArgumentException {
            if (this.token == null) {
                return;
            }
            int length = str.length();
            int found_eq = 0;
            int i = 0;
            while (i < length) {
                char c = str.charAt(i);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("non-ASCII character in Base64 value (at offset " + i + ')');
                }
                byte t = map[c];
                if (t == 127) {
                    throw new IllegalArgumentException("invalid character '" + c + "' in Base64 value (at offset " + i + ')');
                }
                if (found_eq > 0 && t != 126 && t != 125) {
                    throw new IllegalArgumentException("In Base64, an '=' character can appear only at the end");
                }
                if (t == 126) {
                    if (found_eq > 0) {
                        if (++found_eq > 2) {
                            throw new IllegalArgumentException("Base64 value can contain at most two '=' characters");
                        }
                        this.token_length = (this.token_length + 1) % 4;
                    } else {
                        found_eq = 1;
                        int lengthAtEOF = this.token_length;
                        this.eof();
                        this.token_length = (lengthAtEOF + 1) % 4;
                    }
                } else if (t != 125) {
                    this.token[this.token_length++] = t;
                    if (this.token_length == 4) {
                        if (found_eq == 0) {
                            this.decode_token();
                        }
                        this.token_length = 0;
                    }
                }
                ++i;
            }
            if (this.token_length != 0) {
                throw new IllegalArgumentException("Base64 input must be a multiple of four characters");
            }
        }

        private void eof() {
            if (this.token != null && this.token_length != 0) {
                while (this.token_length < 4) {
                    this.token[this.token_length++] = 126;
                }
                this.decode_final_token();
            }
            this.token_length = 0;
            this.token = new byte[4];
            this.bytes = new byte[3];
        }

        public byte[] getByteArray() {
            this.eof();
            return this.out.toByteArray();
        }
    }

    private static final class Base64Encoder {
        private FastStringBuffer out = new FastStringBuffer(256);
        private int buf = 0;
        private int buf_bytes = 0;
        private char[] line = new char[74];
        private int line_length = 0;
        private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        private Base64Encoder() {
        }

        private void encode_token() {
            int i = this.line_length;
            this.line[i] = map[0x3F & this.buf >> 18];
            this.line[i + 1] = map[0x3F & this.buf >> 12];
            this.line[i + 2] = map[0x3F & this.buf >> 6];
            this.line[i + 3] = map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void encode_partial_token() {
            int i = this.line_length;
            this.line[i] = map[0x3F & this.buf >> 18];
            this.line[i + 1] = map[0x3F & this.buf >> 12];
            this.line[i + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
            this.line[i + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void flush_line() {
            this.out.append(this.line, 0, this.line_length);
            this.line_length = 0;
        }

        public final void translate(byte[] in) {
            int in_length = in.length;
            int i = 0;
            while (i < in_length) {
                this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | in[i] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | in[i] << 8 & 0xFFFF : this.buf & 0xFFFF00 | in[i] & 0xFF);
                if (++this.buf_bytes == 3) {
                    this.encode_token();
                    if (this.line_length >= 72) {
                        this.flush_line();
                    }
                }
                if (i == in_length - 1) {
                    if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                        this.encode_partial_token();
                    }
                    if (this.line_length > 0) {
                        this.flush_line();
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.line.length) {
                this.line[i] = '\u0000';
                ++i;
            }
        }

        public char[] getCharArray() {
            if (this.buf_bytes != 0) {
                this.encode_partial_token();
            }
            this.flush_line();
            int i = 0;
            while (i < this.line.length) {
                this.line[i] = '\u0000';
                ++i;
            }
            char[] ch = new char[this.out.length()];
            if (this.out.length() > 0) {
                this.out.getChars(0, this.out.length(), ch, 0);
            }
            return ch;
        }
    }
}

