/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.FastStringBuffer;

public class ProcInstParser {
    private ProcInstParser() {
    }

    public static String getPseudoAttribute(String content, String name) {
        int pos = 0;
        while (pos <= content.length() - 4) {
            int nextQuote = -1;
            int q = pos;
            while (q < content.length()) {
                if (content.charAt(q) == '\"' || content.charAt(q) == '\'') {
                    nextQuote = q;
                    break;
                }
                ++q;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = content.indexOf(content.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = content.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                int s = nextName + name.length();
                while (s < nextQuote) {
                    char c = content.charAt(s);
                    if (!Character.isWhitespace(c) && c != '=') {
                        found = false;
                        break;
                    }
                    ++s;
                }
                if (found) {
                    String val = content.substring(nextQuote + 1, closingQuote);
                    String u = ProcInstParser.unescape(val);
                    if (u == null) {
                        return val;
                    }
                    return u;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        FastStringBuffer sb = new FastStringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '&') {
                if (i + 2 < value.length() && value.charAt(i + 1) == '#') {
                    int digit;
                    int charval;
                    int x;
                    if (value.charAt(i + 2) == 'x') {
                        x = i + 3;
                        charval = 0;
                        while (x < value.length() && value.charAt(x) != ';') {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                            ++x;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                    } else {
                        x = i + 2;
                        charval = 0;
                        while (x < value.length() && value.charAt(x) != ';') {
                            digit = "0123456789".indexOf(value.charAt(x));
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 10 + digit;
                            ++x;
                        }
                        char decchar = (char)charval;
                        sb.append(decchar);
                        i = x;
                    }
                } else if (value.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                } else if (value.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                } else if (value.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                } else if (value.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                } else {
                    if (!value.substring(i + 1).startsWith("apos;")) return null;
                    sb.append('\'');
                    i += 5;
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

