/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.Serializable;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class Stripper
extends ProxyReceiver {
    public static final RuleTarget STRIP = new StripRuleTarget(){};
    public static final RuleTarget PRESERVE = new StripRuleTarget(){};
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private Orphan element;
    private XPathContext context;
    public static final byte ALWAYS_PRESERVE = 1;
    public static final byte ALWAYS_STRIP = 2;
    public static final byte STRIP_DEFAULT = 0;
    public static final byte PRESERVE_PARENT = 4;
    public static final byte CANNOT_STRIP = 8;

    protected Stripper() {
    }

    public Stripper(Mode stripperRules) {
        this.stripperMode = stripperRules;
        this.preserveAll = stripperRules == null;
        this.stripAll = false;
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public Stripper getAnother() {
        Stripper clone = new Stripper(this.stripperMode);
        clone.setPipelineConfiguration(this.getPipelineConfiguration());
        clone.stripAll = this.stripAll;
        clone.preserveAll = this.preserveAll;
        return clone;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (pipe != null) {
            Controller controller;
            super.setPipelineConfiguration(pipe);
            if (this.context == null && (controller = pipe.getController()) != null) {
                this.context = controller.newXPathContext();
            }
            if (this.element == null) {
                this.element = new Orphan(pipe.getConfiguration());
                this.element.setNodeKind((short)1);
            }
        }
    }

    public byte isSpacePreserving(int nameCode) throws XPathException {
        if (this.preserveAll) {
            return 1;
        }
        if (this.stripAll) {
            return 0;
        }
        this.element.setNameCode(nameCode);
        Rule rule = this.stripperMode.getRule(this.element, this.context);
        if (rule == null) {
            return 1;
        }
        return rule.getAction() == PRESERVE ? (byte)1 : 0;
    }

    public byte isSpacePreserving(NodeInfo element) throws XPathException {
        if (this.preserveAll) {
            return 1;
        }
        if (this.stripAll) {
            return 0;
        }
        Rule rule = this.stripperMode.getRule(element, this.context);
        if (rule == null) {
            return 1;
        }
        return rule.getAction() == PRESERVE ? (byte)1 : 0;
    }

    @Override
    public void open() throws XPathException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.open();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        SchemaType type;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        byte preserveParent = this.stripStack[this.top];
        byte preserve = (byte)(preserveParent & 4);
        byte elementStrip = this.isSpacePreserving(nameCode);
        if (elementStrip == 1) {
            preserve = (byte)(preserve | 1);
        } else if (elementStrip == 2) {
            preserve = (byte)(preserve | 2);
        }
        if (preserve == 0 && typeCode != -1 && typeCode != 630 && ((type = this.getConfiguration().getSchemaType(typeCode)).isSimpleType() || ((ComplexType)type).isSimpleContent())) {
            preserve = (byte)(preserve | 8);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] newStack = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, newStack, 0, this.top);
            this.stripStack = newStack;
        }
        this.stripStack[this.top] = preserve;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if ((nameCode & 0xFFFFF) == 386) {
            if (value.toString().equals("preserve")) {
                int n = this.top;
                this.stripStack[n] = (byte)(this.stripStack[n] | 4);
            } else {
                int n = this.top;
                this.stripStack[n] = (byte)(this.stripStack[n] & 0xFFFFFFFB);
            }
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        --this.top;
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (((this.stripStack[this.top] & 0xD) != 0 && (this.stripStack[this.top] & 2) == 0 || !Whitespace.isWhite(chars)) && chars.length() > 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private static class StripRuleTarget
    implements RuleTarget,
    Serializable {
        private StripRuleTarget() {
        }

        @Override
        public void explain(ExpressionPresenter presenter) {
        }
    }
}

