/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSender
implements SaxonLocator,
SourceLocationProvider {
    private Receiver receiver;
    private PipelineConfiguration pipe;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private HashMap<String, String> nsDeclarations = new HashMap(10);
    protected Node root = null;
    protected String systemId;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setStartNode(Node start) {
        this.root = start;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void send() throws XPathException {
        if (this.root == null) {
            throw new XPathException("DOMSender: no start node defined");
        }
        if (this.receiver == null) {
            throw new XPathException("DOMSender: no receiver defined");
        }
        this.receiver.setSystemId(this.systemId);
        this.pipe.setLocationProvider(this);
        this.receiver.setPipelineConfiguration(this.pipe);
        this.receiver.open();
        switch (this.root.getNodeType()) {
            case 9: 
            case 11: {
                this.receiver.startDocument(0);
                this.walkNode(this.root);
                this.receiver.endDocument();
                break;
            }
            case 1: {
                this.sendElement((Element)this.root);
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters(((CharacterData)this.root).getData(), 0, 0);
                break;
            }
            case 8: {
                this.receiver.comment(((Comment)this.root).getData(), 0, 0);
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)this.root).getTarget(), ((ProcessingInstruction)this.root).getData(), 0, 0);
                break;
            }
            default: {
                throw new XPathException("DOMSender: unsupported kind of start node (" + this.root.getNodeType() + ")");
            }
        }
        this.receiver.close();
    }

    private void sendElement(Element startNode) throws XPathException {
        Element node = startNode;
        NamedNodeMap topAtts = this.gatherNamespaces(node, false);
        while (true) {
            this.gatherNamespaces(node, true);
            Node parent = node.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            node = (Element)parent;
        }
        this.outputElement(startNode, topAtts);
    }

    private void walkNode(Node node) throws XPathException {
        if (node.hasChildNodes()) {
            NodeList nit = node.getChildNodes();
            int len = nit.getLength();
            int i = 0;
            while (i < len) {
                Node child = nit.item(i);
                switch (child.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 1: {
                        Element element = (Element)child;
                        NamedNodeMap atts = this.gatherNamespaces(element, false);
                        this.outputElement(element, atts);
                        this.nsSupport.popContext();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData(), 0, 0);
                        break;
                    }
                    case 8: {
                        String text = ((Comment)child).getData();
                        if (text == null) break;
                        this.receiver.comment(text, 0, 0);
                        break;
                    }
                    case 3: 
                    case 4: {
                        String text = ((CharacterData)child).getData();
                        if (text == null) break;
                        this.receiver.characters(text, 0, 0);
                        break;
                    }
                    case 5: {
                        this.walkNode(child);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void outputElement(Element element, NamedNodeMap atts) throws XPathException {
        Configuration config = this.pipe.getConfiguration();
        String[] elparts2 = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (elparts2 == null) {
            throw new XPathException("Undeclared namespace in " + element.getTagName());
        }
        String uri = elparts2[0];
        String local = elparts2[1];
        String prefix = NameChecker.getPrefix(elparts2[2]);
        NamePool namePool = config.getNamePool();
        int nameCode = namePool.allocate(prefix, uri, local);
        this.receiver.startElement(nameCode, 630, 0, 0);
        for (String nsprefix : this.nsDeclarations.keySet()) {
            String nsuri = this.nsDeclarations.get(nsprefix);
            this.receiver.namespace(namePool.allocateNamespaceCode(nsprefix, nsuri), 0);
        }
        if (atts != null) {
            int len = atts.getLength();
            int a2 = 0;
            while (a2 < len) {
                Attr att = (Attr)atts.item(a2);
                String attname = att.getName();
                if (!attname.startsWith("xmlns") || !attname.equals("xmlns") && !attname.startsWith("xmlns:")) {
                    String[] parts2 = this.nsSupport.processName(attname, this.parts, true);
                    if (parts2 == null) {
                        throw new XPathException("Undeclared namespace in " + attname);
                    }
                    String atturi = parts2[0];
                    String attlocal = parts2[1];
                    String attprefix = NameChecker.getPrefix(parts2[2]);
                    int attCode = namePool.allocate(attprefix, atturi, attlocal);
                    this.receiver.attribute(attCode, 631, att.getValue(), 0, 0);
                }
                ++a2;
            }
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private NamedNodeMap gatherNamespaces(Element element, boolean cumulative) {
        NamedNodeMap atts;
        if (!cumulative) {
            this.nsSupport.pushContext();
            this.attlist.clear();
            this.nsDeclarations.clear();
        }
        try {
            String prefix = element.getPrefix();
            String uri = element.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            if (this.nsDeclarations.get(prefix) == null) {
                this.nsSupport.declarePrefix(prefix, uri);
                this.nsDeclarations.put(prefix, uri);
            }
        }
        catch (Throwable throwable) {}
        if ((atts = element.getAttributes()) == null) {
            return null;
        }
        int alen = atts.getLength();
        int a1 = 0;
        while (a1 < alen) {
            String uri;
            String prefix;
            Attr att = (Attr)atts.item(a1);
            String attname = att.getName();
            if (attname.equals("xmlns")) {
                String uri2 = att.getValue();
                if (this.nsDeclarations.get("") == null || !cumulative && !this.nsDeclarations.get("").equals(uri2)) {
                    this.nsSupport.declarePrefix("", uri2);
                    this.nsDeclarations.put("", uri2);
                }
            } else if (attname.startsWith("xmlns:")) {
                prefix = attname.substring(6);
                if (this.nsDeclarations.get(prefix) == null) {
                    uri = att.getValue();
                    this.nsSupport.declarePrefix(prefix, uri);
                    this.nsDeclarations.put(prefix, uri);
                }
            } else if (attname.indexOf(58) >= 0) {
                try {
                    prefix = att.getPrefix();
                    uri = att.getNamespaceURI();
                    if (this.nsDeclarations.get(prefix) == null) {
                        this.nsSupport.declarePrefix(prefix, uri);
                        this.nsDeclarations.put(prefix, uri);
                    }
                }
                catch (Throwable throwable) {}
            }
            ++a1;
        }
        return atts;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }
}

