/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.type.Type;
import org.jboss.tools.birt.oda.IOdaFactory;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.DataTypes;
import org.jboss.tools.birt.oda.impl.HibernateOdaQuery;
import org.jboss.tools.birt.oda.impl.HibernateParameterMetaData;
import org.jboss.tools.birt.oda.impl.HibernateResult;
import org.jboss.tools.birt.oda.impl.HibernateResultSetMetaData;
import org.jboss.tools.birt.oda.impl.Parameter;

public abstract class AbstractOdaFactory
implements IOdaFactory {
    protected SessionFactory sessionFactory;
    private int maxRows;
    private String queryText;

    public void close() {
    }

    public boolean isOpen() {
        return this.getSessionFactory() != null;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public HibernateResultSetMetaData prepare(String queryText, Session session) throws OdaException {
        this.queryText = queryText;
        return this.parseQuery(session);
    }

    private HibernateResultSetMetaData parseQuery(Session session) throws OdaException {
        ArrayList<String> arColsType = new ArrayList<String>();
        ArrayList<String> arCols = new ArrayList<String>();
        ArrayList<String> arColClass = new ArrayList<String>();
        String[] props = null;
        try {
            Query query = session.createQuery(this.queryText);
            int maxRows = this.getMaxRows();
            if (maxRows > 0) {
                query.setFirstResult(0);
                query.setMaxResults(maxRows);
            }
            this.maxRows = maxRows;
            Type[] qryReturnTypes = query.getReturnTypes();
            if (qryReturnTypes.length > 0 && qryReturnTypes[0].isEntityType()) {
                int j = 0;
                while (j < qryReturnTypes.length) {
                    String clsName = qryReturnTypes[j].getName();
                    props = this.getHibernateProp(clsName);
                    int x = 0;
                    while (x < props.length) {
                        String propType = this.getHibernatePropTypes(clsName, props[x]);
                        if (DataTypes.isValidType(propType)) {
                            arColsType.add(propType);
                            arCols.add(props[x]);
                            arColClass.add(clsName);
                        } else {
                            arColsType.add("UNKNOWN");
                            arCols.add(props[x]);
                            arColClass.add("java.lang.String");
                        }
                        ++x;
                    }
                    ++j;
                }
            } else {
                props = AbstractOdaFactory.extractColumns(query.getQueryString());
                int t = 0;
                while (t < qryReturnTypes.length) {
                    if (!DataTypes.isValidType(qryReturnTypes[t].getName())) {
                        throw new OdaException(NLS.bind((String)Messages.AbstractOdaFactory_The_type_is_not_valid, (Object)qryReturnTypes[t].getName()));
                    }
                    arColsType.add(qryReturnTypes[t].getName());
                    arCols.add(props[t]);
                    ++t;
                }
            }
            String[] arLabels = arCols.toArray(new String[arCols.size()]);
            int j = 0;
            while (j < arLabels.length) {
                arLabels[j] = arLabels[j].replace('.', ':');
                ++j;
            }
            return new HibernateResultSetMetaData(arLabels, arColsType.toArray(new String[arColsType.size()]), arLabels, arColClass.toArray(new String[arColClass.size()]));
        }
        catch (Exception e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    private static String[] extractColumns(String query) {
        int fromPosition = query.toLowerCase().indexOf("from");
        int selectPosition = query.toLowerCase().indexOf("select");
        if (selectPosition >= 0) {
            String columns = query.substring(selectPosition + 6, fromPosition);
            StringTokenizer st = new StringTokenizer(columns, ",");
            ArrayList<String> columnList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                columnList.add(st.nextToken().trim());
            }
            return columnList.toArray(new String[0]);
        }
        return null;
    }

    private String[] getHibernateProp(String className) {
        SessionFactory sf = this.getSessionFactory();
        String[] properties = sf.getClassMetadata(className).getPropertyNames();
        return properties;
    }

    private String getHibernatePropTypes(String className, String property) {
        SessionFactory sf = this.getSessionFactory();
        Type hibClassProps = sf.getClassMetadata(className).getPropertyType(property);
        return hibClassProps.getName();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public HibernateResult executeQuery(HibernateOdaQuery query, Session session) throws OdaException {
        try {
            Query q = session.createQuery(this.queryText);
            HibernateParameterMetaData parameterMetaData = (HibernateParameterMetaData)query.getParameterMetaData();
            List<Parameter> parameters = parameterMetaData.getParameters();
            int position = 0;
            SessionFactoryImpl sfimpl = (SessionFactoryImpl)this.sessionFactory;
            HQLQueryPlan plan = new HQLQueryPlan(this.queryText, false, Collections.EMPTY_MAP, (SessionFactoryImplementor)sfimpl);
            int pCount = plan.getParameterMetadata().getOrdinalParameterCount();
            if (pCount > 0) {
                for (Parameter parameter : parameters) {
                    q.setParameter(position++, parameter.getValue(), parameter.getHibernateType());
                    if (position >= pCount) break;
                }
            }
            HibernateResult hibernateResult = new HibernateResult(q, this, query);
            return hibernateResult;
        }
        catch (HibernateException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }
}

