/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;

public class RelationalProcedure
extends RelationalReference {
    public static final String KEY_FUNCTION = "FUNCTION";
    public static final String KEY_UPDATE_COUNT = "UPDATECOUNT";
    public static final boolean DEFAULT_FUNCTION = false;
    public static final String DEFAULT_UPDATE_COUNT = "AUTO";
    public static final String DEFAULT_DATATYPE = "string";
    private boolean nonPrepared = false;
    private boolean deterministic = false;
    private boolean returnsNullOnNull = false;
    private boolean variableArguments = false;
    private boolean aggregate = false;
    private boolean allowsDistinct = false;
    private boolean allowsOrderBy = false;
    private boolean analytic = false;
    private boolean decomposable = false;
    private boolean useDistinctRows = false;
    private String nativeQuery;
    private String javaClass;
    private String javaMethod;
    private String udfJarPath;
    private String functionCategory;
    boolean nativeQueryProcedure;
    PROCEDURE_TYPE procedureType;
    private String updateCount;
    private List<RelationalParameter> parameters;
    private RelationalProcedureResultSet resultSet;

    public RelationalProcedure() {
        this.setType(5);
        this.parameters = new ArrayList<RelationalParameter>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(true, true));
    }

    public RelationalProcedure(String name) {
        super(name);
        this.setType(5);
        this.parameters = new ArrayList<RelationalParameter>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(true, true));
    }

    public String getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(String updateCount) {
        this.updateCount = updateCount;
    }

    public boolean isNonPrepared() {
        return this.nonPrepared;
    }

    public void setNonPrepared(boolean nonPrepared) {
        this.nonPrepared = nonPrepared;
    }

    public boolean isFunction() {
        return this.procedureType == PROCEDURE_TYPE.FUNCTION;
    }

    public void setFunction(boolean function) {
        if (function) {
            this.setProcedureType(PROCEDURE_TYPE.FUNCTION);
        } else {
            this.setProcedureType(PROCEDURE_TYPE.PROCEDURE);
        }
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isReturnsNullOnNull() {
        return this.returnsNullOnNull;
    }

    public void setReturnsNullOnNull(boolean returnsNullOnNull) {
        this.returnsNullOnNull = returnsNullOnNull;
    }

    public boolean isVariableArguments() {
        return this.variableArguments;
    }

    public void setVariableArguments(boolean variableArguments) {
        this.variableArguments = variableArguments;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public boolean isAllowsDistinct() {
        return this.allowsDistinct;
    }

    public void setAllowsDistinct(boolean allowsDistinct) {
        this.allowsDistinct = allowsDistinct;
    }

    public boolean isAllowsOrderBy() {
        return this.allowsOrderBy;
    }

    public void setAllowsOrderBy(boolean allowsOrderBy) {
        this.allowsOrderBy = allowsOrderBy;
    }

    public boolean isAnalytic() {
        return this.analytic;
    }

    public void setAnalytic(boolean analytic) {
        this.analytic = analytic;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public void setDecomposable(boolean decomposable) {
        this.decomposable = decomposable;
    }

    public boolean isUseDistinctRows() {
        return this.useDistinctRows;
    }

    public void setUseDistinctRows(boolean useDistinctRows) {
        this.useDistinctRows = useDistinctRows;
    }

    public boolean isSourceFunction() {
        return this.procedureType == PROCEDURE_TYPE.SOURCE_FUNCTION;
    }

    public boolean isNativeQueryProcedure() {
        return this.procedureType == PROCEDURE_TYPE.NATIVE_QUERY_PROCEDURE;
    }

    public PROCEDURE_TYPE getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(PROCEDURE_TYPE type) {
        this.procedureType = type;
    }

    public String getJavaClassName() {
        return this.javaClass;
    }

    public void setJavaClassName(String javaClassName) {
        if (StringUtilities.areDifferent((String)this.javaClass, (String)javaClassName)) {
            this.javaClass = javaClassName;
            this.handleInfoChanged();
        }
    }

    public String getJavaMethodName() {
        return this.javaMethod;
    }

    public void setJavaMethodName(String javaMethodName) {
        if (StringUtilities.areDifferent((String)this.javaMethod, (String)javaMethodName)) {
            this.javaMethod = javaMethodName;
            this.handleInfoChanged();
        }
    }

    public String getUdfJarPath() {
        return this.udfJarPath;
    }

    public void setUdfJarPath(String udfJarPath) {
        if (StringUtilities.areDifferent((String)this.udfJarPath, (String)udfJarPath)) {
            this.udfJarPath = udfJarPath;
            this.handleInfoChanged();
        }
    }

    public String getFunctionCategory() {
        return this.functionCategory;
    }

    public void setFunctionCategory(String category) {
        if (StringUtilities.areDifferent((String)this.functionCategory, (String)category)) {
            this.functionCategory = category;
            this.handleInfoChanged();
        }
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String newQuery) {
        if (StringUtilities.areDifferent((String)this.nativeQuery, (String)newQuery)) {
            this.nativeQuery = newQuery;
            this.handleInfoChanged();
        }
    }

    public RelationalProcedureResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(RelationalProcedureResultSet resultSet) {
        if (this.resultSet != null) {
            this.resultSet.setParent(null);
        }
        this.resultSet = resultSet;
        if (this.resultSet != null) {
            this.resultSet.setParent(this);
        }
    }

    public List<RelationalParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(RelationalParameter parameter) {
        if (this.parameters.add(parameter)) {
            parameter.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeParameter(RelationalParameter parameter) {
        if (this.parameters.remove(parameter)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public RelationalParameter createParameter() {
        return this.createParameter(DEFAULT_DATATYPE, 4000);
    }

    public RelationalParameter createParameter(String datatype, int length) {
        return this.createParameter("newParameter_" + (this.getParameters().size() + 1), datatype, length);
    }

    public RelationalParameter createParameter(String name, String datatype, int length) {
        RelationalParameter newParameter = new RelationalParameter(name);
        newParameter.setDatatype(datatype);
        newParameter.setLength(length);
        this.addParameter(newParameter);
        return newParameter;
    }

    public boolean canMoveParameterUp(RelationalParameter parameter) {
        return this.getParameterIndex(parameter) > 0;
    }

    public boolean canMoveParameterDown(RelationalParameter parameter) {
        return this.getParameterIndex(parameter) < this.getParameters().size() - 1;
    }

    private int getParameterIndex(RelationalParameter parameter) {
        int i = 0;
        for (RelationalParameter existingParameter : this.getParameters()) {
            if (existingParameter == parameter) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveParameterUp(RelationalParameter theParameter) {
        int startIndex = this.getParameterIndex(theParameter);
        if (startIndex > 0) {
            RelationalParameter[] existingParameters = this.getParameters().toArray(new RelationalParameter[0]);
            RelationalParameter priorParameter = existingParameters[startIndex - 1];
            existingParameters[startIndex - 1] = theParameter;
            existingParameters[startIndex] = priorParameter;
            ArrayList<RelationalParameter> newParameters = new ArrayList<RelationalParameter>(existingParameters.length);
            RelationalParameter[] relationalParameterArray = existingParameters;
            int n = existingParameters.length;
            int n2 = 0;
            while (n2 < n) {
                RelationalParameter info = relationalParameterArray[n2];
                newParameters.add(info);
                ++n2;
            }
            this.parameters = newParameters;
        }
    }

    public void moveParameterDown(RelationalParameter theParameter) {
        int startIndex = this.getParameterIndex(theParameter);
        if (startIndex < this.getParameters().size() - 1) {
            RelationalParameter[] existingParameters = this.getParameters().toArray(new RelationalParameter[0]);
            RelationalParameter afterParameter = existingParameters[startIndex + 1];
            existingParameters[startIndex + 1] = theParameter;
            existingParameters[startIndex] = afterParameter;
            ArrayList<RelationalParameter> newParameters = new ArrayList<RelationalParameter>(existingParameters.length);
            RelationalParameter[] relationalParameterArray = existingParameters;
            int n = existingParameters.length;
            int n2 = 0;
            while (n2 < n) {
                RelationalParameter info = relationalParameterArray[n2];
                newParameters.add(info);
                ++n2;
            }
            this.parameters = newParameters;
        }
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_FUNCTION)) {
                if (!Boolean.parseBoolean(value)) continue;
                this.setProcedureType(PROCEDURE_TYPE.FUNCTION);
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_UPDATE_COUNT)) continue;
            this.setUpdateCount(value);
        }
    }

    @Override
    public void handleInfoChanged() {
        super.handleInfoChanged();
        if (this.isFunction()) {
            if (this.functionCategory != null) {
                this.getExtensionProperties().put("function-category", this.functionCategory);
            } else {
                this.getExtensionProperties().remove("function-category");
            }
            if (this.javaClass != null) {
                this.getExtensionProperties().put("java-class", this.javaClass);
            } else {
                this.getExtensionProperties().remove("java-class");
            }
            if (this.javaMethod != null) {
                this.getExtensionProperties().put("java-method", this.javaMethod);
            } else {
                this.getExtensionProperties().remove("java-method");
            }
            if (this.udfJarPath != null) {
                this.getExtensionProperties().put("udfJarPath", this.udfJarPath);
            } else {
                this.getExtensionProperties().remove("udfJarPath");
            }
            this.getExtensionProperties().put("aggregate", Boolean.toString(this.isAggregate()));
            this.getExtensionProperties().put("varargs", Boolean.toString(this.isVariableArguments()));
            this.getExtensionProperties().put("deterministic", Boolean.toString(this.isDeterministic()));
            this.getExtensionProperties().put("null-on-null", Boolean.toString(this.isReturnsNullOnNull()));
            if (this.isAggregate()) {
                this.getExtensionProperties().remove("analytic");
                this.getExtensionProperties().remove("allows-orderby");
                this.getExtensionProperties().remove("uses-distinct-rows");
                this.getExtensionProperties().remove("decomposable");
                this.getExtensionProperties().remove("allows-distinct");
            } else {
                this.getExtensionProperties().put("analytic", Boolean.toString(this.isAnalytic()));
                this.getExtensionProperties().put("allows-orderby", Boolean.toString(this.isAllowsOrderBy()));
                this.getExtensionProperties().put("uses-distinct-rows", Boolean.toString(this.isUseDistinctRows()));
                this.getExtensionProperties().put("decomposable", Boolean.toString(this.isDecomposable()));
                this.getExtensionProperties().put("allows-distinct", Boolean.toString(this.isAllowsDistinct()));
            }
            this.getExtensionProperties().remove("native-query");
        } else {
            if (this.nativeQuery != null) {
                this.getExtensionProperties().put("native-query", this.nativeQuery);
            } else {
                this.getExtensionProperties().remove("native-query");
            }
            this.getExtensionProperties().put("non-prepared", Boolean.toString(this.isNonPrepared()));
            this.getExtensionProperties().remove("deterministic");
            this.getExtensionProperties().remove("java-class");
            this.getExtensionProperties().remove("java-method");
            this.getExtensionProperties().remove("function-category");
            this.getExtensionProperties().remove("udfJarPath");
            this.getExtensionProperties().remove("varargs");
            this.getExtensionProperties().remove("null-on-null");
            this.getExtensionProperties().remove("aggregate");
            this.getExtensionProperties().remove("analytic");
            this.getExtensionProperties().remove("allows-orderby");
            this.getExtensionProperties().remove("uses-distinct-rows");
            this.getExtensionProperties().remove("decomposable");
            this.getExtensionProperties().remove("allows-distinct");
        }
    }

    @Override
    public void validate() {
        super.validate();
        for (RelationalParameter param : this.getParameters()) {
            param.validate();
        }
        if (this.getStatus().getSeverity() == 4) {
            return;
        }
        for (RelationalParameter param : this.getParameters()) {
            if (param.getStatus().getSeverity() != 4) continue;
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", param.getStatus().getMessage()));
            return;
        }
        for (RelationalParameter outerParam : this.getParameters()) {
            for (RelationalParameter innerParam : this.getParameters()) {
                if (outerParam == innerParam || !outerParam.getName().equalsIgnoreCase(innerParam.getName())) continue;
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_duplicateParameterNamesInProcedure, (Object)this.getName())));
                return;
            }
        }
        if (this.getParameters().isEmpty()) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", Messages.validate_warning_noParametersDefined));
        }
        if (this.isFunction()) {
            boolean foundResultParam = false;
            for (RelationalParameter param : this.getParameters()) {
                if (!param.getDirection().equalsIgnoreCase("RETURN")) continue;
                if (foundResultParam) {
                    this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_error_tooManyResultParametersInFunction));
                    return;
                }
                foundResultParam = true;
            }
            if (this.isSourceFunction()) {
                if (this.getResultSet() != null) {
                    this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_noResultSetAllowedInFunction));
                    return;
                }
            } else {
                if (this.functionCategory == null || this.functionCategory.trim().length() == 0) {
                    this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_categoryUndefinedForUDF));
                    return;
                }
                if (this.javaClass == null || this.javaClass.trim().length() == 0) {
                    this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_javaClassUndefinedForUDF));
                    return;
                }
                if (this.javaMethod == null || this.javaMethod.trim().length() == 0) {
                    this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_javaMethodUndefinedForUDF));
                    return;
                }
            }
        } else if (this.getResultSet() != null) {
            if (this.getResultSet().getStatus().getSeverity() == 4) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", this.getResultSet().getStatus().getMessage()));
                return;
            }
            if (this.getResultSet().getStatus().getSeverity() == 2) {
                this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", this.getResultSet().getStatus().getMessage()));
                return;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalProcedure other = (RelationalProcedure)object;
        if (!(CoreStringUtil.valuesAreEqual((String)this.getNativeQuery(), (String)other.getNativeQuery()) && CoreStringUtil.valuesAreEqual((String)this.getFunctionCategory(), (String)other.getFunctionCategory()) && CoreStringUtil.valuesAreEqual((String)this.getJavaClassName(), (String)other.getJavaClassName()) && CoreStringUtil.valuesAreEqual((String)this.getJavaMethodName(), (String)other.getJavaMethodName()) && CoreStringUtil.valuesAreEqual((String)this.getUdfJarPath(), (String)other.getUdfJarPath()) && CoreStringUtil.valuesAreEqual((String)this.getUpdateCount(), (String)other.getUpdateCount()))) {
            return false;
        }
        if (this.isAggregate() != other.isAggregate() || this.isAllowsDistinct() != other.isAllowsDistinct() || this.isAllowsOrderBy() != other.isAllowsOrderBy() || this.isAnalytic() != other.isAnalytic() || this.isDecomposable() != other.isDecomposable() || this.isDeterministic() != other.isDeterministic() || this.isFunction() != other.isFunction() || this.isNonPrepared() != other.isNonPrepared() || this.isReturnsNullOnNull() != other.isReturnsNullOnNull() || this.isSourceFunction() != other.isSourceFunction() || this.isUseDistinctRows() != other.isUseDistinctRows() || this.isVariableArguments() != other.isVariableArguments()) {
            return false;
        }
        if (this.resultSet == null ? other.resultSet != null : !this.resultSet.equals(other.resultSet)) {
            return false;
        }
        List<RelationalParameter> thisParameters = this.getParameters();
        List<RelationalParameter> thatParameters = other.getParameters();
        if (thisParameters.size() != thatParameters.size()) {
            return false;
        }
        return thisParameters.isEmpty() || thisParameters.equals(thatParameters);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getNativeQuery())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNativeQuery()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getFunctionCategory())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getFunctionCategory()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getJavaClassName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getJavaClassName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getJavaMethodName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getJavaMethodName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getUdfJarPath())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getUdfJarPath()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getUpdateCount())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getUpdateCount()});
        }
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAggregate());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAllowsDistinct());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAllowsOrderBy());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAnalytic());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isDecomposable());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isDeterministic());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isFunction());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isNonPrepared());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isReturnsNullOnNull());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isSourceFunction());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isUseDistinctRows());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isVariableArguments());
        if (this.resultSet != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.resultSet});
        }
        List<RelationalParameter> params = this.getParameters();
        for (RelationalParameter param : params) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{param});
        }
        return result;
    }

    public static enum PROCEDURE_TYPE {
        PROCEDURE,
        FUNCTION,
        SOURCE_FUNCTION,
        NATIVE_QUERY_PROCEDURE;

    }
}

