/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.Properties;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.model.RelationalReference;

public class RelationalColumn
extends RelationalReference {
    public static final String KEY_DISTINCT_VALUE_COUNT = "DISTINCTVALUECOUNT";
    public static final String KEY_NULL_VALUE_COUNT = "NULLVALUECOUNT";
    public static final String KEY_DATATYPE = "DATATYPE";
    public static final String KEY_NATIVE_TYPE = "NATIVETYPE";
    public static final String KEY_NULLABLE = "NULLABLE";
    public static final String KEY_AUTO_INCREMENTED = "AUTOINCREMENTED";
    public static final String KEY_CASE_SENSITIVE = "CASESENSITIVE";
    public static final String KEY_CHARACTER_SET_NAME = "CHARACTERSETNAME";
    public static final String KEY_CHARACTER_OCTET_LENGTH = "CHARACTEROCTETLENGTH";
    public static final String KEY_COLLATION_NAME = "COLLATIONNAME";
    public static final String KEY_CURRENCY = "CURRENCY";
    public static final String KEY_DEFAULT_VALUE = "DEFAULTVALUE";
    public static final String KEY_FORMAT = "FORMAT";
    public static final String KEY_LENGTH = "LENGTH";
    public static final String KEY_LENGTH_FIXED = "LENGTHFIXED";
    public static final String KEY_MAXIMUM_VALUE = "MAXIMUMVALUE";
    public static final String KEY_MINIMUM_VALUE = "MINIMUMVALUE";
    public static final String KEY_PRECISION = "PRECISION";
    public static final String KEY_SCALE = "SCALE";
    public static final String KEY_RADIX = "RADIX";
    public static final String KEY_SIGNED = "SIGNED";
    public static final String KEY_SEARCHABILITY = "SEARCHABILITY";
    public static final String KEY_SELECTABLE = "SELECTABLE";
    public static final String KEY_UPDATEABLE = "UPDATEABLE";
    public static final int DEFAULT_DISTINCT_VALUE_COUNT = -1;
    public static final int DEFAULT_NULL_VALUE_COUNT = -1;
    public static final String DEFAULT_DATATYPE = null;
    public static final String DEFAULT_NATIVE_TYPE = null;
    public static final String DEFAULT_NULLABLE = "NULLABLE";
    public static final boolean DEFAULT_AUTO_INCREMENTED = false;
    public static final boolean DEFAULT_CASE_SENSITIVE = true;
    public static final String DEFAULT_CHARACTER_SET_NAME = null;
    public static final int DEFAULT_CHARACTER_OCTET_LENGTH = 0;
    public static final String DEFAULT_COLLATION_NAME = null;
    public static final boolean DEFAULT_CURRENCY = false;
    public static final String DEFAULT_DEFAULT_VALUE = null;
    public static final String DEFAULT_FORMAT = null;
    public static final int DEFAULT_LENGTH = 0;
    public static final boolean DEFAULT_LENGTH_FIXED = false;
    public static final String DEFAULT_MAXIMUM_VALUE = null;
    public static final String DEFAULT_MINIMUM_VALUE = null;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_NUMERIC_PRECISION = 1;
    public static final int DEFAULT_RADIX = 0;
    public static final int DEFAULT_SCALE = 0;
    public static final boolean DEFAULT_SIGNED = true;
    public static final String DEFAULT_SEARCHABILITY = "SEARCHABLE";
    public static final boolean DEFAULT_SELECTABLE = true;
    public static final boolean DEFAULT_UPDATEABLE = true;
    public static final int DEFAULT_STRING_LENGTH = 4000;
    private int distinctValueCount = -1;
    private int nullValueCount = -1;
    private String datatype;
    private String nativeType;
    private String nullable = "NULLABLE";
    private boolean autoIncremented;
    private boolean caseSensitive = true;
    private String characterSetName;
    private String collationName;
    private boolean currency;
    private String defaultValue;
    private String format;
    private int length;
    private boolean lengthFixed;
    private String maximumValue;
    private String minimumValue;
    private int precision;
    private int scale;
    private int radix;
    private int characterOctetLength;
    private boolean signed = true;
    private String searchability = "SEARCHABLE";
    private boolean selectable = true;
    private boolean updateable = true;

    public RelationalColumn() {
        this.setType(7);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalColumn(String name) {
        super(name);
        this.setType(7);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public int getDistinctValueCount() {
        return this.distinctValueCount;
    }

    public void setDistinctValueCount(int distinctValueCount) {
        this.distinctValueCount = distinctValueCount;
    }

    public int getNullValueCount() {
        return this.nullValueCount;
    }

    public void setNullValueCount(int nullValueCount) {
        this.nullValueCount = nullValueCount;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
        if (this.precision == 0 && (this.datatype.equalsIgnoreCase("INTEGER") || this.datatype.equalsIgnoreCase("DECIMAL") || this.datatype.equalsIgnoreCase("LONG") || this.datatype.equalsIgnoreCase("SHORT") || this.datatype.equalsIgnoreCase("BIGDECIMAL") || this.datatype.equalsIgnoreCase("BIGINTEGER"))) {
            this.setPrecision(1);
        }
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    public void setAutoIncremented(boolean autoIncremented) {
        this.autoIncremented = autoIncremented;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public void setCurrency(boolean currency) {
        this.currency = currency;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isLengthFixed() {
        return this.lengthFixed;
    }

    public void setLengthFixed(boolean lengthFixed) {
        this.lengthFixed = lengthFixed;
    }

    public String getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(String maximumValue) {
        this.maximumValue = maximumValue;
    }

    public String getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(String minimumValue) {
        this.minimumValue = minimumValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public int getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(int characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public String getSearchability() {
        return this.searchability;
    }

    public void setSearchability(String searchability) {
        this.searchability = searchability;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public void validate() {
        super.validate();
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_AUTO_INCREMENTED)) {
                this.setAutoIncremented(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_LENGTH)) {
                this.setLength(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_CASE_SENSITIVE)) {
                this.setCaseSensitive(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_CHARACTER_SET_NAME)) {
                this.setCharacterSetName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_COLLATION_NAME)) {
                this.setCollationName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_CURRENCY)) {
                this.setCurrency(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DATATYPE)) {
                this.setDatatype(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DEFAULT_VALUE)) {
                this.setDefaultValue(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DISTINCT_VALUE_COUNT)) {
                this.setDistinctValueCount(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_FORMAT)) {
                this.setFormat(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_LENGTH_FIXED)) {
                this.setLengthFixed(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_MAXIMUM_VALUE)) {
                this.setMaximumValue(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_MINIMUM_VALUE)) {
                this.setMinimumValue(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_NATIVE_TYPE)) {
                this.setNativeType(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NULLABLE")) {
                this.setNullable(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_NULL_VALUE_COUNT)) {
                this.setNullValueCount(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_PRECISION)) {
                this.setPrecision(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SCALE)) {
                this.setScale(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_RADIX)) {
                this.setRadix(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SEARCHABILITY)) {
                this.setSearchability(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SELECTABLE)) {
                this.setSelectable(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SIGNED)) {
                this.setSigned(Boolean.parseBoolean(value));
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_UPDATEABLE)) continue;
            this.setUpdateable(Boolean.parseBoolean(value));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalColumn other = (RelationalColumn)object;
        if (!(CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getCharacterSetName(), (String)other.getCharacterSetName()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getCollationName(), (String)other.getCollationName()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getDatatype(), (String)other.getDatatype()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getDefaultValue(), (String)other.getDefaultValue()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getFormat(), (String)other.getFormat()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getMaximumValue(), (String)other.getMaximumValue()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getMinimumValue(), (String)other.getMinimumValue()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getNativeType(), (String)other.getNativeType()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getNullable(), (String)other.getNullable()) && CoreStringUtil.valuesAreEqualIgnoreCase((String)this.getSearchability(), (String)other.getSearchability()))) {
            return false;
        }
        return this.getDistinctValueCount() == other.getDistinctValueCount() && this.getLength() == other.getLength() && this.getCharacterOctetLength() == other.getCharacterOctetLength() && this.getNullValueCount() == other.getNullValueCount() && this.getPrecision() == other.getPrecision() && this.getRadix() == other.getRadix() && this.getScale() == other.getScale() && this.isAutoIncremented() == other.isAutoIncremented() && this.isCaseSensitive() == other.isCaseSensitive() && this.isCurrency() == other.isCurrency() && this.isLengthFixed() == other.isLengthFixed() && this.isSelectable() == other.isSelectable() && this.isSigned() == other.isSigned() && this.isUpdateable() == other.isUpdateable();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getCharacterSetName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getCharacterSetName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getCollationName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getCollationName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getDatatype())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDatatype()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getDefaultValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDefaultValue()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getFormat())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getFormat()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getMaximumValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getMaximumValue()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getMinimumValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getMinimumValue()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getNativeType())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNativeType()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getNullable())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNullable()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getSearchability())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getSearchability()});
        }
        result = HashCodeUtil.hashCode((int)result, (int)this.getDistinctValueCount());
        result = HashCodeUtil.hashCode((int)result, (int)this.getLength());
        result = HashCodeUtil.hashCode((int)result, (int)this.getCharacterOctetLength());
        result = HashCodeUtil.hashCode((int)result, (int)this.getNullValueCount());
        result = HashCodeUtil.hashCode((int)result, (int)this.getPrecision());
        result = HashCodeUtil.hashCode((int)result, (int)this.getRadix());
        result = HashCodeUtil.hashCode((int)result, (int)this.getScale());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAutoIncremented());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isCaseSensitive());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isCurrency());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isLengthFixed());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isSelectable());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isSigned());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isUpdateable());
        return result;
    }
}

