/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.guides;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.actions.AdvisorActionFactory;
import org.teiid.designer.advisor.ui.actions.AdvisorActionInfo;
import org.teiid.designer.advisor.ui.actions.AdvisorActionProvider;
import org.teiid.designer.advisor.ui.actions.AdvisorGuides;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.viewsupport.PropertiesContextManager;

public class TeiidGuidesSection
implements AdvisorUiConstants {
    private FormToolkit toolkit;
    private Section section;
    private Composite sectionBody;
    private Combo actionGroupCombo;
    private TreeViewer guidesViewer;
    private Hyperlink executeLink;
    private Text descriptionText;
    private AdvisorActionProvider actionProvider;
    private AdvisorGuides guides;
    private final PropertiesContextManager propertiesManager = new PropertiesContextManager();

    public TeiidGuidesSection(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.actionProvider = new AdvisorActionProvider();
        this.guides = new AdvisorGuides();
        this.createSection(parent);
    }

    private void createSection(Composite theParent) {
        this.section = this.toolkit.createSection(theParent, 322);
        Color bkgdColor = this.toolkit.getColors().getBackground();
        this.section.setText(Messages.ActionSets);
        this.section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.section.setLayoutData((Object)gd);
        this.sectionBody = new Composite((Composite)this.section, 0);
        this.sectionBody.setLayoutData((Object)new GridData(768));
        this.sectionBody.setBackground(bkgdColor);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.sectionBody.setLayout((Layout)layout);
        this.executeLink = this.toolkit.createHyperlink(this.sectionBody, Messages.ExecuteSelectedAction, 64);
        this.toolkit.adapt((Control)this.executeLink, true, true);
        this.executeLink.setEnabled(false);
        this.executeLink.setToolTipText(Messages.ExecuteSelectedAction_tooltip);
        this.executeLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent theEvent) {
                IStructuredSelection selection = (IStructuredSelection)TeiidGuidesSection.this.guidesViewer.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof AdvisorActionInfo) {
                    String actionId = ((AdvisorActionInfo)selection.getFirstElement()).getId();
                    TeiidGuidesSection.this.launchGuidesAction(actionId);
                }
            }
        });
        this.executeLink.setBackground(this.section.getBackground());
        this.actionGroupCombo = new Combo(this.sectionBody, 8);
        GridData gd2 = new GridData(768);
        gd2.verticalAlignment = 2;
        gd2.horizontalSpan = 2;
        this.actionGroupCombo.setLayoutData((Object)gd2);
        WidgetUtil.setComboItems((Combo)this.actionGroupCombo, this.guides.getCategories(), null, (boolean)true);
        this.actionGroupCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TeiidGuidesSection.this.selectComboItem(TeiidGuidesSection.this.actionGroupCombo.getSelectionIndex());
            }
        });
        this.guidesViewer = WidgetFactory.createTreeViewer((Composite)this.sectionBody, (int)4);
        gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        gd2.heightHint = 180;
        this.guidesViewer.getControl().setLayoutData((Object)gd2);
        this.guidesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof AdvisorActionInfo) {
                    String actionId = ((AdvisorActionInfo)selection.getFirstElement()).getId();
                    TeiidGuidesSection.this.launchGuidesAction(actionId);
                }
            }
        });
        this.guidesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof AdvisorActionInfo) {
                    String desc = ((AdvisorActionInfo)selection.getFirstElement()).getDescription();
                    if (desc != null) {
                        TeiidGuidesSection.this.descriptionText.setText(desc);
                    } else {
                        TeiidGuidesSection.this.descriptionText.setText(Messages.NoActionSelected);
                    }
                    TeiidGuidesSection.this.executeLink.setEnabled(true);
                } else {
                    TeiidGuidesSection.this.descriptionText.setText(Messages.NoActionSelected);
                    TeiidGuidesSection.this.executeLink.setEnabled(false);
                }
            }
        });
        this.guidesViewer.setLabelProvider((IBaseLabelProvider)this.actionProvider);
        this.guidesViewer.setContentProvider((IContentProvider)this.actionProvider);
        this.syncActionProvider(AdvisorGuides.MODEL_JDBC_SOURCE);
        this.guidesViewer.setInput((Object)this.guides.getChildren(AdvisorGuides.MODEL_JDBC_SOURCE));
        this.guidesViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TeiidGuidesSection.this.guidesViewer.getTree().setToolTipText(Messages.DoubleClickToExecuteAction);
            }
        });
        Group descriptionGroup = WidgetFactory.createGroup((Composite)this.sectionBody, (String)"Description", (int)768, (int)3);
        this.descriptionText = new Text((Composite)descriptionGroup, 584);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 60;
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd);
        this.descriptionText.setBackground(this.sectionBody.getBackground());
        this.descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.descriptionText.setText(Messages.NoActionSelected);
        this.section.setClient((Control)this.sectionBody);
        this.executeLink.setEnabled(!this.guidesViewer.getSelection().isEmpty());
        this.selectComboItem(this.getInitialComboSelectionIndex());
    }

    private void syncActionProvider(String id) {
        Properties properties = this.propertiesManager.getProperties(id);
        this.actionProvider.setProperties(properties);
    }

    private void selectComboItem(int selectionIndex) {
        if (selectionIndex >= 0) {
            this.actionGroupCombo.select(selectionIndex);
            String categoryId = this.actionGroupCombo.getItem(selectionIndex);
            this.syncActionProvider(categoryId);
            this.guidesViewer.setInput((Object)this.guides.getChildren(categoryId));
        }
    }

    private int getInitialComboSelectionIndex() {
        int index = 0;
        String[] stringArray = this.actionGroupCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (AdvisorGuides.MODEL_JDBC_SOURCE.equalsIgnoreCase(item)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private void launchGuidesAction(String actionId) {
        String guideId = this.actionGroupCombo.getText();
        Properties properties = this.propertiesManager.getProperties(guideId);
        if (properties != null && !properties.isEmpty()) {
            this.cleanProperties(properties);
        }
        this.syncActionProvider(guideId);
        AdvisorActionFactory.executeAction(actionId, properties, true);
        this.syncActionProvider(guideId);
        this.guidesViewer.refresh();
    }

    private void cleanProperties(Properties properties) {
        boolean openModelProjects;
        boolean bl = openModelProjects = !ModelerUiViewUtils.getOpenModelProjects().isEmpty();
        if (openModelProjects) {
            IProject proj;
            String projName = DesignerPropertiesUtil.getProjectName((Properties)properties);
            if (projName != null && (proj = DesignerPropertiesUtil.getProject((Properties)properties)) != null && !proj.isOpen()) {
                DesignerPropertiesUtil.setProjectName((Properties)properties, null);
            }
            DesignerPropertiesUtil.setProjectStatus((Properties)properties, (String)"openProjectsExist");
        } else {
            DesignerPropertiesUtil.setProjectName((Properties)properties, null);
            DesignerPropertiesUtil.setProjectStatus((Properties)properties, (String)"noOpenProject");
        }
    }
}

