/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.suppliers.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatus;
import org.teiid.designer.advisor.ui.views.status.StatusValidationConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class XmlProjectValidationHelper
implements StatusValidationConstants {
    private static final String TRANSACTION_DESCRIPTION = "Creating new Data Services Project Status";
    private IProject currentProject;
    private Map eResourceToPath;
    private int sourceModelCount = 0;
    private int viewModelCount = 0;
    private int schemaFileCount = 0;
    private boolean modelErrorsExist = false;
    private boolean sourceModelErrors = false;
    private boolean viewModelErrors = false;
    private boolean schemaModelErrors = false;
    private IResource[] allResources;
    private boolean validating = false;

    public XmlProjectValidationHelper() {
    }

    public XmlProjectValidationHelper(IProject project) {
        this.currentProject = project;
    }

    public AdvisorStatus getCurrentStatus() {
        this.validating = true;
        AdvisorStatus status = null;
        this.resetInitialState();
        this.setCurrentProject(AdvisorUiPlugin.getStatusManager().getCurrentProject());
        this.loadAndSetResources();
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)TRANSACTION_DESCRIPTION, (Object)new DefaultIgnorableNotificationSource((Object)this));
        boolean succeeded = false;
        try {
            status = this.createNewStatus();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.validating = false;
        return status;
    }

    private AdvisorStatus createNewStatus() {
        if (this.currentProject == null) {
            return StatusValidationConstants.STATUS_MSGS.ADVISOR_NO_PROJECT_SELECTED;
        }
        this.processModelTypes(this.allResources);
        boolean incomplete = false;
        boolean hasErrors = false;
        boolean noModels = this.allResources.length == 0;
        Status sourcesStatus = null;
        Status modelStatus = null;
        Status bindingsStatus = null;
        Status viewsStatus = null;
        IStatus schemaStatus = null;
        IStatus completedStatus = null;
        if (this.modelErrorsExist) {
            modelStatus = StatusValidationConstants.STATUS_MSGS.MODEL_PROBLEMS_ERROR;
            hasErrors = true;
        } else {
            modelStatus = noModels ? StatusValidationConstants.STATUS_MSGS.NO_MODELS_NO_PROBLEMS : StatusValidationConstants.STATUS_MSGS.MODEL_PROBLEMS_OK;
        }
        if (this.sourceModelCount > 0) {
            sourcesStatus = this.sourceModelErrors ? StatusValidationConstants.STATUS_MSGS.SOURCE_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.SOURCE_MODELS_ARE_OK;
        } else {
            sourcesStatus = StatusValidationConstants.STATUS_MSGS.NO_SOURCE_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (!this.isValidModelProject() || this.isValidModelProject() && !this.connectorBindingErrorsExist()) {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.CONNECTOR_BINDINGS_OK;
        } else if (sourcesStatus == StatusValidationConstants.STATUS_MSGS.NO_SOURCE_MODELS_ARE_DEFINED) {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.NO_CONNECTOR_BINDINGS_NO_SOURCES;
            incomplete = true;
        } else {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.CONNECTOR_BINDINGS_ERROR;
            hasErrors = true;
        }
        if (this.viewModelCount > 0) {
            viewsStatus = this.viewModelErrors ? StatusValidationConstants.STATUS_MSGS.VIEW_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.VIEW_MODELS_ARE_OK;
        } else {
            viewsStatus = StatusValidationConstants.STATUS_MSGS.NO_VIEW_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (this.schemaFileCount > 0) {
            viewsStatus = this.schemaModelErrors ? StatusValidationConstants.STATUS_MSGS.SCHEMA_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.SCHEMA_MODELS_ARE_DEFINED;
        } else {
            viewsStatus = StatusValidationConstants.STATUS_MSGS.NO_SCHEMA_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        AdvisorStatus status = null;
        completedStatus = Status.OK_STATUS;
        completedStatus = hasErrors ? StatusValidationConstants.STATUS_MSGS.COMPLETION_ERRORS_EXIST : (incomplete ? StatusValidationConstants.STATUS_MSGS.COMPLETION_INCOMPLETE : StatusValidationConstants.STATUS_MSGS.COMPLETION_OK);
        status = new AdvisorStatus("org.teiid.designer.advisor.ui", 0, completedStatus.getMessage(), null);
        status.setCurrentObject(this.currentProject);
        status.add(0, (IStatus)modelStatus);
        status.add(1, (IStatus)sourcesStatus);
        status.add(3, (IStatus)viewsStatus);
        status.add(2, (IStatus)bindingsStatus);
        status.add(5, schemaStatus);
        return status;
    }

    private void resetInitialState() {
        this.sourceModelCount = 0;
        this.viewModelCount = 0;
        this.schemaFileCount = 0;
        this.modelErrorsExist = false;
        this.sourceModelErrors = false;
        this.schemaModelErrors = false;
        this.allResources = new IResource[0];
        if (this.eResourceToPath != null) {
            this.eResourceToPath.clear();
        } else {
            this.eResourceToPath = new HashMap();
        }
    }

    private IResource[] getResourcesForCurrentProject() throws CoreException {
        ModelResource[] mrs = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().getModelResources();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ModelResource[] modelResourceArray = mrs;
        int n = mrs.length;
        int n2 = 0;
        while (n2 < n) {
            ModelResource mr = modelResourceArray[n2];
            if (mr.getModelProject().getProject().equals((Object)this.currentProject)) {
                try {
                    resources.add(mr.getCorrespondingResource());
                }
                catch (ModelWorkspaceException e) {
                    AdvisorUiConstants.UTIL.log((Throwable)e);
                }
            }
            ++n2;
        }
        if (resources.isEmpty()) {
            return new IResource[0];
        }
        IResource[] resArray = new IResource[resources.size()];
        int i = 0;
        for (IResource res : resources) {
            resArray[i++] = res;
        }
        return resArray;
    }

    private void loadAndSetResources() {
        if (this.isValidModelProject()) {
            try {
                this.allResources = this.getResourcesForCurrentProject();
            }
            catch (CoreException e) {
                AdvisorUiConstants.UTIL.log((Throwable)e);
            }
        }
    }

    private boolean isValidModelProject() {
        return this.currentProject != null && this.currentProject.isAccessible();
    }

    private void processModelTypes(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            boolean resourceHasErrors = this.errorMarkersExist(resource);
            if (resourceHasErrors && !this.modelErrorsExist) {
                this.modelErrorsExist = true;
            }
            if (ModelIdentifier.isRelationalSourceModel((IResource)resource)) {
                ++this.sourceModelCount;
                if (resourceHasErrors && !this.sourceModelErrors) {
                    this.sourceModelErrors = true;
                }
            } else if (ModelIdentifier.isRelationalViewModel((IResource)resource)) {
                ++this.viewModelCount;
                if (resourceHasErrors && !this.viewModelErrors) {
                    this.viewModelErrors = true;
                }
            } else if (ModelIdentifier.isSchemaModel((IResource)resource)) {
                ++this.schemaFileCount;
                if (resourceHasErrors && !this.schemaModelErrors) {
                    this.schemaModelErrors = true;
                }
            }
            ++n2;
        }
    }

    private boolean errorMarkersExist(IResource resource) {
        if (resource.exists()) {
            IMarker[] markers = null;
            try {
                markers = ((IFile)resource).findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException theException) {
                AdvisorUiConstants.UTIL.log((Throwable)theException);
            }
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    int severity = markers[i].getAttribute("severity", -1);
                    if (severity == 2) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean connectorBindingErrorsExist() {
        return this.sourceModelCount == 0;
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(IProject project) {
        this.currentProject = project;
    }

    public boolean isValidating() {
        return this.validating;
    }
}

