/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.suppliers.relational;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.teiid.designer.advisor.ui.core.AdvisorSupplierFactory;
import org.teiid.designer.advisor.ui.core.DefaultCheatSheetProvider;
import org.teiid.designer.advisor.ui.core.IAdvisorSupplier;
import org.teiid.designer.advisor.ui.core.ICheatSheetProvider;
import org.teiid.designer.advisor.ui.core.status.IStatusContentProvider;
import org.teiid.designer.advisor.ui.core.status.IStatusManager;
import org.teiid.designer.advisor.ui.suppliers.relational.RelationalModelingStatusManager;
import org.teiid.designer.advisor.ui.suppliers.relational.RelationalModelingStatusProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class RelationalModelingSupplier
implements IAdvisorSupplier {
    private IStatusContentProvider statusProvider = new RelationalModelingStatusProvider();
    private IStatusManager statusManager = new RelationalModelingStatusManager();
    private ICheatSheetProvider cheatSheetProvider = new DefaultCheatSheetProvider();

    @Override
    public void changeContent(Object content) {
    }

    @Override
    public ICheatSheetProvider getCheatSheetProvider() {
        return this.cheatSheetProvider;
    }

    @Override
    public IStatusManager getStatusManager() {
        return this.statusManager;
    }

    @Override
    public IStatusContentProvider getStatusContentProvider() {
        return this.statusProvider;
    }

    @Override
    public boolean isApplicable(Object target) {
        if (target instanceof IResource) {
            IResource res = (IResource)target;
            if (res instanceof IProject && ModelerCore.hasModelNature((IProject)((IProject)res))) {
                boolean isRelationalOnly = AdvisorSupplierFactory.hasPrimaryProjectScopeNature((IProject)res, "org.teiid.designer.advisor.ui.relationalModelingNature") && !AdvisorSupplierFactory.hasPrimaryProjectScopeNature((IProject)res, "org.teiid.designer.advisor.ui.xmlModelingNature") && !AdvisorSupplierFactory.hasPrimaryProjectScopeNature((IProject)res, "org.teiid.designer.advisor.ui.webServicesModelingNature");
                return isRelationalOnly;
            }
            if (ModelIdentifier.isRelationalSourceModel((IResource)res) || ModelIdentifier.isRelationalViewModel((IResource)res)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void shutdown() {
        this.statusProvider.shutdown();
        this.statusManager.shutdown();
        this.cheatSheetProvider.shutdown();
    }

    @Override
    public void startup() {
        this.statusProvider.startup();
        this.statusManager.startup();
        this.cheatSheetProvider.startup();
    }
}

