/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.core.DefaultAdvisorSupplier;
import org.teiid.designer.advisor.ui.core.IAdvisorSupplier;

public class AdvisorSupplierFactory {
    private static Collection suppliers;
    private static boolean suppliersLoaded;
    private static Object currentFocusedObject;
    private static IAdvisorSupplier currentSupplier;
    private static IAdvisorSupplier defaultSupplier;

    static {
        suppliersLoaded = false;
        defaultSupplier = new DefaultAdvisorSupplier();
    }

    public static Object getCurrentFocusedObject() {
        return currentFocusedObject;
    }

    private static void loadExtensions() {
        HashMap<String, Object> suppliersMap = new HashMap<String, Object>();
        suppliersLoaded = true;
        String id = "advisorStatusProvider";
        String className = "name";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.advisor.ui", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object helper = elements[j].createExecutableExtension(className);
                    suppliersMap.put(elements[j].getAttribute(className), helper);
                    ++j;
                }
            }
            catch (Exception e) {
                String message = "Problem Loading Designer Advisor Extension Point Data";
                AdvisorUiConstants.UTIL.log(4, (Throwable)e, message);
            }
            ++i;
        }
        suppliers = suppliersMap.values();
    }

    public static IAdvisorSupplier getSupplier(Object target) {
        if (!suppliersLoaded) {
            AdvisorSupplierFactory.loadExtensions();
        }
        if (target != null) {
            if (target == currentFocusedObject) {
                return currentSupplier;
            }
            Iterator iter = suppliers.iterator();
            IAdvisorSupplier nextSupplier = null;
            while (iter.hasNext()) {
                nextSupplier = (IAdvisorSupplier)iter.next();
                if (!nextSupplier.isApplicable(target)) continue;
                currentFocusedObject = target;
                if (currentSupplier != null) {
                    currentSupplier.shutdown();
                }
                currentSupplier = nextSupplier;
                currentSupplier.startup();
                return nextSupplier;
            }
        }
        currentFocusedObject = target;
        currentSupplier = defaultSupplier;
        return defaultSupplier;
    }

    public static IAdvisorSupplier getCurrentSupplier() {
        if (!suppliersLoaded) {
            AdvisorSupplierFactory.loadExtensions();
        }
        if (currentSupplier != null) {
            return currentSupplier;
        }
        return defaultSupplier;
    }

    public static String getPrimaryProjectScopeNature(IProject proj) {
        block8: {
            block7: {
                block6: {
                    if (!proj.hasNature("org.teiid.designer.advisor.ui.vdbNature")) break block6;
                    return "org.teiid.designer.advisor.ui.vdbNature";
                }
                if (!proj.hasNature("org.teiid.designer.advisor.ui.webServicesModelingNature")) break block7;
                return "org.teiid.designer.advisor.ui.webServicesModelingNature";
            }
            if (!proj.hasNature("org.teiid.designer.advisor.ui.xmlModelingNature")) break block8;
            return "org.teiid.designer.advisor.ui.xmlModelingNature";
        }
        try {
            if (proj.hasNature("org.teiid.designer.advisor.ui.relationalModelingNature")) {
                return "org.teiid.designer.advisor.ui.relationalModelingNature";
            }
        }
        catch (CoreException e) {
            AdvisorUiConstants.UTIL.log((Throwable)e);
        }
        return "NoNature";
    }

    public static boolean hasPrimaryProjectScopeNature(IProject proj, String id) {
        block8: {
            block7: {
                block6: {
                    if (!proj.hasNature("org.teiid.designer.advisor.ui.vdbNature") || !id.equalsIgnoreCase("org.teiid.designer.advisor.ui.vdbNature")) break block6;
                    return true;
                }
                if (!proj.hasNature("org.teiid.designer.advisor.ui.webServicesModelingNature") || !id.equalsIgnoreCase("org.teiid.designer.advisor.ui.webServicesModelingNature")) break block7;
                return true;
            }
            if (!proj.hasNature("org.teiid.designer.advisor.ui.xmlModelingNature") || !id.equalsIgnoreCase("org.teiid.designer.advisor.ui.xmlModelingNature")) break block8;
            return true;
        }
        try {
            if (proj.hasNature("org.teiid.designer.advisor.ui.relationalModelingNature") && id.equalsIgnoreCase("org.teiid.designer.advisor.ui.relationalModelingNature")) {
                return true;
            }
        }
        catch (CoreException e) {
            AdvisorUiConstants.UTIL.log((Throwable)e);
        }
        return false;
    }
}

