/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.TempDirectory;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoPanel;
import org.teiid.designer.runtime.ui.wizards.webservices.util.SecurityCredentials;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilder;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.ui.util.VdbResourceFinder;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.gen.BasicWsdlGenerator;
import org.teiid.designer.webservice.lib.WebServiceLibConstants;
import org.teiid.designer.webservice.lib.WebServiceLibPlugin;
import org.teiid.designer.webservice.util.AntTasks;

public class DefaultWebArchiveBuilderImpl
implements WebArchiveBuilder,
WebServiceLibConstants,
StringConstants {
    private List<String> ports = new ArrayList<String>();
    private Map<String, String> operationToProcedureMap = new HashMap<String, String>();
    private String wsdlFilename = "";
    private static final String JNDI_PREFIX = "java:";
    private static final String I18N_PREFIX = "WebArchiveBuilder.";
    private static final String TASK_CREATE_DIRECTORIES = DefaultWebArchiveBuilderImpl.getString("taskCreateDirectory");
    private static final String TASK_COPYING_FILES = DefaultWebArchiveBuilderImpl.getString("taskCopyingFiles");
    private static final String TASK_CREATING_WSDL_FILE = DefaultWebArchiveBuilderImpl.getString("taskCreatingWSDLFile");
    private static final String TASK_CREATING_WAR_ARCHIVE = DefaultWebArchiveBuilderImpl.getString("taskCreatingWarArchive");
    private static final String TASK_COPYING_WAR_FILE = DefaultWebArchiveBuilderImpl.getString("taskCopyingWarFile");
    private static final String TASK_CLEANUP = DefaultWebArchiveBuilderImpl.getString("taskCleanup");

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public Map<String, String> getOperationToProcedureMap() {
        return this.operationToProcedureMap;
    }

    public void setOperationToProcedureMap(Map<String, String> operationToProcedureMap) {
        this.operationToProcedureMap = operationToProcedureMap;
    }

    @Override
    public IStatus validateContextName(String contextName) {
        try {
            URLValidator urlValidator = new URLValidator();
            String[] invalidChars = new String[]{"/", "\\", CoreStringUtil.Constants.SPACE};
            String invalidChar = this.validateInvalidCharactersInContextName(contextName, invalidChars);
            if (invalidChar != null) {
                String msg = null;
                if (CoreStringUtil.Constants.SPACE.equals(invalidChar)) {
                    msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidSpace");
                } else {
                    Object[] params = new Object[]{invalidChar};
                    msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidCharacter", params);
                }
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            if ("".equals(contextName)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_Empty");
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            if (!urlValidator.isValidValue("http://www.teiid.org/" + contextName)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationSucceeded");
            return new Status(0, "org.teiid.designer.webservice", 2, msg, null);
        }
        catch (Exception e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
            return new Status(4, "org.teiid.designer.webservice", 1, msg, (Throwable)e);
        }
    }

    @Override
    public IStatus createWebArchive(Properties properties, IProgressMonitor monitor) {
        IStatus status;
        try {
            String contextName = (String)properties.get("ContextName");
            status = this.validateContextName(contextName);
            if (4 == status.getSeverity()) {
                throw new Exception(status.getException());
            }
            String webServicePluginPath = WebServiceLibPlugin.getDefault().getInstallPath().toOSString();
            String buildDirectoryName = String.valueOf(webServicePluginPath) + File.separator + "war_build";
            File buildDirectory = new File(buildDirectoryName);
            buildDirectory.mkdir();
            monitor.subTask(TASK_CREATE_DIRECTORIES);
            String workDirectoryName = String.valueOf(buildDirectoryName) + File.separator + "work";
            File workDirectory = new File(workDirectoryName);
            workDirectory.mkdir();
            FileUtils.removeChildrenRecursively((File)workDirectory);
            TempDirectory tempDir = TempDirectory.getTempDirectory((String)workDirectoryName);
            String tempDirectoryName = tempDir.getPath();
            String contextDirectoryName = String.valueOf(tempDirectoryName) + File.separator + contextName;
            File contextDirectory = new File(contextDirectoryName);
            contextDirectory.mkdir();
            String imagesDirectoryName = String.valueOf(contextDirectoryName) + File.separator + "images";
            File imagesDirectory = new File(imagesDirectoryName);
            imagesDirectory.mkdir();
            String webInfDirectoryName = String.valueOf(contextDirectoryName) + File.separator + "WEB-INF";
            File webInfDirectory = new File(webInfDirectoryName);
            webInfDirectory.mkdir();
            String webInfWsdlDirectoryName = String.valueOf(webInfDirectoryName) + File.separator + "wsdl";
            File webInfWsdlDirectory = new File(webInfWsdlDirectoryName);
            webInfWsdlDirectory.mkdir();
            String webInfClassesDirectoryName = String.valueOf(webInfDirectoryName) + File.separator + "classes";
            String webInfLibDirectoryName = String.valueOf(webInfDirectoryName) + File.separator + "lib";
            File webInfClassesDirectory = new File(webInfClassesDirectoryName);
            File webInfLibDirectory = new File(webInfLibDirectoryName);
            webInfLibDirectory.mkdir();
            webInfClassesDirectory.mkdir();
            monitor.worked(10);
            monitor.subTask(TASK_CREATING_WSDL_FILE);
            boolean containsGlobalDataTypes = this.generateWsdl(properties, webInfWsdlDirectory);
            monitor.subTask(TASK_COPYING_FILES);
            this.getWebFiles(contextDirectory, webInfDirectory, containsGlobalDataTypes);
            SecurityCredentials securityCredentials = new SecurityCredentials(properties);
            if (securityCredentials.hasType(WarDeploymentInfoPanel.BASIC)) {
                this.replaceJBossWebXmlVariables(webInfDirectoryName, securityCredentials.getSecurityRealm());
            }
            this.replaceWebXmlVariables(webInfDirectoryName, securityCredentials, contextName);
            this.replaceJBossWSCXFVariables(webInfDirectoryName, properties, securityCredentials);
            this.createPropertiesFile(webInfClassesDirectory, properties);
            this.createProviderJavaClasses(webInfLibDirectory, webInfClassesDirectory, properties, securityCredentials);
            monitor.worked(10);
            monitor.subTask(TASK_CREATING_WAR_ARCHIVE);
            String warFileName = String.valueOf(tempDirectoryName) + File.separator + contextName + ".war";
            AntTasks.zip((String)contextDirectoryName, (String)warFileName);
            monitor.worked(20);
            String newWarFileDir = (String)properties.get("WARFileSaveLocation");
            File newWarDir = new File(newWarFileDir);
            if (!newWarDir.exists()) {
                newWarDir.mkdir();
            }
            monitor.subTask(TASK_COPYING_WAR_FILE);
            File warFile = new File(warFileName);
            String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), String.valueOf(contextName) + ".war");
            File newWarFile = new File(newWarFileName);
            if (newWarFile.exists() && !newWarFile.delete()) {
                String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotDeleteExistingWARFile");
                throw new Exception(msg);
            }
            if (!warFile.renameTo(newWarFile)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotSaveWARFile");
                throw new Exception(msg);
            }
            monitor.subTask(TASK_CLEANUP);
            tempDir.remove();
            monitor.worked(5);
        }
        catch (Exception e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed");
            Status status2 = new Status(4, "org.teiid.designer.webservice", 5, msg, (Throwable)e);
            WebServicePlugin.Util.log((IStatus)status2);
            return status2;
        }
        String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationSucceeded");
        status = new Status(0, "org.teiid.designer.webservice", 6, msg, null);
        return status;
    }

    @Override
    public boolean targetWarFileExists(Properties properties) {
        boolean fileExists = false;
        String contextName = properties.getProperty("ContextName");
        IStatus status = this.validateContextName(contextName);
        if (4 == status.getSeverity()) {
            fileExists = true;
            return fileExists;
        }
        String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), String.valueOf(contextName) + ".war");
        fileExists = new File(newWarFileName).exists();
        return fileExists;
    }

    private static String getString(String id) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, new Object[0]);
    }

    private static String getString(String id, Object[] params) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, params);
    }

    private String validateInvalidCharactersInContextName(String contextName, String[] invalidChars) {
        int numChars = invalidChars.length;
        int charCounter = 0;
        while (charCounter < numChars) {
            String invalidChar = invalidChars[charCounter];
            if (contextName.indexOf(invalidChar) >= 0) {
                return invalidChar;
            }
            ++charCounter;
        }
        return null;
    }

    private String getFileName(String path, String name) {
        String fileName = path;
        if (!fileName.endsWith("/") && !fileName.endsWith("\\")) {
            fileName = String.valueOf(fileName) + File.separator;
        }
        fileName = String.valueOf(fileName) + name;
        return fileName;
    }

    private void getWebFiles(File contextDirectory, File webInfDirectory, boolean containsGlobalDataTypes) throws Exception {
        String webLibPath = WebServiceLibPlugin.getDefault().getSoapWebLibDirectoryPath();
        String webAppsDirectoryName = String.valueOf(webLibPath) + File.separator + "webapps";
        File webAppsDirectory = new File(webAppsDirectoryName);
        FileUtils.copyRecursively((File)webAppsDirectory, (File)contextDirectory, null, (boolean)false);
        if (!containsGlobalDataTypes) {
            File builtInDataTypeSchemaFile = new File(String.valueOf(webInfDirectory.getPath()) + "/wsdl/" + "builtInDataTypes.xsd");
            builtInDataTypeSchemaFile.delete();
        }
    }

    private void replaceWebXmlVariables(String webInfDirectoryName, SecurityCredentials securityCredentials, String contextName) throws Exception {
        File webXmlFile = new File(String.valueOf(webInfDirectoryName) + File.separator + "web.xml");
        if (securityCredentials.hasType(WarDeploymentInfoPanel.BASIC)) {
            AntTasks.replace((File)webXmlFile, (String)"<!--<security-constraint>", (String)"\t<security-constraint>");
            AntTasks.replace((File)webXmlFile, (String)"${realmName}", (String)securityCredentials.getSecurityRealm());
            AntTasks.replace((File)webXmlFile, (String)"${roleName}", (String)securityCredentials.getSecurityRole());
            AntTasks.replace((File)webXmlFile, (String)"</login-config>-->", (String)"</login-config>");
        } else {
            AntTasks.replace((File)webXmlFile, (String)"<!--${basic_auth}-->", (String)"");
        }
        AntTasks.replace((File)webXmlFile, (String)"${warname}", (String)contextName);
        AntTasks.replace((File)webXmlFile, (String)"${servlets}", (String)this.createServletTags(this.getPorts()));
    }

    private void replaceJBossWebXmlVariables(String webInfDirectoryName, String securityDomain) {
        File jbossWebXmlFile = new File(String.valueOf(webInfDirectoryName) + File.separator + "jboss-web.xml");
        String securityDomainNode = "<security-domain>java:/jaas/" + securityDomain + "</security-domain>";
        AntTasks.replace((File)jbossWebXmlFile, (String)"<!--<security-domain>java:/jaas/teiid-security</security-domain>-->", (String)securityDomainNode);
    }

    private void replaceJBossWSCXFVariables(String webInfDirectoryName, Properties properties, SecurityCredentials securityCredentials) {
        File jbossWSCxfXMLFile = new File(String.valueOf(webInfDirectoryName) + File.separator + "jbossws-cxf.xml");
        AntTasks.replace((File)jbossWSCxfXMLFile, (String)"${jaxws.endpoint}", (String)this.createEndpointTags(properties, securityCredentials, this.getPorts()));
        if (securityCredentials.hasType(WarDeploymentInfoPanel.WSSE)) {
            AntTasks.replace((File)jbossWSCxfXMLFile, (String)"<!--<bean ", (String)"<bean ");
            AntTasks.replace((File)jbossWSCxfXMLFile, (String)"</bean>-->", (String)"</bean>");
        }
    }

    private void createPropertiesFile(File webInfClassesDirectory, Properties properties) throws IOException {
        File teiisSoapProperties = new File(webInfClassesDirectory + File.separator + "teiidsoap.properties");
        String jndiValue = properties.getProperty("jndiName");
        if (jndiValue != null && !jndiValue.startsWith(JNDI_PREFIX)) {
            jndiValue = "java:/" + jndiValue;
        }
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(teiisSoapProperties);
            out = new BufferedWriter(fstream);
            for (Map.Entry<String, String> pairs : this.operationToProcedureMap.entrySet()) {
                out.write(pairs.getKey() + "=" + pairs.getValue() + "\n");
            }
            out.write("jndiName=" + jndiValue);
        }
        finally {
            out.close();
        }
    }

    private void createProviderJavaClasses(File webInfLibDirectory, File webInfClassesDirectory, Properties properties, SecurityCredentials securityCredentials) throws Exception {
        String pathToProviders = "/org" + File.separator + "teiid" + File.separator + "soap" + File.separator + "provider";
        String pathToCallback = "/org" + File.separator + "teiid" + File.separator + "soap" + File.separator + "wsse";
        String pathToPlugin = "/org" + File.separator + "teiid" + File.separator + "soap";
        String tns = (String)properties.get("tns");
        String context = properties.getProperty("ContextName");
        ArrayList<File> portProviders = new ArrayList<File>();
        for (String port : this.getPorts()) {
            String providerJavaFilePath = String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToProviders + File.separator + port + ".java";
            FileUtils.copy((String)(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToProviders + File.separator + "ProviderTemplate.java"), (String)providerJavaFilePath, (boolean)true);
            File providerJavaFile = new File(providerJavaFilePath);
            portProviders.add(providerJavaFile);
            AntTasks.replace((File)providerJavaFile, (String)"${className}", (String)port);
            AntTasks.replace((File)providerJavaFile, (String)"${targetNamespace}", (String)tns);
            AntTasks.replace((File)providerJavaFile, (String)"${portName}", (String)port);
            AntTasks.replace((File)providerJavaFile, (String)"${serviceName}", (String)context);
            AntTasks.replace((File)providerJavaFile, (String)"${wsdlFileName}", (String)this.wsdlFilename);
        }
        File template = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToProviders + File.separator + "ProviderTemplate.java");
        File soapPlugin = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToPlugin + File.separator + "SoapPlugin.java");
        File teiidProvider = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToProviders + File.separator + "TeiidWSProvider.java");
        File usernameCallback = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToCallback + File.separator + "UsernamePasswordCallback.java");
        if (securityCredentials.hasType(WarDeploymentInfoPanel.WSSE)) {
            AntTasks.replace((File)usernameCallback, (String)"${username}", (String)((String)properties.get("securityUsername")));
            AntTasks.replace((File)usernameCallback, (String)"${password}", (String)((String)properties.get("securityPassword")));
        }
        template.delete();
        JavaCompiler compilerTool = ToolProvider.getSystemJavaCompiler();
        if (compilerTool != null) {
            StandardJavaFileManager fileManager = compilerTool.getStandardFileManager(null, null, null);
            String pathToWSSEJar = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "wss4j.jar";
            File wsseJar = new File(pathToWSSEJar);
            List<File> classPaths = Arrays.asList(wsseJar);
            fileManager.setLocation(StandardLocation.CLASS_PATH, classPaths);
            ArrayList<File> sourceFileList = new ArrayList<File>();
            sourceFileList.add(soapPlugin);
            sourceFileList.add(teiidProvider);
            if (securityCredentials.hasType(WarDeploymentInfoPanel.WSSE)) {
                sourceFileList.add(usernameCallback);
            }
            for (File providerClass : portProviders) {
                sourceFileList.add(providerClass);
            }
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFileList);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            JavaCompiler.CompilationTask task = compilerTool.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            task.call();
            List diagnosticList = diagnostics.getDiagnostics();
            for (Diagnostic diagnostic : diagnosticList) {
                diagnostic.getKind();
                if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
                throw new Exception(diagnostic.getMessage(null));
            }
            fileManager.close();
            wsseJar.delete();
            webInfLibDirectory.delete();
        }
    }

    private boolean isUseMTOM(Properties properties) {
        Object useMotem = properties.get("mtom");
        return useMotem == null ? false : useMotem.equals(Boolean.TRUE);
    }

    public boolean generateWsdl(Properties properties, File webinfWsdlFolder) throws IOException, CoreException {
        String fileName;
        BasicWsdlGenerator wsdlGenerator = new BasicWsdlGenerator();
        Resource wsModel = null;
        String contextName = (String)properties.get("ContextName");
        String host = (String)properties.get("host");
        String port = (String)properties.get("port");
        String tns = (String)properties.get("tns");
        String webServiceName = contextName;
        String vdbFileName = properties.getProperty("VdbFileName");
        Path vdbPath = new Path(vdbFileName);
        IFile vdbFile = ModelerCore.getWorkspace().getRoot().getFile((IPath)vdbPath);
        boolean hasGlobalDataType = false;
        VdbResourceFinder vdbResourceFinder = new VdbResourceFinder(vdbFile);
        for (Resource webServiceModel : vdbResourceFinder.getWebServiceResources()) {
            try {
                wsModel = webServiceModel;
                wsdlGenerator.addWebServiceModel(wsModel);
                ArrayList dependentSchemas = new ArrayList();
                Resource[] resources = vdbResourceFinder.getDependentResources(wsModel);
                vdbResourceFinder.getAllDependentSchemas(resources, dependentSchemas);
                for (Resource resource : dependentSchemas) {
                    if (!ModelUtil.isXsdFile((Resource)resource)) continue;
                    String fullFilePath = resource.getURI().path();
                    String fileNameWithExtension = new Path(fullFilePath).lastSegment();
                    IPath fileLocationPath = new Path(fullFilePath).removeLastSegments(1);
                    XSDSchema xsdSchema = this.importSchema(fullFilePath);
                    if (this.containsGlobalDataTypeImport(xsdSchema)) {
                        hasGlobalDataType = true;
                        File xsd = new File(fullFilePath);
                        FileUtils.copy((File)xsd, (File)webinfWsdlFolder, (boolean)true);
                        File xsdCopy = new File(String.valueOf(webinfWsdlFolder.getPath()) + "/" + fileNameWithExtension);
                        AntTasks.replace((File)xsdCopy, (String)"schemaLocation=\"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance\"", (String)"schemaLocation=\"builtInDataTypes.xsd\"");
                    } else {
                        File schemaFile = new File(fullFilePath);
                        FileUtils.copy((File)schemaFile, (File)webinfWsdlFolder, (boolean)true);
                    }
                    wsdlGenerator.addXsdModel(xsdSchema, fileLocationPath);
                }
            }
            catch (Exception e) {
                vdbResourceFinder.dispose();
                throw ErrorHandler.toCoreException((Throwable)e);
            }
        }
        vdbResourceFinder.dispose();
        wsdlGenerator.setName(webServiceName);
        wsdlGenerator.setTargetNamespace(tns);
        wsdlGenerator.setUrlRootForReferences("");
        wsdlGenerator.setUrlSuffixForReferences("");
        wsdlGenerator.setUrlForWsdlService("http://" + host + ":" + port + "/" + contextName + "/");
        IStatus status = wsdlGenerator.generate((IProgressMonitor)new NullProgressMonitor());
        if (status.getSeverity() == 4) {
            throw new RuntimeException("Unable to generate WSDL");
        }
        this.wsdlFilename = fileName = String.valueOf(webServiceName) + ".wsdl";
        try {
            FileOutputStream stream = new FileOutputStream(new File(webinfWsdlFolder, fileName));
            wsdlGenerator.write((OutputStream)stream);
            IFile iFile = vdbFile;
            iFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            this.setPorts(wsdlGenerator.getPorts());
            this.setOperationToProcedureMap(wsdlGenerator.getOperationToProcedureMap());
        }
        catch (Exception e) {
            throw ErrorHandler.toCoreException((Throwable)e);
        }
        return hasGlobalDataType;
    }

    private boolean containsGlobalDataTypeImport(XSDSchema schema) {
        boolean containsImport = false;
        if (schema != null) {
            EList contents = schema.getContents();
            int i = 0;
            while (i < contents.size()) {
                Object content = contents.get(i);
                if (content instanceof XSDImport && "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(((XSDImport)content).getNamespace())) {
                    containsImport = true;
                    break;
                }
                ++i;
            }
        }
        return containsImport;
    }

    private XSDSchema importSchema(String path) {
        XSDParser parser = new XSDParser(null);
        parser.parse(path);
        XSDSchema schema = parser.getSchema();
        schema.setSchemaLocation(path);
        return schema;
    }

    private String createServletTags(List<String> tags) {
        StringBuffer servletTags = new StringBuffer();
        String startServlet = "\t<servlet>\n";
        String endServlet = "\t</servlet>\n";
        String startServletName = "\t\t<servlet-name>";
        String endServletName = "</servlet-name>\n";
        String startServletClass = "\t\t<servlet-class>org.teiid.soap.provider.";
        String endServletClass = "</servlet-class>\n\t\t<load-on-startup>1</load-on-startup>\n";
        String startServletMapping = "\t<servlet-mapping>\n";
        String endServletMapping = "\t</servlet-mapping>\n";
        String startUrlPattern = "\t\t<url-pattern>/";
        String endUrlPattern = "</url-pattern>\n";
        for (String port : tags) {
            servletTags.append(startServlet).append(startServletName).append(port).append(endServletName);
            servletTags.append(startServletClass).append(port).append(endServletClass).append(endServlet);
            servletTags.append(startServletMapping).append(startServletName).append(port).append(endServletName);
            servletTags.append(startUrlPattern).append(port).append(endUrlPattern).append(endServletMapping);
        }
        return servletTags.toString();
    }

    private String createEndpointTags(Properties properties, SecurityCredentials securityCredentials, List<String> tags) {
        String contextName = (String)properties.get("ContextName");
        String tns = (String)properties.get("tns");
        StringBuffer endpointTags = new StringBuffer();
        String startJaxwsEndpoint = "\t<jaxws:endpoint id=";
        String endJaxwsEndpoint = "\t</jaxws:endpoint>\n";
        String serviceName = " serviceName=\"s:";
        String implementor = "\n\t\timplementor=\"org.teiid.soap.provider.";
        String wsdlLocation = " \n\t\twsdlLocation=\"WEB-INF/wsdl/";
        String namespace = " xmlns:s=\"";
        String wsseInterceptor1 = "\t\t<jaxws:inInterceptors>\n\t\t\t<ref bean=\"UsernameToken_Request\" />\n\t\t\t<bean ";
        String wsseInterceptor2 = "class=\"org.apache.cxf.binding.soap.saaj.SAAJInInterceptor\" />\n\t\t</jaxws:inInterceptors>\n";
        String useMTOM = "\t\t<jaxws:properties>\n\t\t\t<entry key=\"mtom-enabled\" value=\"true\"/>\n\t\t</jaxws:properties>\n";
        for (String port : tags) {
            endpointTags.append(startJaxwsEndpoint).append("\"").append(port).append("\"").append(serviceName);
            endpointTags.append(contextName).append("\"");
            endpointTags.append(implementor).append(port).append("\"").append(wsdlLocation).append(this.wsdlFilename).append("\"");
            endpointTags.append(namespace).append(tns).append("\">\n");
            if (securityCredentials.hasType(WarDeploymentInfoPanel.WSSE)) {
                endpointTags.append(wsseInterceptor1).append(wsseInterceptor2);
            }
            if (this.isUseMTOM(properties)) {
                endpointTags.append(useMTOM);
            }
            endpointTags.append(endJaxwsEndpoint);
        }
        return endpointTags.toString();
    }

    class URLValidator
    implements Serializable {
        private static final long serialVersionUID = -4756137226908808631L;

        URLValidator() {
        }

        public boolean isValidValue(Object value) {
            if (value instanceof String) {
                try {
                    new URL(value.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return true;
            }
            return value instanceof URL;
        }
    }
}

