/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.views.TeiidServerContentProvider;
import org.teiid.designer.runtime.ui.views.content.DataSourcesFolder;
import org.teiid.designer.runtime.ui.views.content.ITeiidContainerNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.TeiidErrorNode;
import org.teiid.designer.runtime.ui.views.content.TeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TranslatorsFolder;
import org.teiid.designer.runtime.ui.views.content.VdbsFolder;

public class TeiidServerContainerNode<T extends ITeiidResourceNode>
extends TeiidContentNode<T>
implements ITeiidContainerNode<T> {
    private List<ITeiidContentNode<TeiidServerContainerNode>> children;
    private ITeiidServer teiidServer;
    private TeiidServerContentProvider provider;
    private TeiidErrorNode error;
    private ITeiidServerManager serverManager;

    protected TeiidServerContainerNode(T parent, TeiidServerContentProvider provider) {
        super(parent, parent.getTeiidServer().getDisplayName());
        this.teiidServer = parent.getTeiidServer();
        this.provider = provider;
        this.serverManager = DqpPlugin.getInstance().getServerManager();
    }

    private void clearError() {
        if (this.error != null) {
            this.error.dispose();
            this.error = null;
        }
    }

    @Override
    public T getContainer() {
        return (T)((ITeiidResourceNode)super.getContainer());
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public final List<? extends ITeiidContentNode<?>> getChildren() {
        if (this.error != null) {
            return Collections.singletonList(this.error);
        }
        return this.children;
    }

    private void clearChildren() {
        this.clearError();
        if (this.children != null) {
            for (ITeiidContentNode<TeiidServerContainerNode> child : this.children) {
                child.dispose();
            }
            this.children.clear();
            this.children = null;
        }
    }

    protected void setError(TeiidErrorNode error) {
        this.clearError();
        this.error = error;
    }

    @Override
    public void dispose() {
        this.clearChildren();
        super.dispose();
    }

    @Override
    public final void load() {
        this.clearChildren();
        if (this.getServer().getServerState() != 2) {
            this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(TeiidServerContainerNode.class.getSimpleName()) + ".ServerContentLabelNotConnected", new Object[0])));
            return;
        }
        if (!this.teiidServer.isConnected()) {
            return;
        }
        this.children = new ArrayList<ITeiidContentNode<TeiidServerContainerNode>>();
        try {
            List<ITeiidTranslator> translators;
            Collection dataSources = this.teiidServer.getDataSources();
            if (this.provider.isShowDataSources() && !dataSources.isEmpty()) {
                ArrayList<ITeiidDataSource> filteredDataSources = new ArrayList<ITeiidDataSource>(dataSources.size());
                for (ITeiidDataSource dataSource : dataSources) {
                    if (!this.provider.isShowPreviewDataSources() && dataSource.isPreview()) continue;
                    if (dataSource.isPreview()) {
                        if (!dataSource.getName().contains(ModelerCore.workspaceUuid().toString())) continue;
                        filteredDataSources.add(dataSource);
                        continue;
                    }
                    filteredDataSources.add(dataSource);
                }
                if (!filteredDataSources.isEmpty()) {
                    this.children.add(new DataSourcesFolder(this, (Collection<ITeiidDataSource>)filteredDataSources));
                }
            }
            Collection vdbs = this.teiidServer.getVdbs();
            if (this.provider.isShowVDBs() && !vdbs.isEmpty()) {
                ArrayList<ITeiidVdb> filteredVdbs = new ArrayList<ITeiidVdb>(vdbs.size());
                for (ITeiidVdb vdb : vdbs) {
                    if (!this.provider.isShowPreviewVDBs() && vdb.isPreviewVdb()) continue;
                    if (vdb.isPreviewVdb()) {
                        if (!vdb.getName().contains(ModelerCore.workspaceUuid().toString())) continue;
                        filteredVdbs.add(vdb);
                        continue;
                    }
                    filteredVdbs.add(vdb);
                }
                if (!filteredVdbs.isEmpty()) {
                    this.children.add(new VdbsFolder(this, (Collection<ITeiidVdb>)filteredVdbs));
                }
            }
            if (this.provider.isShowTranslators()) {
                translators = new ArrayList(this.teiidServer.getTranslators());
                if (!translators.isEmpty()) {
                    this.children.add(new TranslatorsFolder(this, (Collection<ITeiidTranslator>)translators));
                }
            } else {
                translators = Collections.emptyList();
            }
            this.clearError();
        }
        catch (Exception e) {
            this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(TeiidServerContainerNode.class.getSimpleName()) + ".ServerContentLabelNotConnected", new Object[0])));
            DqpPlugin.Util.log((Throwable)e);
        }
    }

    public ITeiidServer getTeiidServer() {
        return this.teiidServer;
    }

    @Override
    public String getName() {
        ITeiidServer defaultServer = this.serverManager.getDefaultServer();
        int serverCount = this.serverManager.getServers().size();
        String name = super.getName();
        if (this.getTeiidServer() != null && serverCount > 1 && this.getTeiidServer() == defaultServer) {
            name = String.valueOf(name) + "  " + DqpUiConstants.UTIL.getString(String.valueOf(TeiidServerContainerNode.class.getSimpleName()) + ".ServerContentLabelDefault", new Object[0]);
        }
        return name;
    }

    public String toString() {
        if (this.teiidServer == null) {
            return DqpUiConstants.UTIL.getString(String.valueOf(TeiidResourceNode.class.getSimpleName()) + ".labelNotConnected", new Object[0]);
        }
        String ttip = this.teiidServer.toString();
        if (this.teiidServer.getConnectionError() != null) {
            ttip = String.valueOf(ttip) + "\n\n" + this.teiidServer.getConnectionError();
        }
        return ttip;
    }
}

