/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;

public class ServerSelectionDialog
extends TitleAreaDialog
implements DqpUiConstants,
IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ServerSelectionDialog.class);
    private static final String NO_DEFAULT = "No Default";
    private ITeiidServer selectedServer;
    private Combo serversCombo;
    private boolean includeNoDefaultOption = false;
    private Map<String, ITeiidServer> serverMap = new HashMap<String, ITeiidServer>();

    public ServerSelectionDialog(Shell parentShell, boolean includeNoDefaultOption) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.includeNoDefaultOption = includeNoDefaultOption;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(true);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginTop = 25;
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
        this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "initialMessage", new Object[0]));
        this.serversCombo = new Combo(panel, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.serversCombo.setLayoutData((Object)gd);
        this.serversCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ServerSelectionDialog.this.selectedServer = null;
                String serverName = ServerSelectionDialog.this.serversCombo.getItem(ServerSelectionDialog.this.serversCombo.getSelectionIndex());
                ServerSelectionDialog.this.selectedServer = (ITeiidServer)ServerSelectionDialog.this.serverMap.get(serverName);
                ServerSelectionDialog.this.updateState();
            }
        });
        Collection teiidServers = DqpPlugin.getInstance().getServerManager().getServers();
        ITeiidServer currentDefault = DqpPlugin.getInstance().getServerManager().getDefaultServer();
        String currentServerStr = null;
        currentServerStr = currentDefault == null ? NO_DEFAULT : currentDefault.toString();
        if (this.includeNoDefaultOption) {
            this.serverMap.put(NO_DEFAULT, null);
        }
        for (ITeiidServer teiidServer : teiidServers) {
            this.serverMap.put(teiidServer.toString(), teiidServer);
        }
        WidgetUtil.setComboItems((Combo)this.serversCombo, this.serverMap.keySet(), null, (boolean)true);
        boolean setInitial = false;
        int i = 0;
        while (i < this.serversCombo.getItemCount()) {
            String serverName = this.serversCombo.getItem(i);
            if (serverName != null && serverName.equalsIgnoreCase(currentServerStr)) {
                this.serversCombo.select(i);
                this.selectedServer = this.serverMap.get(serverName);
                setInitial = true;
                break;
            }
            ++i;
        }
        if (!setInitial && this.serversCombo.getItemCount() > 0) {
            this.serversCombo.select(0);
        }
        return panel;
    }

    public ITeiidServer getServer() {
        return this.selectedServer;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        this.getButton(0).setEnabled(true);
        if (!this.includeNoDefaultOption && this.serversCombo.getItemCount() == 0) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(UTIL.getString(String.valueOf(PREFIX) + "noServersExistMessage", new Object[0]));
            return;
        }
        if (this.includeNoDefaultOption && this.serversCombo.getItemCount() == 1) {
            this.setErrorMessage(null);
            this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "noServersExistMessage", new Object[0]));
        }
    }
}

