/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.server.EditServerAction;
import org.teiid.designer.runtime.ui.server.NewServerAction;
import org.teiid.designer.runtime.ui.server.RefreshServerAction;
import org.teiid.designer.runtime.ui.server.ServerSelectionDialog;
import org.teiid.designer.runtime.ui.server.SetDefaultServerAction;

public final class RuntimeAssistant {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(RuntimeAssistant.class);
    private static boolean selectServerCancelled = false;

    public static boolean ensurePreviewEnabled(Shell shell) {
        boolean previewEnabled = RuntimeAssistant.isPreviewEnabled();
        boolean previewServerExists = RuntimeAssistant.previewServerExists();
        boolean serverCreatedNotStarted = false;
        String msg = null;
        if (!previewEnabled && !previewServerExists) {
            msg = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "previewDisabledNoTeiidInstanceMsg", new Object[0]);
        } else if (!previewEnabled) {
            msg = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "previewDisabledMsg", new Object[0]);
        } else if (!previewServerExists) {
            msg = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "noTeiidInstanceMsg", new Object[0]);
        }
        if (msg != null && MessageDialog.openQuestion((Shell)shell, (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "confirmEnablePreviewTitle", new Object[0]), (String)msg)) {
            if (!previewEnabled) {
                IEclipsePreferences prefs = DqpPlugin.getInstance().getPreferences();
                prefs.putBoolean("org.teiid.designer.dqp.preferences.PreviewEnabled", true);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    DqpUiConstants.UTIL.log((Throwable)e);
                }
            }
            if (!previewServerExists) {
                RuntimeAssistant.runNewServerAction(shell);
                serverCreatedNotStarted = RuntimeAssistant.previewServerExists();
            }
        }
        if (msg != null) {
            previewEnabled = RuntimeAssistant.isPreviewEnabled();
            previewServerExists = RuntimeAssistant.previewServerExists();
            if (!previewEnabled || !previewServerExists) {
                return false;
            }
        }
        return RuntimeAssistant.serverConnectionExists(shell, serverCreatedNotStarted);
    }

    public static boolean ensureServerConnection(Shell shell, String dialogMessage, boolean ignoreFailedConnection) {
        if (!RuntimeAssistant.previewServerExists()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "confirmCreateTeiidInstanceTitle", new Object[0]), (String)dialogMessage)) {
                RuntimeAssistant.runNewServerAction(shell);
            }
            if (!RuntimeAssistant.previewServerExists()) {
                return false;
            }
        }
        return RuntimeAssistant.serverConnectionExists(shell, ignoreFailedConnection);
    }

    private static ITeiidServer getServer() {
        return RuntimeAssistant.getServerManager().getDefaultServer();
    }

    private static ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    private static boolean isPreviewEnabled() {
        return PreviewManager.getInstance().isPreviewEnabled();
    }

    private static boolean previewServerExists() {
        return RuntimeAssistant.getServerManager().getDefaultServer() != null;
    }

    public static void runNewServerAction(Shell shell) {
        NewServerAction action = new NewServerAction(shell);
        action.run();
    }

    public static void runEditServerAction(Shell shell) {
        EditServerAction action = new EditServerAction();
        action.run();
    }

    public static void runSetDefaultServerAction() {
        SetDefaultServerAction action = new SetDefaultServerAction();
        action.run();
    }

    public static void runRefreshServerAction() {
        RefreshServerAction action = new RefreshServerAction();
        action.run();
    }

    private static boolean serverConnectionExists(Shell shell, boolean ignoreFailedConnection) {
        assert (RuntimeAssistant.getServer() != null);
        if (!RuntimeAssistant.getServer().isConnected()) {
            if (!ignoreFailedConnection) {
                MessageDialog.openWarning((Shell)shell, (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "teiidNotConnectedTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "teiidNotConnectedMsg", (Object)RuntimeAssistant.getServer().getParentName()));
            }
            return false;
        }
        return true;
    }

    public static <T> T adapt(Object adaptableObject, Class<T> klazz) {
        return (T)Platform.getAdapterManager().getAdapter(adaptableObject, klazz);
    }

    public static ITeiidServer getServerFromSelection(ISelection selection) {
        if (selection == null || !(selection instanceof StructuredSelection)) {
            return null;
        }
        if (selection.isEmpty()) {
            return null;
        }
        StructuredSelection ss = (StructuredSelection)selection;
        Object element = ss.getFirstElement();
        return RuntimeAssistant.adapt(element, ITeiidServer.class);
    }

    private RuntimeAssistant() {
    }

    public static ITeiidServer selectServer(Shell shell, boolean includeNoDefaultOption) {
        ITeiidServer selectedServer = null;
        selectServerCancelled = false;
        if (RuntimeAssistant.getServerManager().getServers().size() == 1) {
            selectedServer = (ITeiidServer)RuntimeAssistant.getServerManager().getServers().iterator().next();
        } else if (RuntimeAssistant.getServerManager().getServers().size() > 1) {
            ServerSelectionDialog dialog = new ServerSelectionDialog(shell, includeNoDefaultOption);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                selectedServer = dialog.getServer();
            } else {
                selectServerCancelled = true;
            }
        }
        return selectedServer;
    }

    public static boolean selectServerWasCancelled() {
        return selectServerCancelled;
    }

    public static boolean hasAvailableServers() {
        return RuntimeAssistant.getServerManager().getServers().size() > 0;
    }
}

