/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;

public final class EditServerAction
extends BaseSelectionListenerAction
implements IHandler {
    private ITeiidServer serverBeingEdited = null;

    public EditServerAction() {
        super(DqpUiConstants.UTIL.getString("editServerActionText", new Object[0]));
        this.setToolTipText(DqpUiConstants.UTIL.getString("editServerActionToolTip", new Object[0]));
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/edit-teiid-server.png"));
        this.setEnabled(true);
    }

    public void run() {
        if (this.serverBeingEdited == null) {
            this.serverBeingEdited = RuntimeAssistant.selectServer(EditServerAction.getShell(), false);
            if (RuntimeAssistant.selectServerWasCancelled()) {
                return;
            }
        }
        if (this.serverBeingEdited == null) {
            String title = DqpUiConstants.UTIL.getString("noServerAvailableTitle", new Object[0]);
            String message = DqpUiConstants.UTIL.getString("noServerAvailableMessage", new Object[0]);
            MessageDialog.openError((Shell)EditServerAction.getShell(), (String)title, (String)message);
            return;
        }
        ServerUIPlugin.editServer((IServer)this.serverBeingEdited.getParent());
    }

    private static Shell getShell() {
        return DqpUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() > 1) {
            this.serverBeingEdited = null;
            return false;
        }
        ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection((ISelection)selection);
        if (teiidServer != null) {
            this.serverBeingEdited = teiidServer;
            return true;
        }
        this.serverBeingEdited = null;
        return false;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) {
        Object object = event.getTrigger();
        if (object instanceof Event) {
            Event swtEvent = (Event)object;
            Object data = swtEvent.data;
            if (data instanceof ITeiidServer) {
                this.serverBeingEdited = (ITeiidServer)data;
            }
        }
        this.run();
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

