/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ResourceAnnotationHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class DeleteDataSourceAction
extends SortableSelectionAction
implements DqpUiConstants {
    private static final String label = DqpUiConstants.UTIL.getString("DeleteDataSourceAction.label", new Object[0]);
    public static final String JDBC_DS_TYPE = "connector-jdbc";

    public DeleteDataSourceAction() {
        super(label, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    public void run() {
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        try {
            this.removeDataSource(modelFile);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)DqpUiConstants.UTIL.getString("DeleteDataSourceAction.errorRemovingDataSource", (Object)modelFile.getName()), (String)e.getMessage());
            DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("DeleteDataSourceAction.errorRemovingDataSource", (Object)modelFile.getName()));
        }
    }

    public boolean removeDataSource(IFile modelFile) throws Exception {
        Properties properties = this.getConnectionProperties(modelFile);
        if (properties != null && !properties.isEmpty()) {
            ITeiidServer teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
            String name = modelFile.getFullPath().removeFileExtension().lastSegment();
            String jndiName = new ConnectionInfoHelper().generateUniqueConnectionJndiName(name, modelFile.getFullPath(), ModelerCore.workspaceUuid().toString());
            teiidServer.deleteDataSource(jndiName);
            return true;
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public Properties getConnectionProperties(IFile model) {
        ModelResource modelResource = null;
        try {
            modelResource = ModelUtil.getModelResource((IFile)model, (boolean)true);
            if (modelResource != null) {
                ResourceAnnotationHelper resourceHelper = new ResourceAnnotationHelper();
                return resourceHelper.getProperties(modelResource, "connectionProfile:");
            }
            DqpUiConstants.UTIL.log(4, DqpUiConstants.UTIL.getString("DeleteDataSourceAction.errorCannotFindDataSourceProperties", (Object)model.getName()));
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            DqpUiConstants.UTIL.log(4, DqpUiConstants.UTIL.getString("DeleteDataSourceAction.errorFindingModelResource", (Object)model.getName()));
        }
        return null;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

