/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.metamodels.relational.impl.ProcedureImpl;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.wizards.webservices.RestWarDeploymentInfoDialog;
import org.teiid.designer.runtime.ui.wizards.webservices.util.RestProcedure;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WarArchiveUtil;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbModelEntry;

public class GenerateRestWarAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(GenerateRestWarAction.class);
    private static final String VDB_EXTENSION = "vdb";
    private static final ModelObjectAnnotationHelper ANNOTATION_HELPER = new ModelObjectAnnotationHelper();
    private IFile selectedVDB;
    private Map<String, List<RestProcedure>> restfulProcedureMap = new HashMap<String, List<RestProcedure>>();
    private Properties designerProperties;

    public GenerateRestWarAction() {
        this.setText(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "text", new Object[0]));
        this.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "tooltip", new Object[0]));
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.setDisabledImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.setEnabled(false);
    }

    public void setDesingerProperties(Properties properties) {
        this.designerProperties = properties;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        String extension;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (extension = ((IFile)obj).getFileExtension()) != null && extension.equals(VDB_EXTENSION)) {
            result = true;
        }
        return result;
    }

    public void run() {
        boolean wasSuccessful;
        final IWorkbenchWindow window = DqpUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        boolean cont = true;
        if (compiler == null) {
            cont = MessageDialog.openConfirm((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "javaWarningTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "invalidJDKMessage", new Object[0]));
        }
        if (!cont) {
            this.notifyResult(false);
            return;
        }
        RestWarDeploymentInfoDialog dialog = null;
        dialog = new RestWarDeploymentInfoDialog(window.getShell(), this.selectedVDB, this.restfulProcedureMap, null, this.designerProperties);
        int rc = dialog.open();
        String warFileName = dialog.getWarFileName();
        final String successMessage = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "warFileCreated", (Object)warFileName);
        boolean bl = wasSuccessful = rc == 0;
        if (wasSuccessful) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "creationCompleteTitle", new Object[0]), (String)successMessage);
                }
            });
        } else if (rc != 1) {
            MessageDialog.openError((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "creationFailedTitle", new Object[0]), (String)dialog.getMessage());
        }
        this.notifyResult(rc == 0);
    }

    private static boolean isVdb(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IFile)) {
            return false;
        }
        return VDB_EXTENSION.equals(((IFile)obj).getFileExtension());
    }

    private static List<RestProcedure> findRestProcedures(ModelResource modelResource) throws Exception {
        ArrayList<RestProcedure> restfulProcedureArray = new ArrayList<RestProcedure>();
        List eObjectList = modelResource.getEObjects();
        for (EObject eObject : eObjectList) {
            if (!SqlAspectHelper.isProcedure((EObject)eObject)) continue;
            IPath path = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eObject);
            StringBuffer sb = new StringBuffer();
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                if (i != 0) {
                    sb.append('.');
                }
                String segment = segments[i];
                sb.append(segment);
                ++i;
            }
            String fullName = sb.toString();
            String name = ((ProcedureImpl)eObject).getName();
            GenerateRestWarAction.createRestProcedureCollection((Procedure)eObject, name, fullName, restfulProcedureArray);
        }
        return restfulProcedureArray;
    }

    public boolean setSelection(ISelection selection) {
        if (SelectionUtilities.isMultiSelection((ISelection)selection)) {
            return false;
        }
        Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
        if (!(obj instanceof IFile)) {
            return false;
        }
        if (!GenerateRestWarAction.isVdb(obj)) {
            return false;
        }
        this.selectedVDB = (IFile)obj;
        boolean result = false;
        try {
            Vdb vdb = new Vdb(this.selectedVDB, (IProgressMonitor)new NullProgressMonitor());
            Set modelEntrySet = vdb.getModelEntries();
            for (VdbModelEntry vdbModelEntry : modelEntrySet) {
                List<RestProcedure> restfulProcedureArray;
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(vdbModelEntry.getName());
                if (!ModelIdentifier.isVirtualModelType((ModelResource)modelResource) || (restfulProcedureArray = GenerateRestWarAction.findRestProcedures(modelResource)).size() <= 0) continue;
                String modelName = FileUtils.getFilenameWithoutExtension((String)vdbModelEntry.getName().lastSegment());
                this.restfulProcedureMap.put(modelName, restfulProcedureArray);
                result = true;
            }
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return false;
        }
        return result;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean enable = this.setSelection(selection);
        this.setEnabled(enable);
    }

    private static String getHeaders(Procedure procedure) {
        Object headers = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            headers = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.HEADERS);
            if (headers == null || CoreStringUtil.isEmpty((String)headers)) {
                headers = ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:headers");
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return headers == null ? "" : (String)headers;
    }

    private static String getCharset(Procedure procedure) {
        String charset = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            charset = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.CHARSET);
            if (CoreStringUtil.isEmpty((String)charset)) {
                charset = (String)ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:CHARSET");
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return charset;
    }

    private static void createRestProcedureCollection(Procedure procedure, String name, String fullName, List restfulProcedureArray) {
        String restMethod = WarArchiveUtil.getRestMethod(procedure);
        LinkedList<String> queryParameterList = new LinkedList<String>();
        LinkedList<String> headerParameterList = new LinkedList<String>();
        if (restMethod != null) {
            String uri = WarArchiveUtil.getUri(procedure);
            String charSet = GenerateRestWarAction.getCharset(procedure);
            if (charSet == null) {
                charSet = Charset.defaultCharset().name();
            }
            if (uri != null) {
                boolean hasReturn = false;
                int parameterCount = procedure.getParameters().size();
                int uriParameterCount = 0;
                RestProcedure restProcedure = new RestProcedure();
                EList contents = procedure.eContents();
                for (EObject eobject : contents) {
                    if (!SqlAspectHelper.isProcedureResultSet((EObject)eobject)) continue;
                    hasReturn = true;
                }
                String headers = GenerateRestWarAction.getHeaders(procedure);
                if (headers.length() > 0) {
                    String[] headerParameterArray;
                    String[] stringArray = headerParameterArray = headers.split(";");
                    int n = headerParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String param = stringArray[n2];
                        headerParameterList.addLast(param);
                        ++n2;
                    }
                }
                String uriString = uri;
                int i = 0;
                while (i < uriString.length()) {
                    String character = uriString.substring(i, i + 1);
                    if (character.equals("{")) {
                        ++uriParameterCount;
                    }
                    ++i;
                }
                if (uriString.indexOf("&") > -1) {
                    String[] queryParameterArray = uriString.split("&");
                    int i2 = 0;
                    String[] stringArray = queryParameterArray;
                    int n = queryParameterArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String param = stringArray[n3];
                        if (++i2 == 1) {
                            uri = param;
                        } else {
                            queryParameterList.addLast(param);
                        }
                        ++n3;
                    }
                }
                restProcedure.setCharSet(charSet);
                restProcedure.setRestMethod(restMethod);
                restProcedure.setUri(uri);
                restProcedure.setProcedureName(name);
                restProcedure.setFullyQualifiedProcedureName(fullName);
                restProcedure.setQueryParameterList(queryParameterList);
                restProcedure.setHeaderParameterList(headerParameterList);
                RestProcedure jsonRestProcedure = new RestProcedure();
                jsonRestProcedure.setCharSet(charSet);
                jsonRestProcedure.setFullyQualifiedProcedureName(restProcedure.getFullyQualifiedProcedureName());
                jsonRestProcedure.setModelName(restProcedure.getModelName());
                jsonRestProcedure.setProcedureName(restProcedure.getProcedureName());
                jsonRestProcedure.setRestMethod(restProcedure.getRestMethod());
                jsonRestProcedure.setUri(restProcedure.getUri());
                jsonRestProcedure.setQueryParameterList(queryParameterList);
                jsonRestProcedure.setHeaderParameterList(headerParameterList);
                boolean hasInputStream = false;
                if (uriParameterCount + headerParameterList.size() < parameterCount && queryParameterList.size() + headerParameterList.size() < parameterCount) {
                    hasInputStream = true;
                    restProcedure.setConsumesAnnotation("@Consumes( MediaType.APPLICATION_XML )");
                    jsonRestProcedure.setConsumesAnnotation("@Consumes( MediaType.APPLICATION_JSON )");
                }
                if (hasReturn) {
                    restProcedure.setProducesAnnotation("@Produces( MediaType.APPLICATION_XML+\"; charset=" + charSet + "\")");
                    jsonRestProcedure.setProducesAnnotation("@Produces( MediaType.APPLICATION_JSON+\"; charset=" + charSet + "\")");
                }
                restfulProcedureArray.add(restProcedure);
                if (hasReturn || hasInputStream) {
                    restfulProcedureArray.add(jsonRestProcedure);
                }
            }
        }
    }
}

