/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.util.UiUtil;

public class ListMessageDialog
extends MessageDialog {
    private static final String[] DEFAULT_BUTTONS = new String[]{IDialogConstants.OK_LABEL};
    private static final String[] QUESTION_BUTTONS = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
    private List items;
    private IBaseLabelProvider labelProvider;
    private ListViewer viewer;

    private static int openDialog(Shell theShell, String theTitle, Image theImage, String theMessage, int theDialogType, List theItems, IBaseLabelProvider theLabelProvider) {
        return ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, theDialogType, theItems, theLabelProvider, DEFAULT_BUTTONS);
    }

    private static int openDialog(Shell theShell, String theTitle, Image theImage, String theMessage, int theDialogType, List theItems, IBaseLabelProvider theLabelProvider, String[] dialogButtonLabels) {
        ListMessageDialog dialog = new ListMessageDialog(theShell, theTitle, theImage, theMessage, theDialogType, dialogButtonLabels);
        dialog.setLabelProvider(theLabelProvider);
        dialog.setItems(theItems);
        return dialog.open();
    }

    public static void openError(Shell theShell, String theTitle, Image theImage, String theMessage, List theItems, IBaseLabelProvider theLabelProvider) {
        ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, 1, theItems, theLabelProvider);
    }

    public static void openInformation(Shell theShell, String theTitle, Image theImage, String theMessage, List theItems, IBaseLabelProvider theLabelProvider) {
        ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, 2, theItems, theLabelProvider);
    }

    public static void openWarning(Shell theShell, String theTitle, Image theImage, String theMessage, List theItems, IBaseLabelProvider theLabelProvider) {
        ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, 4, theItems, theLabelProvider);
    }

    public static boolean openQuestion(Shell theShell, String theTitle, Image theImage, String theMessage, List theItems, IBaseLabelProvider theLabelProvider) {
        return ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, 3, theItems, theLabelProvider, QUESTION_BUTTONS) == 0;
    }

    public static boolean openWarningQuestion(Shell theShell, String theTitle, Image theImage, String theMessage, List theItems, IBaseLabelProvider theLabelProvider) {
        return ListMessageDialog.openDialog(theShell, theTitle, theImage, theMessage, 4, theItems, theLabelProvider, QUESTION_BUTTONS) == 0;
    }

    protected ListMessageDialog(Shell theShell, String theTitle, Image theImage, String theMessage, int theDialogImageType, String[] dialogButtonLabels) {
        super(theShell, theTitle, null, theMessage, theDialogImageType, dialogButtonLabels, 0);
    }

    protected Control createCustomArea(Composite theParent) {
        this.viewer = new ListViewer(theParent, 35592);
        org.eclipse.swt.widgets.List list = this.viewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        list.setBackground(UiUtil.getSystemColor(22));
        if (this.labelProvider != null) {
            this.viewer.setLabelProvider(this.labelProvider);
        }
        if (this.items == null) {
            this.items = Collections.EMPTY_LIST;
        }
        this.viewer.add(this.items.toArray());
        return list;
    }

    protected void setItems(List theItems) {
        List oldItems = this.items;
        this.items = theItems;
        if (this.viewer != null) {
            this.viewer.remove((Object)oldItems);
            this.viewer.add((Object)this.items);
        }
    }

    protected void setLabelProvider(IBaseLabelProvider theLabelProvider) {
        this.labelProvider = theLabelProvider;
        if (this.viewer != null) {
            this.viewer.setLabelProvider(this.labelProvider);
        }
    }
}

