/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;

public abstract class TreeViewerUtil {
    public static List getDescendantsOfNode(TreeViewer viewer, Object node, boolean includeNode) {
        ArrayList<Object> result = null;
        ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
        if (provider != null) {
            result = new ArrayList<Object>();
            if (includeNode) {
                result.add(node);
            }
            Object[] children = provider.getChildren(node);
            int i = 0;
            while (i < children.length) {
                result.add(children[i]);
                List childsChildren = TreeViewerUtil.getDescendantsOfNode(viewer, children[i], false);
                result.addAll(childsChildren);
                ++i;
            }
        }
        return result;
    }

    public static List getRootNodes(TreeViewer viewer) {
        List<Object> result = Collections.EMPTY_LIST;
        ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
        if (provider != null) {
            Object[] children = provider.getChildren(viewer.getInput());
            result = Arrays.asList(children);
        }
        return result;
    }

    public static void setAllChecked(CheckboxTreeViewer viewer, boolean checkedState) {
        TreeViewerUtil.setSubtreeChecked(viewer, viewer.getInput(), checkedState);
    }

    public static void setSubtreeChecked(CheckboxTreeViewer viewer, Object node, boolean checkedState) {
        ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
        if (provider == null) {
            return;
        }
        Object[] children = provider.getChildren(node);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            viewer.setChecked(child, checkedState);
            viewer.setSubtreeChecked(node, checkedState);
            ++i;
        }
    }

    public static boolean allDescendantsHaveState(CheckboxTreeViewer viewer, Object node, boolean checkedState) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        boolean mismatchFound = false;
        Object[] children = contentProvider.getChildren(node);
        int i = 0;
        while (i < children.length && !mismatchFound) {
            if (viewer.getChecked(children[i]) != checkedState) {
                mismatchFound = true;
                continue;
            }
            if (!TreeViewerUtil.allDescendantsHaveState(viewer, children[i], checkedState)) {
                mismatchFound = true;
                continue;
            }
            ++i;
        }
        return !mismatchFound;
    }

    public static boolean allDescendantsChecked(CheckboxTreeViewer viewer, Object node) {
        boolean allChecked = TreeViewerUtil.allDescendantsHaveState(viewer, node, true);
        return allChecked;
    }

    public static boolean anyDescendantChecked(CheckboxTreeViewer viewer, Object node) {
        boolean anyChecked = !TreeViewerUtil.allDescendantsHaveState(viewer, node, false);
        return anyChecked;
    }
}

