/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.ui.common.tree.TreeNodeMap;

public class TreeExpansionMonitor
implements TreeListener,
IChangeNotifier {
    private static final String VISIBLE = "TreeExpansionMonitor.visible";
    protected TreeViewer treeViewer;
    protected List visibleNodes;
    protected List visibleTreeItems;
    protected ArrayList listenerList = new ArrayList();
    protected boolean isStale = true;

    public TreeExpansionMonitor(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        treeViewer.getTree().addTreeListener((TreeListener)this);
    }

    public void dispose() {
        Tree tree = this.treeViewer.getTree();
        if (tree != null && !tree.isDisposed()) {
            tree.removeTreeListener((TreeListener)this);
        }
    }

    public void setIsStale(boolean bIsStale) {
        this.isStale = bIsStale;
    }

    public List getVisibleObjects() {
        if (this.isStale || this.visibleNodes == null) {
            this.treeViewer.getTree().update();
            TreeItem[] items = this.treeViewer.getTree().getItems();
            this.visibleTreeItems = new ArrayList(items.length);
            ArrayList nodes = new ArrayList(items.length);
            this.internalGetVisibleObjects(this.visibleTreeItems, nodes, items);
            this.isStale = false;
            this.visibleNodes = Collections.unmodifiableList(nodes);
        }
        return this.visibleNodes;
    }

    public TreeNodeMap getVisibleObjectsAsMap() {
        if (this.isStale || this.visibleNodes == null) {
            this.treeViewer.getTree().update();
            TreeItem[] items = this.treeViewer.getTree().getItems();
            this.visibleTreeItems = new ArrayList(items.length);
            ArrayList nodes = new ArrayList(items.length);
            this.internalGetVisibleObjects(this.visibleTreeItems, nodes, items);
            this.isStale = false;
            this.visibleNodes = Collections.unmodifiableList(nodes);
        }
        return new TreeNodeMap(this.visibleNodes);
    }

    public List getVisibleTreeItems() {
        this.getVisibleObjects();
        return this.visibleTreeItems;
    }

    private void internalGetVisibleObjects(List listItems, List listObjects, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (this.isVisible(items[i]) && items[i].getData() != null) {
                listItems.add(items[i]);
                listObjects.add(items[i].getData());
                this.internalGetVisibleObjects(listItems, listObjects, items[i].getItems());
            }
            ++i;
        }
    }

    public void treeCollapsed(TreeEvent e) {
        TreeItem item = (TreeItem)e.item;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].setData(VISIBLE, (Object)Boolean.FALSE);
            ++i;
        }
        this.fireChangeEvent();
    }

    public void treeExpanded(TreeEvent e) {
        TreeItem item = (TreeItem)e.item;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].setData(VISIBLE, (Object)Boolean.TRUE);
            ++i;
        }
        this.fireChangeEvent();
    }

    public void handleAllExpanded() {
        TreeItem item = this.treeViewer.getTree().getTopItem();
        item.setData(VISIBLE, (Object)Boolean.TRUE);
        this.expandItem(item);
        this.fireChangeEvent();
    }

    private void expandItem(TreeItem item) {
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].setData(VISIBLE, (Object)Boolean.TRUE);
            this.expandItem(children[i]);
            ++i;
        }
    }

    private void collapseItem(TreeItem item) {
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].setData(VISIBLE, (Object)Boolean.FALSE);
            this.collapseItem(children[i]);
            ++i;
        }
    }

    public void handleAllCollapsed() {
        TreeItem item = this.treeViewer.getTree().getTopItem();
        this.collapseItem(item);
        item.setData(VISIBLE, (Object)Boolean.TRUE);
        this.fireChangeEvent();
    }

    protected boolean isVisible(TreeItem item) {
        boolean result = true;
        Object obj = item.getData(VISIBLE);
        if (obj != null) {
            result = (Boolean)obj;
        }
        return result;
    }

    public void fireChangeEvent() {
        this.isStale = true;
        for (IChangeListener listener : this.listenerList) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeChangeListener(IChangeListener listener) {
        this.listenerList.remove(listener);
    }
}

