/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.common.util.UiUtil;

public class StyledTextEditor
implements IMenuListener,
KeyListener,
UiConstants {
    static final String COPY_ID = ActionFactory.COPY.getId();
    static final String CUT_ID = ActionFactory.CUT.getId();
    static final String FIND_ID = ActionFactory.FIND.getId();
    static final String PASTE_ID = ActionFactory.PASTE.getId();
    static final String REDO_ID = ActionFactory.REDO.getId();
    static final String SELECT_ALL_ID = ActionFactory.SELECT_ALL.getId();
    static final String UNDO_ID = ActionFactory.UNDO.getId();
    private boolean bHaveFocus = false;
    private boolean allowCopy = true;
    private boolean allowCut = true;
    private boolean allowFind = true;
    private boolean allowPaste = true;
    private boolean allowSelectAll = true;
    private int historySize = -1;
    private boolean allowUndoRedo = true;
    private ContextMenuAction copyAction;
    private ContextMenuAction cutAction;
    private ContextMenuAction findAction;
    private ContextMenuAction pasteAction;
    private ContextMenuAction redoAction;
    private ContextMenuAction selectAllAction;
    private ContextMenuAction undoAction;
    private boolean alwaysAllowPaste = false;
    private TextViewer viewer;
    private List menuListeners;

    public static StyledTextEditor createReadOnlyEditor(Composite parent, int style) {
        StyledTextEditor result = new StyledTextEditor(parent, style);
        result.setEditable(false);
        result.setAllowCut(false);
        result.setAllowPaste(false);
        result.setAllowUndoRedo(false);
        IUndoManager undoMgr = result.viewer.getUndoManager();
        if (undoMgr != null) {
            undoMgr.disconnect();
            result.viewer.setUndoManager(null);
        }
        return result;
    }

    public StyledTextEditor(Composite parent, int style) {
        this(parent, style, -1, true, true, true, true, true, true);
    }

    public StyledTextEditor(Composite parent, int style, int historySize, boolean allowCut, boolean allowCopy, boolean allowPaste, boolean allowSelectAll, boolean allowUndoRedo, boolean allowFind) {
        this.viewer = new TextViewer(parent, style);
        this.historySize = historySize;
        this.allowCut = allowCut;
        this.allowCopy = allowCopy;
        this.allowPaste = allowPaste;
        this.allowSelectAll = allowSelectAll;
        this.allowUndoRedo = allowUndoRedo;
        this.allowFind = allowFind;
        this.configureTextViewer();
    }

    public StyledTextEditor(TextViewer viewer) {
        this.viewer = viewer;
        this.configureTextViewer();
    }

    public void addMenuListener(IMenuListener listener) {
        if (this.menuListeners == null) {
            this.menuListeners = new ArrayList(1);
        }
        if (!this.menuListeners.contains(listener)) {
            this.menuListeners.add(listener);
        }
    }

    private void configureTextViewer() {
        IUndoManager undoManager;
        if (this.historySize < 0) {
            int limit;
            IPreferencesService service = Platform.getPreferencesService();
            this.historySize = limit = service.getInt("com.eclipse.ui.editors", "undoHistorySize", 20, null);
        }
        if ((undoManager = this.viewer.getUndoManager()) == null) {
            undoManager = new TextViewerUndoManager(this.historySize);
            this.viewer.setUndoManager(undoManager);
        }
        undoManager.connect((ITextViewer)this.viewer);
        if (this.viewer.getDocument() == null) {
            Document document = new Document();
            this.viewer.setDocument((IDocument)document);
        }
        this.setDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy());
        this.configureTextWidget(this.getTextWidget());
        this.viewer.activatePlugins();
        this.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                StyledTextEditor.this.handleFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                StyledTextEditor.this.handleFocusLost(e);
            }
        });
    }

    private void configureTextWidget(StyledText styledText) {
        styledText.addKeyListener((KeyListener)this);
        MenuManager menuMgr = new MenuManager(null, null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        styledText.setMenu(menuMgr.createContextMenu((Control)styledText));
    }

    public void dispose() {
        if (this.getTextWidget() != null && !this.getTextWidget().isDisposed()) {
            this.getTextWidget().removeKeyListener((KeyListener)this);
        }
    }

    private IAction getAction(String id) {
        if (id.equals(COPY_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowCopy(), (String)"Editor does not allow Copy");
            if (this.copyAction == null) {
                this.copyAction = new ContextMenuAction(COPY_ID);
            }
            this.copyAction.setAccelerator(262211);
            this.copyAction.setEnabledState();
            return this.copyAction;
        }
        if (id.equals(CUT_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowCut(), (String)"Editor does not allow Cut");
            if (this.cutAction == null) {
                this.cutAction = new ContextMenuAction(CUT_ID);
            }
            this.cutAction.setAccelerator(262232);
            this.cutAction.setEnabledState();
            return this.cutAction;
        }
        if (id.equals(FIND_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowFind(), (String)"Editor does not allow Find");
            if (this.findAction == null) {
                this.findAction = new ContextMenuAction(FIND_ID);
            }
            this.findAction.setAccelerator(262214);
            this.findAction.setEnabledState();
            return this.findAction;
        }
        if (id.equals(PASTE_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowPaste(), (String)"Editor does not allow Paste");
            if (this.pasteAction == null) {
                this.pasteAction = new ContextMenuAction(PASTE_ID);
            }
            this.pasteAction.setAccelerator(262230);
            this.pasteAction.setEnabledState();
            return this.pasteAction;
        }
        if (id.equals(REDO_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowUndoRedo(), (String)"Editor does not allow Redo");
            if (this.redoAction == null) {
                this.redoAction = new ContextMenuAction(REDO_ID);
            }
            this.redoAction.setAccelerator(262233);
            this.redoAction.setEnabledState();
            return this.redoAction;
        }
        if (id.equals(SELECT_ALL_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowSelectAll(), (String)"Editor does not allow Select All");
            if (this.selectAllAction == null) {
                this.selectAllAction = new ContextMenuAction(SELECT_ALL_ID);
            }
            this.selectAllAction.setAccelerator(262209);
            this.selectAllAction.setEnabledState();
            return this.selectAllAction;
        }
        if (id.equals(UNDO_ID)) {
            CoreArgCheck.isTrue((boolean)this.isAllowUndoRedo(), (String)"Editor does not allow Redo");
            if (this.undoAction == null) {
                this.undoAction = new ContextMenuAction(UNDO_ID);
            }
            this.selectAllAction.setAccelerator(262234);
            this.undoAction.setEnabledState();
            return this.undoAction;
        }
        return null;
    }

    public IDocument getDocument() {
        return this.viewer.getDocument();
    }

    public String getText() {
        return this.viewer.getDocument().get();
    }

    public StyledText getTextWidget() {
        return this.viewer.getTextWidget();
    }

    public TextViewer getTextViewer() {
        return this.viewer;
    }

    public IUndoManager getUndoManager() {
        return this.viewer.getUndoManager();
    }

    protected void handleFocusGained(FocusEvent e) {
        this.bHaveFocus = true;
    }

    protected void handleFocusLost(FocusEvent e) {
        this.bHaveFocus = true;
    }

    boolean hasUndoManager() {
        return this.getUndoManager() != null;
    }

    private boolean isAllowCopy() {
        return this.allowCopy;
    }

    private boolean isAllowCut() {
        return this.allowCut;
    }

    private boolean isAllowFind() {
        return this.allowFind;
    }

    private boolean isAllowPaste() {
        return this.allowPaste;
    }

    private boolean isAllowSelectAll() {
        return this.allowSelectAll;
    }

    private boolean isAllowUndoRedo() {
        return this.allowUndoRedo && this.hasUndoManager();
    }

    public boolean isDisposed() {
        StyledText control = this.viewer.getTextWidget();
        return control == null || control.isDisposed();
    }

    public boolean isEditable() {
        return this.viewer.isEditable();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (!this.bHaveFocus) {
            return;
        }
        IAction action = null;
        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
        if (this.isAllowCopy() && accelerator == this.getAction(COPY_ID).getAccelerator()) {
            action = this.getAction(COPY_ID);
        } else if (this.isAllowCut() && accelerator == this.getAction(CUT_ID).getAccelerator()) {
            action = this.getAction(CUT_ID);
        } else if (this.isAllowFind() && accelerator == this.getAction(FIND_ID).getAccelerator()) {
            action = this.getAction(FIND_ID);
        } else if (this.isAllowPaste() && accelerator == this.getAction(PASTE_ID).getAccelerator()) {
            action = this.getAction(PASTE_ID);
        } else if (this.isAllowUndoRedo() && accelerator == this.getAction(REDO_ID).getAccelerator()) {
            action = this.getAction(REDO_ID);
        } else if (this.isAllowSelectAll() && accelerator == this.getAction(SELECT_ALL_ID).getAccelerator()) {
            action = this.getAction(SELECT_ALL_ID);
        } else if (this.isAllowUndoRedo() && accelerator == this.getAction(UNDO_ID).getAccelerator()) {
            action = this.getAction(UNDO_ID);
        }
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public void menuAboutToShow(IMenuManager menuMgr) {
        if (this.isAllowCut()) {
            menuMgr.add(this.getAction(CUT_ID));
        }
        if (this.isAllowCopy()) {
            menuMgr.add(this.getAction(COPY_ID));
        }
        if (this.isAllowPaste()) {
            menuMgr.add(this.getAction(PASTE_ID));
        }
        if (this.isAllowSelectAll()) {
            menuMgr.add(this.getAction(SELECT_ALL_ID));
        }
        if (this.isAllowUndoRedo()) {
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add(this.getAction(UNDO_ID));
            menuMgr.add(this.getAction(REDO_ID));
        }
        if (this.isAllowFind()) {
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add(this.getAction(FIND_ID));
        }
        if (this.menuListeners != null) {
            Iterator itr = this.menuListeners.iterator();
            while (itr.hasNext()) {
                ((IMenuListener)itr.next()).menuAboutToShow(menuMgr);
            }
        }
    }

    public void removeMenuListener(IMenuListener listener) {
        if (this.menuListeners != null) {
            this.menuListeners.remove(listener);
        }
    }

    public void resetUndoRedoHistory() {
        if (this.hasUndoManager()) {
            this.getUndoManager().reset();
        }
    }

    public void setAllowCopy(boolean allowCopy) {
        this.allowCopy = allowCopy;
    }

    public void setAllowCut(boolean allowCut) {
        this.allowCut = allowCut;
    }

    public void setAllowFind(boolean allowFind) {
        this.allowFind = allowFind;
        if (this.findAction != null) {
            this.findAction.setAccelerator(this.allowFind && this.getTextWidget().isFocusControl() ? 262214 : 0);
        }
    }

    public void setAllowPaste(boolean allowPaste) {
        this.allowPaste = allowPaste;
    }

    public void setAllowSelectAll(boolean allowSelectAll) {
        this.allowSelectAll = allowSelectAll;
        if (this.selectAllAction != null) {
            this.selectAllAction.setAccelerator(this.allowSelectAll && this.getTextWidget().isFocusControl() ? 262209 : 0);
        }
    }

    public void setAllowUndoRedo(boolean allowUndoRedo) {
        boolean bl = this.allowUndoRedo = allowUndoRedo && this.hasUndoManager();
        if (!this.allowUndoRedo && this.hasUndoManager()) {
            this.resetUndoRedoHistory();
        }
        if (this.undoAction != null) {
            this.undoAction.setAccelerator(this.allowUndoRedo && this.getTextWidget().isFocusControl() ? 262234 : 0);
            this.redoAction.setAccelerator(this.allowUndoRedo && this.getTextWidget().isFocusControl() ? 262233 : 0);
        }
    }

    public void setBackground(Color color) {
        this.getTextWidget().setBackground(color);
    }

    public void setDoubleClickStrategy(ITextDoubleClickStrategy strategy) {
        this.viewer.setTextDoubleClickStrategy(strategy, "__dftl_partition_content_type");
    }

    public void setEditable(boolean editable) {
        this.getTextViewer().setEditable(editable);
    }

    public void setFocus() {
        this.getTextWidget().setFocus();
    }

    public void setLayoutData(Object layoutData) {
        this.getTextWidget().setLayoutData(layoutData);
    }

    public void setText(String text) {
        this.viewer.getDocument().set(text);
    }

    public void setUndoRedoHistoryLimit(int limit) {
        if (this.hasUndoManager()) {
            this.viewer.getUndoManager().setMaximalUndoLevel(limit);
        }
    }

    public void setAlwaysAllowPaste(boolean value) {
        this.alwaysAllowPaste = value;
    }

    protected boolean getAlwaysAllowPaste() {
        return this.alwaysAllowPaste;
    }

    private class ContextMenuAction
    extends Action {
        private final String id;

        public ContextMenuAction(String id) {
            this.id = id;
            IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Object tempAction = null;
            int accelerator = 0;
            if (this.id.equals(UNDO_ID)) {
                tempAction = ActionFactory.UNDO.create(window);
                accelerator = 262234;
            } else if (this.id.equals(REDO_ID)) {
                tempAction = ActionFactory.REDO.create(window);
                accelerator = 262233;
            } else if (this.id.equals(COPY_ID)) {
                tempAction = ActionFactory.COPY.create(window);
                accelerator = 262211;
            } else if (this.id.equals(CUT_ID)) {
                tempAction = ActionFactory.CUT.create(window);
                accelerator = 262232;
            } else if (this.id.equals(FIND_ID)) {
                tempAction = new Action(){};
                tempAction.setText(Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(StyledTextEditor.class)) + "findAction.label", new Object[0]));
                tempAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/elcl16/find_obj.gif"));
                tempAction.setDisabledImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/dlcl16/find_obj.gif"));
                accelerator = 262214;
            } else if (this.id.equals(PASTE_ID)) {
                tempAction = ActionFactory.PASTE.create(window);
                accelerator = 262230;
            } else if (this.id.equals(SELECT_ALL_ID)) {
                tempAction = ActionFactory.SELECT_ALL.create(window);
                accelerator = 262209;
            }
            if (tempAction != null) {
                this.setText(tempAction.getText());
                this.setImageDescriptor(tempAction.getImageDescriptor());
                this.setDisabledImageDescriptor(tempAction.getDisabledImageDescriptor());
            }
            this.setAccelerator(accelerator);
        }

        private void find() {
            assert (this.id.equals(FIND_ID));
            FindReplaceAction action = this.getFindAction();
            if (action != null) {
                action.update();
                action.run();
            }
        }

        private FindReplaceAction getFindAction() {
            IWorkbenchPart part;
            assert (this.id.equals(FIND_ID));
            IWorkbenchPage page = UiUtil.getWorkbenchPage();
            if (page != null && (part = page.getActivePart()) != null) {
                return new FindReplaceAction(ResourceBundle.getBundle(String.valueOf(UiConstants.PACKAGE_ID) + ".i18n"), "StyledTextEditor.findAction.", part);
            }
            return null;
        }

        private boolean isFindEnabled() {
            assert (this.id.equals(FIND_ID));
            FindReplaceAction action = this.getFindAction();
            if (action != null) {
                action.update();
                return action.isEnabled();
            }
            return false;
        }

        public void run() {
            if (this.id.equals(UNDO_ID) && StyledTextEditor.this.hasUndoManager()) {
                StyledTextEditor.this.getUndoManager().undo();
            } else if (this.id.equals(REDO_ID) && StyledTextEditor.this.hasUndoManager()) {
                StyledTextEditor.this.getUndoManager().redo();
            } else if (this.id.equals(COPY_ID)) {
                StyledTextEditor.this.getTextWidget().copy();
            } else if (this.id.equals(CUT_ID)) {
                StyledTextEditor.this.getTextWidget().cut();
            } else if (this.id.equals(FIND_ID)) {
                this.find();
            } else if (this.id.equals(PASTE_ID)) {
                if (StyledTextEditor.this.getAlwaysAllowPaste()) {
                    StyledTextEditor.this.getTextWidget().paste();
                }
            } else if (this.id.equals(SELECT_ALL_ID)) {
                StyledTextEditor.this.getTextWidget().selectAll();
            }
        }

        void setEnabledState() {
            boolean enable = false;
            StyledText styledText = StyledTextEditor.this.getTextWidget();
            if (this.id.equals(UNDO_ID)) {
                enable = styledText.getEditable() && StyledTextEditor.this.hasUndoManager() && StyledTextEditor.this.getUndoManager().undoable();
            } else if (this.id.equals(REDO_ID)) {
                enable = styledText.getEditable() && StyledTextEditor.this.hasUndoManager() && StyledTextEditor.this.getUndoManager().redoable();
            } else if (this.id.equals(COPY_ID)) {
                enable = styledText.getSelectionCount() != 0;
            } else if (this.id.equals(CUT_ID)) {
                enable = styledText.getEditable() && styledText.getSelectionCount() != 0;
            } else if (this.id.equals(PASTE_ID)) {
                enable = styledText.getEditable() && !SystemClipboardUtilities.isEmpty();
            } else if (this.id.equals(SELECT_ALL_ID)) {
                enable = styledText.getText().length() != 0;
            } else if (this.id.equals(FIND_ID)) {
                enable = this.isFindEnabled();
            }
            this.setEnabled(enable);
        }
    }
}

