/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.text.ScaledFontManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.Dialog;

public class TextAreaDialog
extends Dialog {
    private String content;
    private String headerText;
    private boolean editable;
    private int fontSize = 10;
    private boolean resizable = true;
    private int tabWidth = 4;
    private StyledText txtArea;
    private boolean wordWrap;

    public TextAreaDialog(Shell theShell, String theTitle, String theContent) {
        super(theShell, theTitle);
        this.content = theContent;
    }

    public TextAreaDialog(Shell theShell, String theTitle, String theContent, String theHeader) {
        this(theShell, theTitle, theContent);
        this.headerText = theHeader;
    }

    protected Control createDialogArea(Composite theParent) {
        Composite composite = (Composite)super.createDialogArea(theParent);
        if (this.headerText != null) {
            StyledText txtInstructions = new StyledText(composite, 74);
            txtInstructions.setText(this.headerText);
            txtInstructions.setBackground(UiUtil.getSystemColor(22));
            txtInstructions.setLayoutData((Object)new GridData(768));
        }
        int style = this.wordWrap ? 512 : 2816;
        this.txtArea = new StyledText(composite, style);
        this.txtArea.setLayoutData((Object)new GridData(1808));
        this.txtArea.setEditable(this.editable);
        this.txtArea.setWordWrap(this.wordWrap);
        this.txtArea.setTabs(this.tabWidth);
        this.txtArea.setText(this.content);
        this.txtArea.setFont(new ScaledFontManager().createFontOfSize(this.fontSize));
        StyleRange bodyRange = new StyleRange();
        bodyRange.start = 0;
        bodyRange.length = this.content.length();
        this.txtArea.setStyleRange(bodyRange);
        this.setSizeRelativeToScreen(75, 70);
        this.setCenterOnDisplay(true);
        return composite;
    }

    @Override
    public void create() {
        if (this.resizable) {
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
        super.create();
        super.getShell().setText(this.getTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setFocus();
    }

    public String getContent() {
        return this.txtArea.getText();
    }

    public void setEditable(boolean theEditableFlag) {
        this.editable = theEditableFlag;
    }

    public void setFontSize(int theSize) {
        this.fontSize = theSize;
    }

    public void setResizable(boolean theResizableFlag) {
        this.resizable = theResizableFlag;
    }

    public void setTabWidth(int theWidth) {
        this.tabWidth = theWidth;
    }

    public void setWordWrap(boolean theWordWrapFlag) {
        this.wordWrap = theWordWrapFlag;
    }
}

