/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.common.UiConstants;

public class FileUiUtils
implements UiConstants {
    public static FileUiUtils INSTANCE = new FileUiUtils();

    public String getExistingCaseVariantFileName(String theFullPathName) {
        String result = theFullPathName;
        if (result != null) {
            result = theFullPathName.trim();
        }
        CoreArgCheck.isTrue((!CoreStringUtil.isEmpty((String)result) ? 1 : 0) != 0, (String)"The full path name cannot be empty");
        File file = new File(result);
        if (file.exists()) {
            String name = file.getName();
            File parentDir = file.getParentFile();
            if (parentDir == null) {
                File tempFile = file.getAbsoluteFile();
                parentDir = tempFile.getParentFile();
            }
            if (parentDir != null) {
                File[] kids = parentDir.listFiles();
                int i = 0;
                while (i < kids.length) {
                    String existingName = kids[i].getName();
                    if (existingName.equalsIgnoreCase(name)) {
                        result = kids[i].getAbsolutePath();
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public String getExistingCaseVariantFileName(IPath path) {
        return this.getExistingCaseVariantFileName(path.toOSString());
    }
}

