/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class PreferenceKeyAndDefaultValue {
    private String key;
    private Object defaultValue;

    public static void storePreferenceDefault(IPreferenceStore preferenceStore, PreferenceKeyAndDefaultValue keyAndValue) {
        String key = keyAndValue.getKey();
        Object value = keyAndValue.getDefaultValue();
        if (value instanceof Boolean) {
            boolean bVal = (Boolean)value;
            preferenceStore.setDefault(key, bVal);
        } else if (value instanceof Double) {
            double dVal = (Double)value;
            preferenceStore.setDefault(key, dVal);
        } else if (value instanceof Float) {
            float fVal = ((Float)value).floatValue();
            preferenceStore.setDefault(key, fVal);
        } else if (value instanceof Integer) {
            int iVal = (Integer)value;
            preferenceStore.setDefault(key, iVal);
        } else if (value instanceof Long) {
            long lVal = (Long)value;
            preferenceStore.setDefault(key, lVal);
        } else if (value instanceof String) {
            String str = (String)value;
            preferenceStore.setDefault(key, str);
        } else if (value instanceof RGB) {
            RGB rgb = (RGB)value;
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)key, (RGB)rgb);
        } else if (value instanceof Point) {
            Point pt = (Point)value;
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)key, (Point)pt);
        } else if (value instanceof Rectangle) {
            Rectangle rec = (Rectangle)value;
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)key, (Rectangle)rec);
        } else if (value instanceof FontData) {
            FontData fd = (FontData)value;
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)key, (FontData)fd);
        } else if (value instanceof FontData[]) {
            FontData[] fd = (FontData[])value;
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)key, (FontData[])fd);
        }
    }

    public PreferenceKeyAndDefaultValue(String key, Object defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

