/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.tools.textimport.ui.wizards;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.UUID;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.tools.textimport.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.NewModelProjectWorker;

public abstract class AbstractObjectProcessor
implements UiConstants {
    private static final String XMI_EXTENSION = "xmi";
    private static final String I18N_PREFIX = "AbstractObjectProcessor";
    private static final String SEPARATOR = ".";
    private static final String ADD_VALUE_ERROR = "AbstractObjectProcessor.addValueError";
    private static final String GET_MODEL_CONTENTS_ERROR = "AbstractObjectProcessor.getModelContentsError";
    private static final String MODEL_OBJ_NOTFOUND_ERROR = "AbstractObjectProcessor.modelObjectNotFound";
    private static final String MANY_ROWS_TITLE = AbstractObjectProcessor.getString("manyRowsTitle");
    private static final String MANY_ROWS_MESSAGE_KEY = "manyRowsMessage";
    private static final String COULD_NOT_PARSE_KEY = "couldNotParse.message";
    public static final String FINISHED = AbstractObjectProcessor.getString("finished");
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;

    private static String getString(String id) {
        return Util.getString("AbstractObjectProcessor." + id, new Object[0]);
    }

    private static String getString(String id, Object obj) {
        return Util.getString("AbstractObjectProcessor." + id, obj);
    }

    private static String getString(String key, Object value, Object value2) {
        return Util.getString(key, new Object[]{value, value2});
    }

    public boolean confirmLargeImport(Shell shell, int nRows, int threshold) {
        if (nRows > threshold) {
            String iSize = Integer.toString(nRows);
            return MessageDialog.openQuestion((Shell)shell, (String)MANY_ROWS_TITLE, (String)AbstractObjectProcessor.getString(MANY_ROWS_MESSAGE_KEY, iSize));
        }
        return true;
    }

    public void logParsingError(String rowString) {
        Util.log(2, AbstractObjectProcessor.getString(COULD_NOT_PARSE_KEY, rowString));
    }

    public Collection loadLinesFromFile(String fileStr) {
        ArrayList<String> rows;
        block19: {
            rows = new ArrayList<String>();
            if (fileStr != null && fileStr.length() > 0) {
                InputStreamReader fr = null;
                BufferedReader in = null;
                rows = new ArrayList();
                try {
                    try {
                        String str;
                        fr = new FileReader(fileStr);
                        in = new BufferedReader(fr);
                        while ((str = in.readLine()) != null) {
                            if (str.length() <= 1) continue;
                            rows.add(str);
                        }
                    }
                    catch (Exception e) {
                        Util.log(4, (Throwable)e, AbstractObjectProcessor.getString("problemLoadingFileContentsMessage", fileStr));
                        try {
                            fr.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rows;
    }

    public void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            Util.log(4, (Throwable)err, AbstractObjectProcessor.getString(ADD_VALUE_ERROR, value, owner));
        }
    }

    public EList getModelResourceContents(ModelResource resource) {
        EList eList = null;
        try {
            eList = resource.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException e) {
            Util.log(4, (Throwable)e, AbstractObjectProcessor.getString(GET_MODEL_CONTENTS_ERROR, resource));
        }
        return eList;
    }

    protected EObject getEObject(String modelObjectIdentifier) {
        EObject result = null;
        if (modelObjectIdentifier != null) {
            if (AbstractObjectProcessor.isStringifiedUUID(modelObjectIdentifier)) {
                result = this.lookupEObject(modelObjectIdentifier);
            } else if (!this.isModelResourcePath(modelObjectIdentifier)) {
                Path fullObjectPath = new Path(modelObjectIdentifier);
                ModelResource mr = this.findModelResource((IPath)fullObjectPath);
                int modelSegIndex = this.getExistingModelPathIndex(modelObjectIdentifier);
                if (mr != null) {
                    IPath relativePath = null;
                    try {
                        relativePath = fullObjectPath.removeFirstSegments(modelSegIndex);
                        result = ModelerCore.getModelEditor().findObjectByPath(mr, relativePath);
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {
                        Util.log(2, AbstractObjectProcessor.getString(MODEL_OBJ_NOTFOUND_ERROR, modelObjectIdentifier));
                    }
                }
            }
        }
        return result;
    }

    protected int getExistingModelPathIndex(String pathStr) {
        int modelIndex = -1;
        ModelResource mr = null;
        Path path = new Path(pathStr);
        int nSegs = path.segmentCount();
        if (nSegs > 1) {
            String projSeg = path.segment(0);
            IProject existProj = ModelerCore.getWorkspace().getRoot().getProject(projSeg);
            if (!existProj.exists()) {
                return -1;
            }
            if (existProj.exists()) {
                if (!existProj.isOpen()) {
                    try {
                        existProj.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                int i = nSegs;
                while (i > 1) {
                    IPath workingPath = path.uptoSegment(i);
                    String osPathStr = workingPath.toOSString();
                    if (osPathStr != null && osPathStr.length() > 0) {
                        mr = this.getModelResource(osPathStr);
                    }
                    if (mr != null) {
                        modelIndex = i;
                        break;
                    }
                    --i;
                }
            }
        }
        return modelIndex;
    }

    private EObject lookupEObject(String uuidString) {
        EObject result = null;
        if (uuidString != null) {
            try {
                result = (EObject)ModelerCore.getModelContainer().getEObjectFinder().find((Object)uuidString);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    protected static boolean isStringifiedUUID(String str) {
        boolean result = false;
        String string = str;
        try {
            int index = string.indexOf("mmuuid:");
            if (index == -1 && (index = string.indexOf(String.valueOf("mmuuid".toUpperCase()) + ':')) != -1) {
                string = string.toLowerCase();
            }
            if (index != -1) {
                string = string.substring(index += "mmuuid:".length());
                UUID.stringToObject((String)string);
                result = true;
            } else {
                result = false;
            }
        }
        catch (InvalidIDException invalidIDException) {
            result = false;
        }
        return result;
    }

    protected boolean isModelResourcePath(String location) {
        Path objectPath = new Path(location);
        IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile((IPath)objectPath);
        IPath nextPath = null;
        if (modelFile != null && AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) && !(modelFile instanceof IFolder)) {
            nextPath = objectPath.addFileExtension(XMI_EXTENSION);
            modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
            ModelResource mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
            if (mr != null) {
                return true;
            }
        }
        return false;
    }

    protected ModelResource getModelResource(String location) {
        Path objectPath = new Path(location);
        IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile((IPath)objectPath);
        IPath nextPath = null;
        if (modelFile != null && AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) && !(modelFile instanceof IFolder)) {
            nextPath = objectPath.addFileExtension(XMI_EXTENSION);
            modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
            ModelResource mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
            if (mr != null) {
                return mr;
            }
        }
        return null;
    }

    protected ModelResource findModelResource(IPath objectPath) {
        ModelResource mr = null;
        int nSeg = objectPath.segmentCount();
        IPath nextPath = null;
        int i = 0;
        while (i < nSeg - 1 && mr == null) {
            try {
                nextPath = objectPath.removeLastSegments(i + 1);
                IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
                if (modelFile != null && AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) && !(modelFile instanceof IFolder)) {
                    nextPath = nextPath.addFileExtension(XMI_EXTENSION);
                    modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
                    mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String msg = AbstractObjectProcessor.getString("modelNotFound", objectPath);
                UiConstants.Util.log(2, msg);
            }
            ++i;
        }
        return mr;
    }

    private static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature((IProject)proj);
    }

    protected IProject createProject(IProject nonExistingProject, IProgressMonitor monitor) {
        NewModelProjectWorker worker = new NewModelProjectWorker();
        if (!nonExistingProject.exists()) {
            return worker.createNewProject(null, nonExistingProject.getName(), monitor);
        }
        UiConstants.Util.log((Object)AbstractObjectProcessor.getString("projectExists", nonExistingProject.getName()));
        return null;
    }
}

