/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.tools.textimport.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.tools.textimport.ui.UiConstants;
import org.teiid.designer.tools.textimport.ui.wizards.ITextImportMainPage;

public abstract class TextImportContributionManager {
    private static final String ID = "textImportContributor";
    private static final String CLASS = "class";
    private static final String CLASSNAME = "name";
    private static final String NO_DESCRIPTION = "No Description";
    private static final String NO_SAMPLE_DATA = "No Sample Data";
    private static final String TABS_1_KEY = "|1|";
    private static final String TABS_2_KEY = "|2|";
    private static final String TABS_3_KEY = "|3|";
    private static final String TABS_4_KEY = "|4|";
    private static final String TABS_1_STR = "\t ";
    private static final String TABS_2_STR = "          ";
    private static final String TABS_3_STR = "               ";
    private static final String TABS_4_STR = "                    ";
    private static IExtension[] contributions;
    private static String[] types;
    private static String[] descriptions;
    private static String[] sampleData;
    private static boolean importersLoaded;

    static {
        importersLoaded = false;
    }

    private static void loadHelperExtensions() {
        importersLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.tools.textimport.ui", ID);
        contributions = extensionPoint.getExtensions();
    }

    private static ITextImportMainPage[] createImporters() {
        boolean firstTime = false;
        if (!importersLoaded) {
            firstTime = true;
            TextImportContributionManager.loadHelperExtensions();
        }
        ArrayList<Object> importers = new ArrayList<Object>(contributions.length);
        int i = 0;
        while (i < contributions.length) {
            IConfigurationElement[] elements = contributions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object newPage;
                    if (elements[j].getName().equals(CLASS) && (newPage = elements[j].createExecutableExtension(CLASSNAME)) instanceof ITextImportMainPage) {
                        importers.add(newPage);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("TextImportContributionManager.loadHelperExtensionsErrorMessage", (Object)contributions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
        ITextImportMainPage[] pages = importers.toArray(new ITextImportMainPage[importers.size()]);
        if (firstTime) {
            types = new String[importers.size()];
            descriptions = new String[importers.size()];
            sampleData = new String[importers.size()];
            int k = 0;
            while (k < pages.length) {
                TextImportContributionManager.types[k] = pages[k].getType();
                TextImportContributionManager.descriptions[k] = TextImportContributionManager.parseDescription(pages[k].getDescriptionText());
                TextImportContributionManager.sampleData[k] = pages[k].getSampleDataText();
                ++k;
            }
        }
        return pages;
    }

    public static ITextImportMainPage[] getTextImporters() {
        return TextImportContributionManager.createImporters();
    }

    public static String getDescription(String type) {
        int k = 0;
        while (k < types.length) {
            if (types[k].equals(type)) {
                return descriptions[k];
            }
            ++k;
        }
        return NO_DESCRIPTION;
    }

    public static String getSampleData(String type) {
        int k = 0;
        while (k < types.length) {
            if (types[k].equals(type)) {
                return sampleData[k];
            }
            ++k;
        }
        return NO_SAMPLE_DATA;
    }

    public static String[] getTypes() {
        return types;
    }

    private static String parseDescription(String descString) {
        StringBuffer buff = new StringBuffer(descString);
        int iStart = 0;
        int iEnd = 0;
        while (buff.indexOf(TABS_1_KEY) > -1) {
            iStart = buff.indexOf(TABS_1_KEY);
            iEnd = iStart + 3;
            buff.replace(iStart, iEnd, TABS_1_STR);
        }
        while (buff.indexOf(TABS_2_KEY) > -1) {
            iStart = buff.indexOf(TABS_2_KEY);
            iEnd = iStart + 3;
            buff.replace(iStart, iEnd, TABS_2_STR);
        }
        while (buff.indexOf(TABS_3_KEY) > -1) {
            iStart = buff.indexOf(TABS_3_KEY);
            iEnd = iStart + 3;
            buff.replace(iStart, iEnd, TABS_3_STR);
        }
        while (buff.indexOf(TABS_4_KEY) > -1) {
            iStart = buff.indexOf(TABS_4_KEY);
            iEnd = iStart + 3;
            buff.replace(iStart, iEnd, TABS_4_STR);
        }
        return buff.toString();
    }
}

