/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.proc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.query.IProcedureService;
import org.teiid.designer.query.proc.ITeiidColumnInfo;
import org.teiid.designer.query.proc.ITeiidMetadataFileInfo;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.query.proc.ITeiidXmlFileInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlRequestInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlResponseInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlWrapperInfo;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.proc.wsdl.WsdlRequestProcedureHelper;
import org.teiid.query.proc.wsdl.WsdlResponseProcedureHelper;
import org.teiid.query.proc.wsdl.WsdlWrapperHelper;
import org.teiid.runtime.client.Messages;

public class ProcedureService
implements IProcedureService,
ISQLConstants {
    private final ITeiidServerVersion teiidVersion;
    private static final String JSON = "JSON";

    public ProcedureService(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    public String getSQLStatement(ITeiidMetadataFileInfo metadataFileInfo, String relationalModelName) {
        int firstDataRow;
        String escape;
        ArrayList<String> tokens = new ArrayList<String>();
        List columnInfoList = metadataFileInfo.getColumnInfoList();
        String alias = "A";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int nColumns = columnInfoList.size();
        for (ITeiidColumnInfo columnStr : columnInfoList) {
            sb.append(alias).append(".").append(columnStr.getSymbolName());
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        tokens.add(sb.toString());
        tokens.add(relationalModelName);
        sb = new StringBuffer();
        i = 0;
        for (ITeiidColumnInfo columnStr : columnInfoList) {
            sb.append(columnStr.getSymbolName()).append(" ").append(columnStr.getDatatype());
            if (metadataFileInfo.isFixedWidthColumns()) {
                sb.append(" ").append("width").append(" ").append(Integer.toString(columnStr.getWidth()));
            }
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        String proc = "'" + metadataFileInfo.getDataFile().getName() + "'";
        if (metadataFileInfo.isUrl()) {
            proc = "'GET', " + "NULL".toLowerCase() + "," + " " + "'" + metadataFileInfo.getFileUrl() + "'" + "," + " " + "'" + "TRUE" + "'";
        }
        tokens.add(proc);
        if (metadataFileInfo.isUrl()) {
            tokens.add(metadataFileInfo.getCharSet());
        }
        tokens.add(sb.toString());
        sb = new StringBuffer();
        String delimiter = metadataFileInfo.getDelimiter();
        if (metadataFileInfo.doUseDelimitedColumns() && !",".equals(delimiter)) {
            sb.append("DELIMITER");
            sb.append(" ").append('\'').append(delimiter).append('\'');
        }
        if (metadataFileInfo.doIncludeQuote()) {
            String quote = metadataFileInfo.getQuote();
            if (!"\"".equals(quote)) {
                sb.append("QUOTE");
                sb.append(" ").append('\'').append(quote).append('\'');
            }
        } else if (metadataFileInfo.doIncludeEscape() && !"\\".equals(escape = metadataFileInfo.getEscape())) {
            sb.append("ESCAPE");
            sb.append(" ").append('\'').append(escape).append('\'');
        }
        if (metadataFileInfo.doIncludeHeader()) {
            sb.append(" ").append("HEADER");
            if (metadataFileInfo.getHeaderLineNumber() > 1) {
                sb.append(" ").append(Integer.toString(metadataFileInfo.getHeaderLineNumber()));
            }
        }
        if ((firstDataRow = metadataFileInfo.getFirstDataRow()) > 1 && (metadataFileInfo.doIncludeSkip() || metadataFileInfo.isFixedWidthColumns())) {
            sb.append(" ").append("SKIP");
            sb.append(" ").append(Integer.toString(firstDataRow - 1));
        }
        if (metadataFileInfo.doIncludeNoTrim() && firstDataRow > 1) {
            sb.append(" ").append("NO TRIM");
        }
        tokens.add(sb.toString());
        tokens.add(alias);
        String finalSQLString = null;
        finalSQLString = metadataFileInfo.isUrl() ? Messages.getString(Messages.ProcedureService.procedureServiceTextInvokeHttpTableSqlTemplate, tokens.toArray(new Object[0])) : Messages.getString(Messages.ProcedureService.procedureServiceTextTableSqlTemplate, tokens.toArray(new Object[0]));
        return finalSQLString;
    }

    public String getSQLStatement(ITeiidXmlFileInfo xmlFileInfo, String relationalModelName) {
        ArrayList<String> tokens = new ArrayList<String>();
        List columnInfoList = xmlFileInfo.getColumnInfoList();
        String alias = "A";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int nColumns = columnInfoList.size();
        for (ITeiidXmlColumnInfo columnInfo : columnInfoList) {
            String name = columnInfo.getSymbolName();
            sb.append(alias).append(".").append(name).append(" ").append("AS").append(" ").append(name);
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        tokens.add(sb.toString());
        tokens.add(relationalModelName);
        String proc = "'" + xmlFileInfo.getDataFile().getName() + "'";
        if (xmlFileInfo.isUrl()) {
            proc = "'GET', " + "NULL".toLowerCase() + "," + " " + "'" + xmlFileInfo.getXmlFileUrl() + "'" + "," + " " + "'" + "TRUE" + "'";
        }
        tokens.add(proc);
        String namespaceStr = xmlFileInfo.getNamespaceString();
        sb = new StringBuffer();
        if (namespaceStr != null) {
            sb.append(namespaceStr);
        }
        String xQueryExp = "/";
        String rootPath = xmlFileInfo.getRootPath();
        if (rootPath != null && rootPath.length() > 0) {
            xQueryExp = rootPath;
        }
        sb.append("'").append(xQueryExp).append("'");
        tokens.add(sb.toString());
        sb = new StringBuffer();
        i = 0;
        for (ITeiidXmlColumnInfo columnInfo : columnInfoList) {
            if (columnInfo.getOrdinality()) {
                sb.append(columnInfo.getSymbolName()).append(" ").append("FOR ORDINALITY");
            } else {
                String relPath;
                sb.append(columnInfo.getSymbolName()).append(" ").append(columnInfo.getDatatype());
                String defValue = columnInfo.getDefaultValue();
                if (defValue != null && defValue.length() > 0) {
                    sb.append(" ").append("DEFAULT").append(" ").append("'").append(defValue).append("'");
                }
                if ((relPath = columnInfo.getRelativePath()) != null && relPath.length() > 1) {
                    sb.append(" ").append("PATH").append(" ").append("'").append(relPath).append("'");
                }
            }
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        tokens.add(sb.toString());
        tokens.add(alias);
        String finalSQLString = null;
        finalSQLString = xmlFileInfo.isUrl() ? Messages.getString(Messages.ProcedureService.procedureServiceXmlInvokeHttpTableSqlTemplate, tokens.toArray(new Object[0])) : Messages.getString(Messages.ProcedureService.procedureServiceXmlGetTextFilesTableSqlTemplate, tokens.toArray(new Object[0]));
        return finalSQLString;
    }

    public String getSQLStatement(ITeiidXmlFileInfo xmlFileInfo, String relationalSourceModelName, String relationalViewModelName, String virtualProcedureName) {
        ArrayList<String> tokens = new ArrayList<String>();
        List columnInfoList = xmlFileInfo.getColumnInfoList();
        boolean isJson = false;
        if (xmlFileInfo.getResponseType() != null && xmlFileInfo.getResponseType().toUpperCase().equals(JSON)) {
            isJson = true;
        }
        Map parameters = xmlFileInfo.getParameterMap();
        boolean isQueryParm = false;
        StringBuffer sb = new StringBuffer();
        int c = 1;
        if (parameters.isEmpty()) {
            sb.append("''");
        }
        for (Parameter param : parameters.values()) {
            if (param.getType().equals((Object)Parameter.Type.Query)) {
                isQueryParm = true;
                if (c == 1) {
                    tokens.add(xmlFileInfo.getXmlFileUrl());
                }
                sb.append(relationalViewModelName).append(".").append(virtualProcedureName).append(".").append(param.getName()).append(" ").append("AS").append(" ").append(param.getName());
                if (c < parameters.size()) {
                    sb.append(",").append(" ");
                }
            } else {
                if (c == 1) {
                    String url = xmlFileInfo.getXmlFileUrl();
                    if (url.endsWith("/")) {
                        url = url.substring(0, url.lastIndexOf("/"));
                    }
                    sb.append("'");
                    sb.append(url);
                    sb.append("'");
                }
                sb.append(" || '/' || ");
                sb.append(relationalViewModelName).append(".").append(virtualProcedureName).append(".").append(param.getName());
            }
            ++c;
        }
        tokens.add(sb.toString());
        sb = new StringBuffer();
        String alias = "A";
        int i = 0;
        int nColumns = columnInfoList.size();
        for (ITeiidXmlColumnInfo columnInfo : columnInfoList) {
            String name = columnInfo.getSymbolName();
            sb.append(alias).append(".").append(name).append(" ").append("AS").append(" ").append(name);
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        tokens.add(sb.toString());
        tokens.add(relationalSourceModelName);
        String proc = "'" + xmlFileInfo.getDataFile().getName() + "'";
        if (xmlFileInfo.isUrl()) {
            proc = "'GET', " + "NULL".toLowerCase() + "," + " " + "VARIABLES.qp" + "," + " " + "'" + "TRUE" + "'";
        }
        tokens.add(proc);
        String namespaceStr = xmlFileInfo.getNamespaceString();
        sb = new StringBuffer();
        if (namespaceStr != null) {
            sb.append(namespaceStr);
        }
        String xQueryExp = "/";
        String rootPath = xmlFileInfo.getRootPath();
        if (rootPath != null && rootPath.length() > 0) {
            xQueryExp = rootPath;
        }
        sb.append(xQueryExp).append("'");
        tokens.add(sb.toString());
        sb = new StringBuffer();
        i = 0;
        for (ITeiidXmlColumnInfo columnInfo : columnInfoList) {
            if (columnInfo.getOrdinality()) {
                sb.append(columnInfo.getSymbolName()).append(" ").append("FOR ORDINALITY");
            } else {
                String relPath;
                sb.append(columnInfo.getSymbolName()).append(" ").append(columnInfo.getDatatype());
                String defValue = columnInfo.getDefaultValue();
                if (defValue != null && defValue.length() > 0) {
                    sb.append(" ").append("DEFAULT").append(" ").append("'").append(defValue).append("'");
                }
                if ((relPath = columnInfo.getRelativePath()) != null && relPath.length() > 1) {
                    sb.append(" ").append("PATH").append(" ").append("'").append(relPath).append("'");
                }
            }
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
        }
        tokens.add(sb.toString());
        tokens.add(alias);
        String finalSQLString = null;
        finalSQLString = isJson ? (isQueryParm ? Messages.getString(Messages.ProcedureService.procedureServiceXmlInvokeHttpWithQueryParametersJSONTableSqlTemplate, tokens.toArray(new Object[0])) : Messages.getString(Messages.ProcedureService.procedureServiceXmlInvokeHttpWithURIParametersJSONTableSqlTemplate, tokens.toArray(new Object[0]))) : (isQueryParm ? Messages.getString(Messages.ProcedureService.procedureServiceXmlInvokeHttpWithQueryParametersTableSqlTemplate, tokens.toArray(new Object[0])) : Messages.getString(Messages.ProcedureService.procedureServiceXmlInvokeHttpWithURIParametersTableSqlTemplate, tokens.toArray(new Object[0])));
        return finalSQLString;
    }

    public String getSQLStatement(IWsdlWrapperInfo wrapperInfo) {
        WsdlWrapperHelper helper = new WsdlWrapperHelper(this.teiidVersion, wrapperInfo);
        return helper.getWrapperStatement();
    }

    public String getSQLStatement(IWsdlWrapperInfo wrapperInfo, Properties properties) {
        WsdlWrapperHelper helper = new WsdlWrapperHelper(this.teiidVersion, wrapperInfo);
        return helper.getWrapperProcedureStatement(properties);
    }

    public String getSQLStatement(IWsdlRequestInfo requestInfo, Properties properties) {
        WsdlRequestProcedureHelper helper = new WsdlRequestProcedureHelper(this.teiidVersion, requestInfo, properties);
        return helper.getSQLStatement();
    }

    public String getSQLStatement(IWsdlResponseInfo responseInfo, Properties properties) {
        WsdlResponseProcedureHelper helper = new WsdlResponseProcedureHelper(this.teiidVersion, responseInfo, properties);
        return helper.getSQLStatement();
    }
}

