/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin.v7;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.ServerConnectionFactory;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.runtime.client.Messages;

public class Admin7Factory {
    public static final String DEFAULT_APPLICATION_NAME = "Admin";
    private static Admin7Factory instance = new Admin7Factory(SocketServerConnectionFactory.getInstance());
    private ServerConnectionFactory serverConnectionFactory;

    Admin7Factory(ServerConnectionFactory connFactory) {
        this.serverConnectionFactory = connFactory;
    }

    public static Admin7Factory getInstance() {
        return instance;
    }

    public Admin createAdmin(String userName, char[] password, String serverURL) throws AdminException {
        return this.createAdmin(userName, password, serverURL, DEFAULT_APPLICATION_NAME);
    }

    public Admin createAdmin(String userName, char[] password, String serverURL, String applicationName) throws AdminException {
        if (userName == null || userName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.getString(Messages.ExecutionAdmin.invalid_parameter, new Object[0]));
        }
        Properties p = new Properties();
        p.setProperty("ApplicationName", applicationName);
        p.setProperty("user", userName);
        if (password != null) {
            p.setProperty("password", new String(password));
        }
        p.setProperty("serverURL", serverURL);
        return this.createAdmin(p);
    }

    public Admin createAdmin(Properties p) throws AdminException {
        p = PropertiesUtils.clone(p);
        p.remove("VirtualDatabaseName");
        p.remove("VirtualDatabaseVersion");
        p.setProperty("admin", Boolean.TRUE.toString());
        try {
            Admin serverAdmin = (Admin)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Admin.class}, (InvocationHandler)new AdminProxy(p));
            return serverAdmin;
        }
        catch (ConnectionException e) {
            throw new AdminComponentException(e);
        }
        catch (CommunicationException e) {
            throw new AdminComponentException(e);
        }
    }

    private final class AdminProxy
    implements InvocationHandler {
        private Admin admin;
        private ServerConnection serverConnection;
        private boolean closed;

        public AdminProxy(Properties p) throws ConnectionException, CommunicationException {
            this.serverConnection = Admin7Factory.this.serverConnectionFactory.getConnection(p);
            this.admin = this.serverConnection.getService(Admin.class);
        }

        private synchronized Admin getTarget() throws AdminComponentException {
            if (this.closed) {
                throw new AdminComponentException(Messages.getString(Messages.ExecutionAdmin.admin_conn_closed, new Object[0]));
            }
            return this.admin;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                this.close();
                return null;
            }
            if (!method.getDeclaringClass().equals(Admin.class)) {
                return method.invoke((Object)this, args);
            }
            try {
                return method.invoke((Object)this.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.serverConnection != null) {
                this.serverConnection.close();
            }
        }
    }
}

