/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.io.InputStream;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.runtime.client.admin.v7.Admin7Spec;
import org.teiid.runtime.client.admin.v8.Admin8Spec;

public abstract class AdminSpec {
    private final ITeiidServerVersion teiidVersion;

    public AdminSpec(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    protected ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public static AdminSpec getInstance(ITeiidServerVersion teiidVersion) {
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            return new Admin7Spec(teiidVersion);
        }
        return new Admin8Spec(teiidVersion);
    }

    public abstract Admin createAdmin(ITeiidServer var1) throws AdminException;

    public abstract String getTestVDB();

    public abstract VDB.Status getLoadingVDBStatus();

    public abstract void deploy(Admin var1, String var2, InputStream var3) throws AdminException;

    public abstract void undeploy(Admin var1, String var2, int var3) throws AdminException;
}

