/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol.v7;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.v7.Teiid7Parser;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;

public class Aggregate7Symbol
extends ExpressionSymbol
implements AggregateSymbol {
    private boolean distinct;
    private OrderBy orderBy;
    private Expression condition;
    private IAggregateSymbol.Type aggregate;
    private boolean isWindowed;
    private static final Class<?> COUNT_TYPE = DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
    private static final Map<Class<?>, Class<?>> SUM_TYPES;
    private static final Map<Class<?>, Class<?>> AVG_TYPES;

    static {
        Class<?> byteClass = DataTypeManagerService.DefaultDataTypes.BYTE.getTypeClass();
        Class<?> longClass = DataTypeManagerService.DefaultDataTypes.LONG.getTypeClass();
        Class<?> shortClass = DataTypeManagerService.DefaultDataTypes.SHORT.getTypeClass();
        Class<?> integerClass = DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
        Class<?> doubleClass = DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass();
        Class<?> bigDecimalClass = DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getTypeClass();
        Class<?> bigIntegerClass = DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getTypeClass();
        Class<?> floatClass = DataTypeManagerService.DefaultDataTypes.FLOAT.getTypeClass();
        SUM_TYPES = new HashMap();
        SUM_TYPES.put(byteClass, longClass);
        SUM_TYPES.put(shortClass, longClass);
        SUM_TYPES.put(integerClass, longClass);
        SUM_TYPES.put(longClass, longClass);
        SUM_TYPES.put(bigIntegerClass, bigIntegerClass);
        SUM_TYPES.put(floatClass, doubleClass);
        SUM_TYPES.put(doubleClass, doubleClass);
        SUM_TYPES.put(bigDecimalClass, bigDecimalClass);
        AVG_TYPES = new HashMap();
        AVG_TYPES.put(byteClass, doubleClass);
        AVG_TYPES.put(shortClass, doubleClass);
        AVG_TYPES.put(integerClass, doubleClass);
        AVG_TYPES.put(longClass, doubleClass);
        AVG_TYPES.put(bigIntegerClass, bigDecimalClass);
        AVG_TYPES.put(floatClass, doubleClass);
        AVG_TYPES.put(doubleClass, doubleClass);
        AVG_TYPES.put(bigDecimalClass, bigDecimalClass);
    }

    public Aggregate7Symbol(Teiid7Parser p, int id) {
        super(p, id);
    }

    private boolean isAnalytical() {
        switch (this.aggregate) {
            case RANK: 
            case DENSE_RANK: 
            case ROW_NUMBER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBoolean() {
        return this.aggregate == IAggregateSymbol.Type.EVERY || this.aggregate == IAggregateSymbol.Type.SOME || this.aggregate == IAggregateSymbol.Type.ANY;
    }

    @Override
    public boolean isEnhancedNumeric() {
        return this.aggregate == IAggregateSymbol.Type.STDDEV_POP || this.aggregate == IAggregateSymbol.Type.STDDEV_SAMP || this.aggregate == IAggregateSymbol.Type.VAR_SAMP || this.aggregate == IAggregateSymbol.Type.VAR_POP;
    }

    @Override
    public Class<?> getType() {
        switch (this.aggregate) {
            case COUNT: {
                return COUNT_TYPE;
            }
            case SUM: {
                Class<?> expressionType = this.getExpression().getType();
                return SUM_TYPES.get(expressionType);
            }
            case AVG: {
                Class<?> expressionType = this.getExpression().getType();
                return AVG_TYPES.get(expressionType);
            }
            case ARRAY_AGG: {
                return DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass();
            }
            case TEXTAGG: {
                return DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
            }
        }
        if (this.isBoolean()) {
            return DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass();
        }
        if (this.isEnhancedNumeric()) {
            return DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass();
        }
        if (this.isAnalytical()) {
            return DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
        }
        return this.getExpression().getType();
    }

    @Override
    public void setAggregateFunction(String aggregateFunction) {
        this.setAggregateFunction(IAggregateSymbol.Type.valueOf((String)aggregateFunction));
    }

    @Override
    public void setAggregateFunction(IAggregateSymbol.Type aggregateFunction) {
        this.aggregate = aggregateFunction;
    }

    @Override
    public IAggregateSymbol.Type getAggregateFunction() {
        return this.aggregate;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public boolean isWindowed() {
        return this.isWindowed;
    }

    @Override
    public void setWindowed(boolean isWindowed) {
        this.isWindowed = isWindowed;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.aggregate == null ? 0 : this.aggregate.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.distinct ? 1231 : 1237);
        result = 31 * result + (this.isWindowed ? 1231 : 1237);
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aggregate7Symbol other = (Aggregate7Symbol)obj;
        if (this.aggregate != other.aggregate) {
            return false;
        }
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.distinct != other.distinct) {
            return false;
        }
        if (this.isWindowed != other.isWindowed) {
            return false;
        }
        return !(this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy));
    }

    @Override
    public String getCanonicalName() {
        return this.getShortCanonicalName();
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.setShortCanonicalName(canonicalName);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Aggregate7Symbol clone() {
        Aggregate7Symbol clone = new Aggregate7Symbol((Teiid7Parser)this.parser, this.id);
        if (this.getAggregateFunction() != null) {
            clone.setAggregateFunction(this.getAggregateFunction());
        }
        if (this.getAggregateFunction() != null) {
            clone.setAggregateFunction(this.getAggregateFunction());
        }
        clone.setDistinct(this.isDistinct());
        if (this.getOrderBy() != null) {
            clone.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getCondition() != null) {
            clone.setCondition(this.getCondition().clone());
        }
        clone.setWindowed(this.isWindowed());
        if (this.getCanonicalName() != null) {
            clone.setCanonicalName(this.getCanonicalName());
        }
        if (this.getExpression() != null) {
            clone.setExpression(this.getExpression().clone());
        }
        if (this.getShortCanonicalName() != null) {
            clone.setShortCanonicalName(this.getShortCanonicalName());
        }
        if (this.getOutputName() != null) {
            clone.setOutputName(this.getOutputName());
        }
        if (this.getShortName() != null) {
            clone.setShortName(this.getShortName());
        }
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        return clone;
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public Expression[] getArgs() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public Expression getArg(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setArgs(Expression[] arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setType(Class<?> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public FunctionDescriptor getFunctionDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setFunctionDescriptor(FunctionDescriptor functionDescriptor) {
        throw new UnsupportedOperationException();
    }
}

