/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Symbol;

public class Select
extends SimpleNode
implements ISelect<Expression, LanguageVisitor> {
    private List<Expression> symbols = new ArrayList<Expression>();
    private boolean distinct;

    public Select(TeiidParser p, int id) {
        super(p, id);
    }

    public List<Expression> getSymbols() {
        return this.symbols;
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public void addSymbol(Expression symbol) {
        if (!(symbol instanceof Symbol) && !(symbol instanceof MultipleElementSymbol)) {
            ExpressionSymbol exSymbol = (ExpressionSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.EXPRESSION_SYMBOL);
            exSymbol.setName("expr" + (this.symbols.size() + 1));
            exSymbol.setExpression(symbol);
            symbol = exSymbol;
        }
        this.symbols.add(symbol);
    }

    public void setSymbols(List<? extends Expression> symbols) {
        this.symbols = new ArrayList<Expression>(symbols);
    }

    public Expression getSymbol(int index) {
        return this.symbols.get(index);
    }

    public boolean containsSymbol(Expression symbol) {
        return this.symbols.contains(symbol);
    }

    public void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getProjectedSymbols() {
        ArrayList<Expression> projectedSymbols = new ArrayList<Expression>();
        for (Expression symbol : this.symbols) {
            if (symbol instanceof MultipleElementSymbol) {
                List<ElementSymbol> multiSymbols = ((MultipleElementSymbol)symbol).getElementSymbols();
                if (multiSymbols == null) continue;
                projectedSymbols.addAll(multiSymbols);
                continue;
            }
            projectedSymbols.add(symbol);
        }
        return projectedSymbols;
    }

    public boolean isStar() {
        return this.symbols.size() == 1 && this.symbols.get(0) instanceof MultipleElementSymbol && ((MultipleElementSymbol)this.symbols.get(0)).getGroup() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.distinct ? 1231 : 1237);
        result = 31 * result + (this.symbols == null ? 0 : this.symbols.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Select other = (Select)obj;
        if (this.distinct != other.distinct) {
            return false;
        }
        return !(this.symbols == null ? other.symbols != null : !this.symbols.equals(other.symbols));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Select clone() {
        Select clone = new Select(this.parser, this.id);
        clone.setDistinct(this.isDistinct());
        if (this.getSymbols() != null) {
            clone.setSymbols(this.cloneList(this.getSymbols()));
        }
        return clone;
    }
}

