/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.designer.query.sql.lang.IOrderByItem;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.language.SortSpecification;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Symbol;

public class OrderByItem
extends SimpleNode
implements SortSpecification,
IOrderByItem<Expression, LanguageVisitor> {
    private boolean ascending = true;
    private Expression symbol;
    private SortSpecification.NullOrdering nullOrdering;
    private Integer expressionPosition;

    public OrderByItem(TeiidParser p, int id) {
        super(p, id);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public Expression getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Expression symbol) {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_6) && symbol != null && !(symbol instanceof Symbol) && !(symbol instanceof Constant)) {
            ExpressionSymbol ex = (ExpressionSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.EXPRESSION_SYMBOL);
            ex.setName("expr");
            ex.setExpression(symbol);
            symbol = ex;
        }
        this.symbol = symbol;
    }

    public SortSpecification.NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SortSpecification.NullOrdering nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    public int getExpressionPosition() {
        return this.expressionPosition == null ? -1 : this.expressionPosition;
    }

    public void setExpressionPosition(int expressionPosition) {
        this.expressionPosition = expressionPosition;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ascending ? 1231 : 1237);
        result = 31 * result + (this.nullOrdering == null ? 0 : this.nullOrdering.hashCode());
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderByItem other = (OrderByItem)obj;
        if (this.ascending != other.ascending) {
            return false;
        }
        if (this.nullOrdering != other.nullOrdering) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderByItem clone() {
        OrderByItem clone = new OrderByItem(this.parser, this.id);
        if (this.getSymbol() != null) {
            clone.setSymbol(this.getSymbol().clone());
        }
        if (this.getNullOrdering() != null) {
            clone.setNullOrdering(this.getNullOrdering());
        }
        clone.setAscending(this.isAscending());
        return clone;
    }
}

