/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.GroupSymbol;

public class From
extends SimpleNode
implements IFrom<FromClause, GroupSymbol, LanguageVisitor> {
    private List<FromClause> clauses;

    public From(TeiidParser p, int id) {
        super(p, id);
    }

    public List<FromClause> getClauses() {
        return this.clauses;
    }

    public void setClauses(List<? extends FromClause> clauses) {
        if (clauses == null) {
            this.clauses = null;
            return;
        }
        this.clauses = new ArrayList<FromClause>(clauses);
    }

    public void addClause(FromClause clause) {
        if (this.clauses == null) {
            this.clauses = new ArrayList<FromClause>();
        }
        this.clauses.add(clause);
    }

    public void addGroup(GroupSymbol group) {
        if (group == null) {
            return;
        }
        UnaryFromClause unaryFromClause = (UnaryFromClause)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.UNARY_FROM_CLAUSE);
        unaryFromClause.setGroup(group);
        this.addClause(unaryFromClause);
    }

    public List<GroupSymbol> getGroups() {
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>();
        if (this.clauses != null) {
            int i = 0;
            while (i < this.clauses.size()) {
                FromClause clause = this.clauses.get(i);
                clause.collectGroups(groups);
                ++i;
            }
        }
        return groups;
    }

    public boolean containsGroup(GroupSymbol group) {
        return this.getGroups().contains(group);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.clauses == null ? 0 : this.clauses.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        From other = (From)obj;
        return !(this.clauses == null ? other.clauses != null : !this.clauses.equals(other.clauses));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public From clone() {
        From clone = new From(this.parser, this.id);
        if (this.getClauses() != null) {
            clone.setClauses(this.cloneList(this.getClauses()));
        }
        return clone;
    }
}

