/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.teiid.core.util.ArgCheck;
import org.teiid.query.report.ReportItem;

public class ActivityReport<R extends ReportItem>
implements Serializable {
    private String reportType;
    private Collection<R> items = new ArrayList<R>();

    public ActivityReport(String reportType) {
        this.reportType = reportType;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void addItem(R item) {
        ArgCheck.isNotNull(item);
        this.items.add(item);
    }

    public void addItems(Collection<R> items) {
        ArgCheck.isNotNull(items);
        for (ReportItem r : items) {
            this.addItem(r);
        }
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public Collection<R> getItems() {
        return this.items;
    }

    public String toString() {
        return String.valueOf(this.reportType) + " " + this.getItems();
    }
}

