/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.ParsedDataType;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public abstract class AbstractTeiidParser
implements TeiidParser {
    protected Pattern udtPattern = Pattern.compile("(\\w+)\\s*\\(\\s*(\\d+),\\s*(\\d+),\\s*(\\d+)\\)");
    protected Pattern SOURCE_HINT = Pattern.compile("\\s*sh(\\s+KEEP ALIASES)?\\s*(?::((?:'[^']*')+))?\\s*", 34);
    protected Pattern SOURCE_HINT_ARG = Pattern.compile("\\s*([^: ]+)(\\s+KEEP ALIASES)?\\s*:((?:'[^']*')+)", 34);
    protected ITeiidServerVersion version;
    private MetadataFactory metadataFactory;

    @Override
    public ITeiidServerVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(ITeiidServerVersion teiidVersion) {
        this.version = teiidVersion;
    }

    protected boolean versionLessThan(TeiidServerVersion.Version requiredVersionEnum) {
        return this.getVersion().isLessThan(requiredVersionEnum.get());
    }

    protected boolean versionAtLeast(TeiidServerVersion.Version requiredVersionEnum) {
        return !this.versionLessThan(requiredVersionEnum);
    }

    @Override
    public DataTypeManagerService getDataTypeService() {
        return DataTypeManagerService.getInstance(this.getVersion());
    }

    @Override
    public <T extends LanguageObject> T createASTNode(TeiidNodeFactory.ASTNodes nodeType) {
        return TeiidNodeFactory.getInstance().create((TeiidParser)this, nodeType);
    }

    protected String prependSign(String sign, String literal) {
        if (sign != null && sign.charAt(0) == '-') {
            return String.valueOf(sign) + literal;
        }
        return literal;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void convertToParameters(List<Expression> values, StoredProcedure storedProcedure, int paramIndex) {
        for (Expression value : values) {
            SPParameter parameter = new SPParameter(this, paramIndex++, value);
            parameter.setParameterType(SPParameter.IN);
            storedProcedure.setParameter(parameter);
        }
    }

    private int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        int j = 0;
        while (j < possibleDigits) {
            char digit;
            int val;
            if (i + 1 == string.length() || (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) == -1) break;
            ++i;
            value = (value << radixExp) + val;
            ++j;
        }
        sb.append((char)value);
        return i;
    }

    private String unescape(CharSequence string, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        i = this.parseNumericValue(string, sb, i, 0, 4, 4);
                        break;
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append(quoteChar);
                            break;
                        }
                        if (!useAsciiEscapes) break;
                        int value = Character.digit(c, 8);
                        if (value == -1) {
                            sb.append(c);
                            break;
                        }
                        int possibleDigits = value < 3 ? 2 : 1;
                        int radixExp = 3;
                        i = this.parseNumericValue(string, sb, i, value, possibleDigits, radixExp);
                    }
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else {
                if (c == quoteChar) break;
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String unescape(String string) {
        return this.unescape(string, -1, true, new StringBuilder());
    }

    private String removeEscapeChars(String str, String tickChar) {
        return StringUtil.replaceAll(str, String.valueOf(tickChar) + tickChar, tickChar);
    }

    protected String normalizeStringLiteral(String s) {
        int start = 1;
        boolean unescape = false;
        if (s.charAt(0) == 'N') {
            ++start;
        } else if (s.charAt(0) == 'E') {
            ++start;
            unescape = true;
        }
        char tickChar = s.charAt(start - 1);
        s = s.substring(start, s.length() - 1);
        String result = this.removeEscapeChars(s, String.valueOf(tickChar));
        if (unescape) {
            result = this.unescape(result);
        }
        return result;
    }

    protected String normalizeId(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        LinkedList<String> nameParts = new LinkedList<String>();
        block0: while (s.length() > 0) {
            if (s.charAt(0) == '\"') {
                boolean escape = false;
                int i = 1;
                while (i < s.length()) {
                    if (s.charAt(i) == '\"') {
                        boolean end;
                        escape = !escape;
                        boolean bl = end = i == s.length() - 1;
                        if (end || escape && s.charAt(i + 1) == '.') {
                            String part = s.substring(1, i);
                            s = s.substring(i + (end ? 1 : 2));
                            nameParts.add(this.removeEscapeChars(part, "\""));
                            continue block0;
                        }
                    }
                    ++i;
                }
                continue;
            }
            int index = s.indexOf(46);
            if (index == -1) {
                nameParts.add(s);
                break;
            }
            nameParts.add(s.substring(0, index));
            s = s.substring(index + 1);
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = nameParts.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    protected boolean isStringLiteral(String str, ParseInfo info) {
        if (info.useAnsiQuotedIdentifiers() || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            return false;
        }
        int index = 1;
        while (index < str.length() - 1) {
            if ((index = str.indexOf(34, index)) == -1 || index + 1 == str.length()) {
                return true;
            }
            if (str.charAt(index + 1) != '\"') {
                return false;
            }
            index += 2;
        }
        return true;
    }

    protected String validateName(String id, boolean element) throws Exception {
        if (id.indexOf(46) != -1) {
            Messages.TeiidParser key = Messages.TeiidParser.Invalid_alias;
            if (element) {
                key = Messages.TeiidParser.Invalid_short_name;
            }
            throw new TeiidClientException(Messages.getString(key, id));
        }
        return id;
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    protected String matchesAny(String arg, String ... expected) {
        String[] stringArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equalsIgnoreCase(arg)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Command procedureBodyCommand(ParseInfo parseInfo) throws Exception {
        throw new UnsupportedOperationException("Not supported in Teiid Version " + this.getVersion());
    }

    @Override
    public void parseMetadata(MetadataFactory factory) throws Exception {
        throw new UnsupportedOperationException("Not supported in Teiid Version " + this.getVersion());
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setColumnOptions(BaseColumn c) {
        Map<String, String> props = c.getProperties();
        this.setCommonProperties(c, props);
        String v = props.remove("RADIX");
        if (v != null) {
            c.setRadix(Integer.parseInt(v));
        }
        if (c instanceof Column) {
            this.setColumnOptions((Column)c, props);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeColumnOption(String key, BaseColumn c) {
        if (c.getProperty(key, false) != null) {
            c.setProperty(key, null);
        }
        this.removeCommonProperty(key, c);
        if (key.equals("RADIX")) {
            c.setRadix(0);
        }
        if (c instanceof Column) {
            this.removeColumnOption(key, (Column)c);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeColumnOption(String key, Column c) {
        if (key.equals("CASE_SENSITIVE")) {
            c.setCaseSensitive(false);
        }
        if (key.equals("SELECTABLE")) {
            c.setSelectable(true);
        }
        if (key.equals("UPDATABLE")) {
            c.setUpdatable(false);
        }
        if (key.equals("SIGNED")) {
            c.setSigned(false);
        }
        if (key.equals("CURRENCY")) {
            c.setSigned(false);
        }
        if (key.equals("FIXED_LENGTH")) {
            c.setFixedLength(false);
        }
        if (key.equals("SEARCHABLE")) {
            c.setSearchType(null);
        }
        if (key.equals("MIN_VALUE")) {
            c.setMinimumValue(null);
        }
        if (key.equals("MAX_VALUE")) {
            c.setMaximumValue(null);
        }
        if (key.equals("CHAR_OCTET_LENGTH")) {
            c.setCharOctetLength(0);
        }
        if (key.equals("NATIVE_TYPE")) {
            c.setNativeType(null);
        }
        if (key.equals("NULL_VALUE_COUNT")) {
            c.setNullValues(-1);
        }
        if (key.equals("DISTINCT_VALUES")) {
            c.setDistinctValues(-1);
        }
        if (key.equals("UDT")) {
            c.setDatatype(null);
            c.setLength(0);
            c.setPrecision(0);
            c.setScale(0);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private void setColumnOptions(Column c, Map<String, String> props) {
        String v = props.remove("CASE_SENSITIVE");
        if (v != null) {
            c.setCaseSensitive(this.isTrue(v));
        }
        if ((v = props.remove("SELECTABLE")) != null) {
            c.setSelectable(this.isTrue(v));
        }
        if ((v = props.remove("UPDATABLE")) != null) {
            c.setUpdatable(this.isTrue(v));
        }
        if ((v = props.remove("SIGNED")) != null) {
            c.setSigned(this.isTrue(v));
        }
        if ((v = props.remove("CURRENCY")) != null) {
            c.setSigned(this.isTrue(v));
        }
        if ((v = props.remove("FIXED_LENGTH")) != null) {
            c.setFixedLength(this.isTrue(v));
        }
        if ((v = props.remove("SEARCHABLE")) != null) {
            c.setSearchType(StringUtil.caseInsensitiveValueOf(Column.SearchType.class, v));
        }
        if ((v = props.remove("MIN_VALUE")) != null) {
            c.setMinimumValue(v);
        }
        if ((v = props.remove("MAX_VALUE")) != null) {
            c.setMaximumValue(v);
        }
        if ((v = props.remove("CHAR_OCTET_LENGTH")) != null) {
            c.setCharOctetLength(Integer.parseInt(v));
        }
        if ((v = props.remove("NATIVE_TYPE")) != null) {
            c.setNativeType(v);
        }
        if ((v = props.remove("NULL_VALUE_COUNT")) != null) {
            c.setNullValues(Integer.parseInt(v));
        }
        if ((v = props.remove("DISTINCT_VALUES")) != null) {
            c.setDistinctValues(Integer.parseInt(v));
        }
        if ((v = props.remove("UDT")) != null) {
            Matcher matcher = this.udtPattern.matcher(v);
            NavigableMap<String, Datatype> datatypes = SystemMetadata.getInstance(this.getVersion()).getSystemStore().getDatatypes();
            if (matcher.matches() && datatypes.get(matcher.group(1)) != null) {
                c.setDatatype((Datatype)datatypes.get(matcher.group(1)));
                c.setLength(Integer.parseInt(matcher.group(2)));
                c.setPrecision(Integer.parseInt(matcher.group(3)));
                c.setScale(Integer.parseInt(matcher.group(4)));
            } else {
                throw new RuntimeException(Messages.getString(Messages.TeiidParser.udt_format_wrong, c.getName()));
            }
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setCommonProperties(AbstractMetadataRecord c, Map<String, String> props) {
        String v = props.remove("UUID");
        if (v != null) {
            c.setUUID(v);
        }
        if ((v = props.remove("ANNOTATION")) != null) {
            c.setAnnotation(v);
        }
        if ((v = props.remove("NAMEINSOURCE")) != null) {
            c.setNameInSource(v);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeCommonProperty(String key, AbstractMetadataRecord c) {
        if (key.equals("UUID")) {
            c.setUUID(null);
        }
        if (key.equals("ANNOTATION")) {
            c.setAnnotation(null);
        }
        if (key.equals("NAMEINSOURCE")) {
            c.setNameInSource(null);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setTableOptions(Table table) {
        Map<String, String> props = table.getProperties();
        this.setCommonProperties(table, props);
        String value = props.remove("MATERIALIZED");
        if (value != null) {
            table.setMaterialized(this.isTrue(value));
        }
        if ((value = props.remove("MATERIALIZED_TABLE")) != null) {
            Table mattable = new Table();
            mattable.setName(value);
            table.setMaterializedTable(mattable);
        }
        if ((value = props.remove("UPDATABLE")) != null) {
            table.setSupportsUpdate(this.isTrue(value));
        }
        if ((value = props.remove("CARDINALITY")) != null) {
            table.setCardinality(Integer.parseInt(value));
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeTableOption(String key, Table table) {
        if (table.getProperty(key, false) != null) {
            table.setProperty(key, null);
        }
        this.removeCommonProperty(key, table);
        if (key.equals("MATERIALIZED")) {
            table.setMaterialized(false);
        }
        if (key.equals("MATERIALIZED_TABLE")) {
            table.setMaterializedTable(null);
        }
        if (key.equals("UPDATABLE")) {
            table.setSupportsUpdate(false);
        }
        if (key.equals("CARDINALITY")) {
            table.setCardinality(-1);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void replaceProcedureWithFunction(MetadataFactory factory, Procedure proc) {
        FunctionMethod method = new FunctionMethod();
        method.setName(proc.getName());
        method.setPushdown(proc.isVirtual() ? FunctionMethod.PushDown.CAN_PUSHDOWN : FunctionMethod.PushDown.MUST_PUSHDOWN);
        ArrayList<FunctionParameter> ins = new ArrayList<FunctionParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType() == ProcedureParameter.Type.InOut || pp.getType() == ProcedureParameter.Type.Out) {
                throw new RuntimeException(Messages.getString(Messages.TeiidParser.function_in, proc.getName()));
            }
            FunctionParameter fp = new FunctionParameter(pp.getName(), pp.getRuntimeType(), pp.getAnnotation());
            if (pp.getType() == ProcedureParameter.Type.In) {
                fp.setVarArg(pp.isVarArg());
                ins.add(fp);
                continue;
            }
            method.setOutputParameter(fp);
        }
        method.setInputParameters(ins);
        if (proc.getResultSet() != null || method.getOutputParameter() == null) {
            throw new RuntimeException(Messages.getString(Messages.TeiidParser.function_return, proc.getName()));
        }
        method.setAnnotation(proc.getAnnotation());
        method.setNameInSource(proc.getNameInSource());
        method.setUUID(proc.getUUID());
        Map<String, String> props = proc.getProperties();
        String value = props.remove("CATEGORY");
        method.setCategory(value);
        value = props.remove("DETERMINISM");
        if (value != null) {
            method.setDeterminism(FunctionMethod.Determinism.valueOf(value.toUpperCase()));
        }
        value = props.remove("JAVA_CLASS");
        method.setInvocationClass(value);
        value = props.remove("JAVA_METHOD");
        method.setInvocationMethod(value);
        for (String key : props.keySet()) {
            value = props.get(key);
            method.setProperty(key, value);
        }
        FunctionMethod.convertExtensionMetadata(proc, method);
        if (method.getInvocationMethod() != null) {
            method.setPushdown(FunctionMethod.PushDown.CAN_PUSHDOWN);
        }
        factory.getSchema().addFunction(method);
        factory.getSchema().getProcedures().remove(proc.getName());
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setProcedureOptions(Procedure proc) {
        Map<String, String> props = proc.getProperties();
        this.setCommonProperties(proc, props);
        String value = props.remove("UPDATECOUNT");
        if (value != null) {
            proc.setUpdateCount(Integer.parseInt(value));
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeOption(String option, AbstractMetadataRecord record) {
        if (record instanceof Table) {
            this.removeTableOption(option, (Table)record);
        }
        if (record instanceof Procedure) {
            this.removeProcedureOption(option, (Procedure)record);
        }
        if (record instanceof BaseColumn) {
            this.removeColumnOption(option, (BaseColumn)record);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setOptions(AbstractMetadataRecord record) {
        if (record instanceof Table) {
            this.setTableOptions((Table)record);
        }
        if (record instanceof Procedure) {
            this.setProcedureOptions((Procedure)record);
        }
        if (record instanceof BaseColumn) {
            this.setColumnOptions((BaseColumn)record);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void removeProcedureOption(String key, Procedure proc) {
        if (proc.getProperty(key, false) != null) {
            proc.setProperty(key, null);
        }
        this.removeCommonProperty(key, proc);
        if (key.equals("UPDATECOUNT")) {
            proc.setUpdateCount(1);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected boolean isTrue(String text) {
        return Boolean.valueOf(text);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected AbstractMetadataRecord getChild(String name, AbstractMetadataRecord record, boolean parameter) {
        if (record instanceof Table) {
            if (parameter) {
                throw new RuntimeException(Messages.getString(Messages.TeiidParser.alter_table_param, name, record.getName()));
            }
            return this.getColumn(name, (Table)record);
        }
        return this.getColumn(name, (Procedure)record, parameter);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected Column getColumn(String columnName, Table table) {
        Column c = table.getColumnByName(columnName);
        if (c != null) {
            return c;
        }
        throw new RuntimeException(Messages.getString(Messages.TeiidParser.no_column, columnName, table.getName()));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected AbstractMetadataRecord getColumn(String paramName, Procedure proc, boolean parameter) {
        Column result;
        if (proc.getResultSet() != null && (result = proc.getResultSet().getColumnByName(paramName)) != null) {
            return result;
        }
        if (parameter) {
            List<ProcedureParameter> params = proc.getParameters();
            for (ProcedureParameter param : params) {
                if (!param.getName().equalsIgnoreCase(paramName)) continue;
                return param;
            }
        }
        throw new RuntimeException(Messages.getString(Messages.TeiidParser.alter_procedure_param_doesnot_exist, paramName, proc.getName()));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected FunctionParameter getParameter(String paramName, FunctionMethod func) {
        List<FunctionParameter> params = func.getInputParameters();
        for (FunctionParameter param : params) {
            if (!param.getName().equalsIgnoreCase(paramName)) continue;
            return param;
        }
        throw new RuntimeException(Messages.getString(Messages.TeiidParser.alter_function_param_doesnot_exist, paramName, func.getName()));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void createDDLTrigger(MetadataFactory schema, AlterTrigger trigger) {
        GroupSymbol group = trigger.getTarget();
        Table table = schema.getSchema().getTable(group.getName());
        if (trigger.getEvent().equals((Object)Table.TriggerEvent.INSERT)) {
            table.setInsertPlan(((TriggerAction)trigger.getDefinition()).toString());
        } else if (trigger.getEvent().equals((Object)Table.TriggerEvent.UPDATE)) {
            table.setUpdatePlan(((TriggerAction)trigger.getDefinition()).toString());
        } else if (trigger.getEvent().equals((Object)Table.TriggerEvent.DELETE)) {
            table.setDeletePlan(((TriggerAction)trigger.getDefinition()).toString());
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected BaseColumn addProcColumn(MetadataFactory factory, Procedure proc, String name, ParsedDataType type, boolean rs) {
        BaseColumn column = null;
        if (rs) {
            column = factory.addProcedureResultSetColumn(name, type.getType(), proc);
        } else {
            boolean added = false;
            for (ProcedureParameter pp : proc.getParameters()) {
                if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
                added = true;
                if (pp.getDatatype() == factory.getDataTypes().get(type.getType())) continue;
                throw new RuntimeException(Messages.getString(Messages.TeiidParser.proc_type_conflict, proc.getName(), pp.getDatatype(), type.getType()));
            }
            if (!added) {
                column = factory.addProcedureParameter(name, type.getType(), ProcedureParameter.Type.ReturnValue, proc);
            }
        }
        this.setTypeInfo(type, column);
        return column;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void setTypeInfo(ParsedDataType type, BaseColumn column) {
        if (type.getLength() != null) {
            column.setLength(type.getLength());
        }
        if (type.getScale() != null) {
            column.setScale(type.getScale());
        }
        if (type.getPrecision() != null) {
            column.setPrecision(type.getPrecision());
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected String resolvePropertyKey(MetadataFactory factory, String key) {
        int index = key.indexOf(58);
        if (index > 0 && index < key.length() - 1) {
            String prefix = key.substring(0, index);
            String uri = MetadataFactory.BUILTIN_NAMESPACES.get(prefix);
            if (uri == null) {
                uri = factory.getNamespaces().get(prefix);
            }
            if (uri != null) {
                key = String.valueOf('{') + uri + '}' + key.substring(index + 1, key.length());
            }
        }
        return key;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected KeyRecord addFBI(MetadataFactory factory, List<Expression> expressions, Table table, String name) {
        ArrayList<String> columnNames = new ArrayList<String>(expressions.size());
        ArrayList<Boolean> nonColumnExpressions = new ArrayList<Boolean>(expressions.size());
        boolean fbi = false;
        int i = 0;
        while (i < expressions.size()) {
            Expression ex = expressions.get(i);
            if (ex instanceof ElementSymbol) {
                columnNames.add(((ElementSymbol)ex).getName());
                nonColumnExpressions.add(Boolean.FALSE);
            } else {
                columnNames.add(ex.toString());
                nonColumnExpressions.add(Boolean.TRUE);
                fbi = true;
            }
            ++i;
        }
        return factory.addFunctionBasedIndex(name != null ? name : "INDEX" + (fbi ? table.getFunctionBasedIndexes().size() : table.getIndexes().size()), columnNames, nonColumnExpressions, table);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    protected MetadataFactory getTempMetadataFactory() {
        if (this.metadataFactory == null) {
            this.metadataFactory = new MetadataFactory(this.version, "temp", 1, "temp", SystemMetadata.getInstance(this.getVersion()).getRuntimeTypeMap(), null, null);
        }
        return this.metadataFactory;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    protected void setSourceHint(SourceHint sourceHint, Command command) {
        if (sourceHint == null) {
            return;
        }
        if (command instanceof SetQuery) {
            ((SetQuery)command).getProjectedQuery().setSourceHint(sourceHint);
        } else {
            command.setSourceHint(sourceHint);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    protected List<Expression> arrayExpressions(List<Expression> expressions, Expression expr) {
        if (expressions == null) {
            expressions = new ArrayList<Expression>();
        }
        if (expr != null) {
            expressions.add(expr);
        }
        return expressions;
    }
}

