/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class TransformationMetadata
extends BasicQueryMetadata
implements Serializable {
    public static final String ALLOWED_LANGUAGES = "allowed-languages";
    private static final long serialVersionUID = 1058627332954475287L;
    public static final char DELIMITER_CHAR = '.';
    public static final String DELIMITER_STRING = String.valueOf('.');
    public static String NOT_EXISTS_MESSAGE = String.valueOf(StringUtil.Constants.SPACE) + Messages.getString(Messages.TransformationMetadata.doesNotExist, new Object[0]);
    public static Properties EMPTY_PROPS = new Properties();
    private final TeiidParser teiidParser;
    private final CompositeMetadataStore store;
    private DataTypeManagerService dataTypeManager;
    private Map<String, VDBResources.Resource> vdbEntries;
    private FunctionLibrary functionLibrary;
    private VDBMetaData vdbMetaData;
    private ScriptEngineManager scriptEngineManager;
    private Map<String, ScriptEngineFactory> scriptEngineFactories = Collections.synchronizedMap(new HashMap());
    private Set<String> importedModels;
    private Set<String> allowedLanguages;
    private Map<String, DataPolicyMetadata> policies = new TreeMap<String, DataPolicyMetadata>(String.CASE_INSENSITIVE_ORDER);
    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    private boolean useOutputNames = true;
    private Map<String, Object> metadataCache = Collections.synchronizedMap(new LRUCache(250));
    private Map<String, Object> groupInfoCache = Collections.synchronizedMap(new LRUCache(250));
    private Map<String, Collection<Table>> partialNameToFullNameCache = Collections.synchronizedMap(new LRUCache(1000));
    private Map<String, Collection<StoredProcedureInfo>> procedureCache = Collections.synchronizedMap(new LRUCache(200));

    public TransformationMetadata(TeiidParser teiidParser, VDBMetaData vdbMetadata, CompositeMetadataStore store, Map<String, VDBResources.Resource> vdbEntries, FunctionTree systemFunctions, Collection<FunctionTree> functionTrees) {
        super(teiidParser.getVersion());
        ArgCheck.isNotNull(store);
        this.teiidParser = teiidParser;
        this.vdbMetaData = vdbMetadata;
        if (this.vdbMetaData != null) {
            this.scriptEngineManager = vdbMetadata.getAttachment(ScriptEngineManager.class);
            this.importedModels = this.vdbMetaData.getImportedModels();
            this.allowedLanguages = (Set)StringUtil.valueOf(vdbMetadata.getPropertyValue(ALLOWED_LANGUAGES), Set.class);
            if (this.allowedLanguages == null) {
                this.allowedLanguages = Collections.emptySet();
            }
            for (DataPolicyMetadata policy : vdbMetadata.getDataPolicyMap().values()) {
                policy = policy.clone();
                this.policies.put(policy.getName(), policy);
            }
            store.processGrants(this.policies);
        } else {
            this.importedModels = Collections.emptySet();
        }
        this.store = store;
        this.vdbEntries = vdbEntries == null ? Collections.emptyMap() : vdbEntries;
        this.functionLibrary = functionTrees == null ? new FunctionLibrary(teiidParser.getVersion(), systemFunctions, new FunctionTree[0]) : new FunctionLibrary(teiidParser.getVersion(), systemFunctions, functionTrees.toArray(new FunctionTree[functionTrees.size()]));
    }

    private TransformationMetadata(TeiidParser teiidParser, CompositeMetadataStore store, FunctionLibrary functionLibrary) {
        super(teiidParser.getVersion());
        this.teiidParser = teiidParser;
        this.store = store;
        this.vdbEntries = Collections.emptyMap();
        this.functionLibrary = functionLibrary;
    }

    public TeiidParser getTeiidParser() {
        return this.teiidParser;
    }

    @Override
    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidParser.getVersion();
    }

    public DataTypeManagerService getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = DataTypeManagerService.getInstance(this.getTeiidVersion());
        }
        return this.dataTypeManager;
    }

    @Override
    public Column getElementID(String elementName) throws Exception {
        int columnIndex = elementName.lastIndexOf(DELIMITER_STRING);
        if (columnIndex == -1) {
            throw new TeiidClientException(String.valueOf(elementName) + NOT_EXISTS_MESSAGE);
        }
        Table table = this.store.findGroup(elementName.substring(0, columnIndex));
        String shortElementName = elementName.substring(columnIndex + 1);
        return TransformationMetadata.getColumn(elementName, table, shortElementName);
    }

    public static Column getColumn(String elementName, Table table, String shortElementName) throws Exception {
        Column c = table.getColumnByName(shortElementName);
        if (c != null) {
            return c;
        }
        throw new TeiidClientException(String.valueOf(elementName) + NOT_EXISTS_MESSAGE);
    }

    @Override
    public Table getGroupID(String groupName) throws Exception {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            groupName = groupName.toUpperCase();
        }
        return this.getMetadataStore().findGroup(groupName);
    }

    @Override
    public Collection<String> getGroupsForPartialName(String partialGroupName) throws Exception {
        ArgCheck.isNotEmpty(partialGroupName);
        Collection<Table> matches = this.partialNameToFullNameCache.get(partialGroupName);
        if (matches == null) {
            matches = this.getMetadataStore().getGroupsForPartialName(partialGroupName);
            this.partialNameToFullNameCache.put(partialGroupName, matches);
        }
        if (matches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> filteredResult = new ArrayList<String>(matches.size());
        for (Table table : matches) {
            if (this.vdbMetaData != null && !this.vdbMetaData.isVisible(((Schema)table.getParent()).getName())) continue;
            filteredResult.add(table.getFullName());
        }
        return filteredResult;
    }

    @Override
    public Object getModelID(Object groupOrElementID) throws Exception {
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)groupOrElementID;
        AbstractMetadataRecord parent = metadataRecord.getParent();
        if (parent instanceof Schema) {
            return parent;
        }
        if (parent == null) {
            throw this.createInvalidRecordTypeException(groupOrElementID);
        }
        if ((parent = parent.getParent()) instanceof Schema) {
            return parent;
        }
        throw this.createInvalidRecordTypeException(groupOrElementID);
    }

    @Override
    public String getFullName(Object metadataID) throws Exception {
        Column c;
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        if (metadataRecord instanceof Column && (c = (Column)metadataRecord).getParent() != null && ((ColumnSet)c.getParent()).getParent() instanceof Procedure) {
            return String.valueOf(((AbstractMetadataRecord)((ColumnSet)c.getParent()).getParent()).getFullName()) + '.' + c.getName();
        }
        return metadataRecord.getFullName();
    }

    @Override
    public String getName(Object metadataID) throws Exception, TeiidClientException {
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        return metadataRecord.getName();
    }

    @Override
    public List<Column> getElementIDsInGroupID(Object groupID) throws Exception {
        List<Column> columns = ((Table)groupID).getColumns();
        if (columns == null || columns.isEmpty()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID31071, ((Table)groupID).getName()));
        }
        return columns;
    }

    @Override
    public Object getGroupIDForElementID(Object elementID) throws Exception {
        BaseColumn columnRecord;
        if (elementID instanceof Column) {
            columnRecord = (Column)elementID;
            AbstractMetadataRecord parent = ((Column)columnRecord).getParent();
            if (parent instanceof Table) {
                return parent;
            }
            if (parent instanceof ColumnSet && (parent = ((ColumnSet)parent).getParent()) instanceof Procedure) {
                return parent;
            }
        }
        if (elementID instanceof ProcedureParameter) {
            columnRecord = (ProcedureParameter)elementID;
            return ((ProcedureParameter)columnRecord).getParent();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public boolean hasProcedure(String name) throws Exception {
        try {
            return this.getStoredProcInfoDirect(name) != null;
        }
        catch (TeiidClientException teiidClientException) {
            return true;
        }
    }

    @Override
    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String name) throws Exception {
        StoredProcedureInfo result = this.getStoredProcInfoDirect(name);
        if (result == null) {
            throw new TeiidClientException(String.valueOf(name) + NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    private StoredProcedureInfo getStoredProcInfoDirect(String name) throws Exception {
        ArgCheck.isNotEmpty(name);
        String canonicalName = name.toUpperCase();
        Collection<StoredProcedureInfo> results = this.procedureCache.get(canonicalName);
        if (results == null) {
            Collection<Procedure> procRecords = this.getMetadataStore().getStoredProcedure(canonicalName);
            if (procRecords.isEmpty()) {
                return null;
            }
            results = new ArrayList<StoredProcedureInfo>(procRecords.size());
            for (Procedure procRecord : procRecords) {
                String procedureFullName = procRecord.getFullName();
                StoredProcedureInfo procInfo = new StoredProcedureInfo();
                procInfo.setProcedureCallableName(procedureFullName);
                procInfo.setProcedureID(procRecord);
                procInfo.setModelID(procRecord.getParent());
                for (ProcedureParameter paramRecord : procRecord.getParameters()) {
                    String runtimeType = paramRecord.getRuntimeType();
                    int direction = this.convertParamRecordTypeToStoredProcedureType(paramRecord.getType());
                    SPParameter spParam = new SPParameter(this.getTeiidParser(), paramRecord.getPosition(), direction, paramRecord.getFullName());
                    spParam.setMetadataID(paramRecord);
                    spParam.setClassType(this.getDataTypeManager().getDataTypeClass(runtimeType));
                    if (paramRecord.isVarArg()) {
                        spParam.setVarArg(true);
                        spParam.setClassType(this.getDataTypeManager().getDataType(spParam.getClassType()).getTypeArrayClass());
                    }
                    procInfo.addParameter(spParam);
                }
                if (procRecord.getResultSet() != null) {
                    ColumnSet<Procedure> resultRecord = procRecord.getResultSet();
                    int lastParamIndex = procInfo.getParameters().size() + 1;
                    SPParameter param = new SPParameter(this.getTeiidParser(), lastParamIndex, SPParameter.RESULT_SET, resultRecord.getFullName());
                    param.setClassType(ResultSet.class);
                    param.setMetadataID(resultRecord);
                    for (Column columnRecord : resultRecord.getColumns()) {
                        String colType = columnRecord.getRuntimeType();
                        param.addResultSetColumn(columnRecord.getFullName(), this.getDataTypeManager().getDataTypeClass(colType), columnRecord);
                    }
                    procInfo.addParameter(param);
                }
                if (procRecord.isVirtual()) {
                    LiveQueryNode queryNode = new LiveQueryNode(procRecord);
                    procInfo.setQueryPlan(queryNode);
                }
                procInfo.setUpdateCount(procRecord.getUpdateCount() - 1);
                results.add(procInfo);
            }
            this.procedureCache.put(canonicalName, results);
        }
        StoredProcedureInfo result = null;
        for (StoredProcedureInfo storedProcedureInfo : results) {
            Schema schema = (Schema)storedProcedureInfo.getModelID();
            if (!name.equalsIgnoreCase(storedProcedureInfo.getProcedureCallableName()) && this.vdbMetaData != null && !this.vdbMetaData.isVisible(schema.getName())) continue;
            if (result != null) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30358, name));
            }
            result = storedProcedureInfo;
        }
        return result;
    }

    private int convertParamRecordTypeToStoredProcedureType(ProcedureParameter.Type parameterType) {
        switch (parameterType) {
            case In: {
                return SPParameter.IN;
            }
            case Out: {
                return SPParameter.OUT;
            }
            case InOut: {
                return SPParameter.INOUT;
            }
            case ReturnValue: {
                return SPParameter.RETURN_VALUE;
            }
        }
        return -1;
    }

    @Override
    public String getElementType(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getRuntimeType();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getRuntimeType();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getDefaultValue(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getDefaultValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getDefaultValue();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getMinimumValue(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getMinimumValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getMaximumValue(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getMaximumValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public boolean isVirtualGroup(Object groupID) throws Exception {
        if (groupID instanceof Table) {
            return ((Table)groupID).isVirtual();
        }
        if (groupID instanceof Procedure) {
            return ((Procedure)groupID).isVirtual();
        }
        throw this.createInvalidRecordTypeException(groupID);
    }

    @Override
    public boolean isProcedure(Object groupID) throws Exception {
        if (groupID instanceof Procedure) {
            return true;
        }
        if (groupID instanceof Table) {
            return false;
        }
        throw this.createInvalidRecordTypeException(groupID);
    }

    @Override
    public boolean isVirtualModel(Object modelID) throws Exception {
        Schema modelRecord = (Schema)modelID;
        return !modelRecord.isPhysical();
    }

    @Override
    public QueryNode getVirtualPlan(Object groupID) throws Exception {
        Table tableRecord = (Table)groupID;
        if (!tableRecord.isVirtual()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30359, tableRecord.getFullName(), "Query"));
        }
        LiveTableQueryNode queryNode = new LiveTableQueryNode(tableRecord);
        List<String> bindings = tableRecord.getBindings();
        if (bindings != null) {
            Iterator<String> bindIter = bindings.iterator();
            while (bindIter.hasNext()) {
                queryNode.addBinding(bindIter.next());
            }
        }
        return queryNode;
    }

    @Override
    public String getInsertPlan(Object groupID) throws Exception {
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30359, tableRecordImpl.getFullName(), "Insert"));
        }
        return tableRecordImpl.isInsertPlanEnabled() ? tableRecordImpl.getInsertPlan() : null;
    }

    @Override
    public String getUpdatePlan(Object groupID) throws Exception {
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30359, tableRecordImpl.getFullName(), "Update"));
        }
        return tableRecordImpl.isUpdatePlanEnabled() ? tableRecordImpl.getUpdatePlan() : null;
    }

    @Override
    public String getDeletePlan(Object groupID) throws Exception {
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30359, tableRecordImpl.getFullName(), "Delete"));
        }
        return tableRecordImpl.isDeletePlanEnabled() ? tableRecordImpl.getDeletePlan() : null;
    }

    @Override
    public boolean modelSupports(Object modelID, int modelConstant) throws Exception {
        throw new UnsupportedOperationException(String.valueOf(Messages.getString(Messages.TransformationMetadata.unknownSupportConstant12, new Object[0])) + modelConstant);
    }

    @Override
    public boolean groupSupports(Object groupID, int groupConstant) throws Exception {
        Table tableRecord = (Table)groupID;
        switch (groupConstant) {
            case 0: {
                return tableRecord.supportsUpdate();
            }
        }
        throw new UnsupportedOperationException(String.valueOf(Messages.getString(Messages.TransformationMetadata.unknownSupportConstant12, new Object[0])) + groupConstant);
    }

    @Override
    public boolean elementSupports(Object elementID, int elementConstant) throws Exception {
        if (elementID instanceof Column) {
            Column columnRecord = (Column)elementID;
            switch (elementConstant) {
                case 4: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Nullable;
                }
                case 10: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Unknown;
                }
                case 2: {
                    return columnRecord.getSearchType() == Column.SearchType.Searchable || columnRecord.getSearchType() == Column.SearchType.All_Except_Like;
                }
                case 1: {
                    return columnRecord.getSearchType() == Column.SearchType.Searchable || columnRecord.getSearchType() == Column.SearchType.Like_Only;
                }
                case 0: {
                    return columnRecord.isSelectable();
                }
                case 5: {
                    return columnRecord.isUpdatable();
                }
                case 7: {
                    String defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return columnRecord.isAutoIncremented();
                }
                case 9: {
                    return columnRecord.isCaseSensitive();
                }
                case 11: {
                    return columnRecord.isSigned();
                }
            }
            throw new UnsupportedOperationException(String.valueOf(Messages.getString(Messages.TransformationMetadata.unknownSupportConstant12, new Object[0])) + elementConstant);
        }
        if (elementID instanceof ProcedureParameter) {
            ProcedureParameter columnRecord = (ProcedureParameter)elementID;
            switch (elementConstant) {
                case 4: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Nullable;
                }
                case 10: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Unknown;
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 0: {
                    return columnRecord.getType() != ProcedureParameter.Type.In;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    String defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return true;
                }
            }
            throw new UnsupportedOperationException(String.valueOf(Messages.getString(Messages.TransformationMetadata.unknownSupportConstant12, new Object[0])) + elementConstant);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    private IllegalArgumentException createInvalidRecordTypeException(Object elementID) {
        return new IllegalArgumentException(Messages.getString(Messages.TransformationMetadata.invalidType, elementID.getClass().getName()));
    }

    @Override
    public int getMaxSetSize(Object modelID) throws Exception {
        return 0;
    }

    @Override
    public Collection<KeyRecord> getIndexesInGroup(Object groupID) throws Exception {
        return ((Table)groupID).getIndexes();
    }

    @Override
    public Collection<KeyRecord> getUniqueKeysInGroup(Object groupID) throws Exception {
        Table tableRecordImpl = (Table)groupID;
        ArrayList<KeyRecord> result = new ArrayList<KeyRecord>(tableRecordImpl.getUniqueKeys());
        if (tableRecordImpl.getPrimaryKey() != null) {
            result.add(tableRecordImpl.getPrimaryKey());
        }
        for (KeyRecord key : tableRecordImpl.getIndexes()) {
            if (key.getType() != KeyRecord.Type.Unique) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public Collection<ForeignKey> getForeignKeysInGroup(Object groupID) throws Exception {
        return ((Table)groupID).getForeignKeys();
    }

    @Override
    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws Exception {
        ForeignKey fkRecord = (ForeignKey)foreignKeyID;
        return fkRecord.getPrimaryKey();
    }

    @Override
    public Collection<KeyRecord> getAccessPatternsInGroup(Object groupID) throws Exception {
        return ((Table)groupID).getAccessPatterns();
    }

    @Override
    public List<Column> getElementIDsInIndex(Object index) throws Exception {
        return ((ColumnSet)index).getColumns();
    }

    @Override
    public List<Column> getElementIDsInKey(Object key) throws Exception {
        return ((ColumnSet)key).getColumns();
    }

    @Override
    public List<Column> getElementIDsInAccessPattern(Object accessPattern) throws Exception {
        return ((ColumnSet)accessPattern).getColumns();
    }

    @Override
    public boolean isXMLGroup(Object groupID) throws Exception {
        Table tableRecord = (Table)groupID;
        return tableRecord.getTableType() == Table.Type.Document;
    }

    @Override
    public boolean hasMaterialization(Object groupID) throws Exception, TeiidClientException {
        Table tableRecord = (Table)groupID;
        return tableRecord.isMaterialized();
    }

    @Override
    public Object getMaterialization(Object groupID) throws Exception, TeiidClientException {
        Table tableRecord = (Table)groupID;
        if (tableRecord.isMaterialized()) {
            return tableRecord.getMaterializedTable();
        }
        return null;
    }

    @Override
    public Object getMaterializationStage(Object groupID) throws Exception, TeiidClientException {
        Table tableRecord = (Table)groupID;
        if (tableRecord.isMaterialized()) {
            return tableRecord.getMaterializedStageTable();
        }
        return null;
    }

    @Override
    public MappingNode getMappingNode(Object groupID) throws Exception {
        Table tableRecord = (Table)groupID;
        MappingDocument mappingDoc = (MappingDocument)this.getFromMetadataCache(groupID, "xml-doc");
        if (mappingDoc != null) {
            return mappingDoc;
        }
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            String document = tableRecord.getSelectTransformation();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(document.getBytes());
            MappingLoader reader = new MappingLoader(this.getTeiidParser());
            try {
                try {
                    mappingDoc = reader.loadDocument(inputStream);
                    mappingDoc.setName(groupName);
                }
                catch (Exception e) {
                    throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30363, groupName, mappingDoc));
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception exception) {}
            this.addToMetadataCache(groupID, "xml-doc", mappingDoc);
            return mappingDoc;
        }
        return null;
    }

    @Override
    public String getVirtualDatabaseName() throws Exception {
        if (this.vdbMetaData == null) {
            return null;
        }
        return this.vdbMetaData.getName();
    }

    public int getVirtualDatabaseVersion() {
        if (this.vdbMetaData == null) {
            return 0;
        }
        return this.vdbMetaData.getVersion();
    }

    public VDBMetaData getVdbMetaData() {
        return this.vdbMetaData;
    }

    @Override
    public Collection<Table> getXMLTempGroups(Object groupID) throws Exception {
        Table tableRecord = (Table)groupID;
        if (tableRecord.getTableType() == Table.Type.Document) {
            return this.store.getXMLTempGroups(tableRecord);
        }
        return Collections.emptySet();
    }

    @Override
    public float getCardinality(Object groupID) throws Exception {
        return ((Table)groupID).getCardinalityAsFloat();
    }

    @Override
    public List<SQLXMLImpl> getXMLSchemas(Object groupID) throws Exception {
        Table tableRecord = (Table)groupID;
        String groupName = tableRecord.getFullName();
        List<String> schemaPaths = tableRecord.getSchemaPaths();
        LinkedList<SQLXMLImpl> schemas = new LinkedList<SQLXMLImpl>();
        if (schemaPaths == null) {
            return schemas;
        }
        String path = this.getParentPath(tableRecord.getResourcePath());
        for (String string : schemaPaths) {
            String parentPath = path;
            boolean relative = false;
            while (string.startsWith("../")) {
                relative = true;
                string = string.substring(3);
                parentPath = this.getParentPath(parentPath);
            }
            SQLXMLImpl schema = null;
            if (!relative) {
                schema = this.getVDBResourceAsSQLXML(string);
            }
            if (schema == null) {
                if (!parentPath.endsWith("/")) {
                    parentPath = String.valueOf(parentPath) + "/";
                }
                schema = this.getVDBResourceAsSQLXML(String.valueOf(parentPath) + string);
            }
            if (schema == null) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30364, groupName));
            }
            schemas.add(schema);
        }
        return schemas;
    }

    private String getParentPath(String path) {
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(47);
        path = index > 0 ? path.substring(0, index) : "";
        return path;
    }

    @Override
    public String getNameInSource(Object metadataID) throws Exception {
        return ((AbstractMetadataRecord)metadataID).getNameInSource();
    }

    @Override
    public int getElementLength(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getLength();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getLength();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getPosition(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getPosition();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getPosition();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getPrecision(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getPrecision();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getPrecision();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getRadix(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getRadix();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getRadix();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public String getFormat(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getFormat();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getScale(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getScale();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getScale();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public float getDistinctValues(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getDistinctValuesAsFloat();
        }
        if (elementID instanceof ProcedureParameter) {
            return -1.0f;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public float getNullValues(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getNullValuesAsFloat();
        }
        if (elementID instanceof ProcedureParameter) {
            return -1.0f;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public String getNativeType(Object elementID) throws Exception {
        if (elementID instanceof Column) {
            return ((Column)elementID).getNativeType();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) throws Exception {
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        Map<String, String> result = metadataRecord.getProperties();
        if (result == null) {
            return EMPTY_PROPS;
        }
        Properties p = new Properties();
        p.putAll(result);
        return p;
    }

    @Override
    public String getExtensionProperty(Object metadataID, String key, boolean checkUnqualified) {
        return ((AbstractMetadataRecord)metadataID).getProperty(key, checkUnqualified);
    }

    @Override
    public byte[] getBinaryVDBResource(String resourcePath) throws Exception {
        VDBResources.Resource f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        try {
            return ObjectConverterUtil.convertToByteArray(f.openStream());
        }
        catch (IOException e) {
            throw new TeiidClientException(e);
        }
    }

    public ClobImpl getVDBResourceAsClob(String resourcePath) {
        VDBResources.Resource f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new ClobImpl(new VirtualFileInputStreamFactory(f), -1L);
    }

    public SQLXMLImpl getVDBResourceAsSQLXML(String resourcePath) {
        VDBResources.Resource f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new SQLXMLImpl(new VirtualFileInputStreamFactory(f));
    }

    public BlobImpl getVDBResourceAsBlob(String resourcePath) {
        VDBResources.Resource f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new BlobImpl(new VirtualFileInputStreamFactory(f));
    }

    private VDBResources.Resource getFile(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        return this.vdbEntries.get(resourcePath);
    }

    @Override
    public String getCharacterVDBResource(String resourcePath) throws Exception {
        byte[] bytes;
        block3: {
            try {
                bytes = this.getBinaryVDBResource(resourcePath);
                if (bytes != null) break block3;
                return null;
            }
            catch (IOException e) {
                throw new TeiidClientException(e);
            }
        }
        return ObjectConverterUtil.convertToString(new ByteArrayInputStream(bytes));
    }

    public CompositeMetadataStore getMetadataStore() {
        return this.store;
    }

    @Override
    public String[] getVDBResourcePaths() throws Exception {
        LinkedList<String> paths = new LinkedList<String>();
        for (Map.Entry<String, VDBResources.Resource> entry : this.vdbEntries.entrySet()) {
            paths.add(entry.getKey());
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public Object addToMetadataCache(Object metadataID, String key, Object value) {
        boolean groupInfo = key.startsWith("groupinfo/");
        key = this.getCacheKey(key, (AbstractMetadataRecord)metadataID);
        if (groupInfo) {
            return this.groupInfoCache.put(key, value);
        }
        return this.metadataCache.put(key, value);
    }

    @Override
    public Object getFromMetadataCache(Object metadataID, String key) throws Exception {
        boolean groupInfo = key.startsWith("groupinfo/");
        key = this.getCacheKey(key, (AbstractMetadataRecord)metadataID);
        if (groupInfo) {
            return this.groupInfoCache.get(key);
        }
        return this.metadataCache.get(key);
    }

    private String getCacheKey(String key, AbstractMetadataRecord record) {
        return String.valueOf(record.getUUID()) + "/" + key;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public Object getPrimaryKey(Object metadataID) {
        Table table = (Table)metadataID;
        return table.getPrimaryKey();
    }

    @Override
    public IQueryMetadataInterface getDesignTimeMetadata() {
        TransformationMetadata tm = new TransformationMetadata(this.getTeiidParser(), this.store, this.functionLibrary);
        tm.groupInfoCache = this.groupInfoCache;
        tm.metadataCache = this.metadataCache;
        tm.partialNameToFullNameCache = this.partialNameToFullNameCache;
        tm.procedureCache = this.procedureCache;
        tm.scriptEngineManager = this.scriptEngineManager;
        tm.importedModels = this.importedModels;
        tm.allowedLanguages = this.allowedLanguages;
        return tm;
    }

    @Override
    public Set<String> getImportedModels() {
        return this.importedModels;
    }

    @Override
    public ScriptEngine getScriptEngineDirect(String language) throws Exception {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
        ScriptEngine engine = null;
        if (this.allowedLanguages == null || this.allowedLanguages.contains(language)) {
            ScriptEngineFactory sef = this.scriptEngineFactories.get(language);
            if (sef != null) {
                try {
                    engine = sef.getScriptEngine();
                    engine.setBindings(this.scriptEngineManager.getBindings(), 100);
                }
                catch (Exception exception) {}
            }
            engine = this.scriptEngineManager.getEngineByName(language);
        }
        if (engine == null) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
                names.addAll(factory.getNames());
            }
            if (this.allowedLanguages != null) {
                names.retainAll(this.allowedLanguages);
            }
            names.add("teiid_script");
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID31109, language, names));
        }
        this.scriptEngineFactories.put(language, engine.getFactory());
        return engine;
    }

    @Override
    public boolean isVariadic(Object metadataID) {
        if (metadataID instanceof ProcedureParameter) {
            return ((ProcedureParameter)metadataID).isVarArg();
        }
        if (metadataID instanceof FunctionParameter) {
            return ((FunctionParameter)metadataID).isVarArg();
        }
        return false;
    }

    @Override
    public Schema getModelID(String modelName) throws Exception {
        Schema s = this.getMetadataStore().getSchema(modelName);
        if (s == null) {
            throw new TeiidClientException(String.valueOf(modelName) + NOT_EXISTS_MESSAGE);
        }
        return s;
    }

    public Map<String, DataPolicyMetadata> getPolicies() {
        return this.policies;
    }

    @Override
    public boolean useOutputName() {
        return this.useOutputNames;
    }

    public void setUseOutputNames(boolean useOutputNames) {
        this.useOutputNames = useOutputNames;
    }

    private static final class LiveQueryNode
    extends QueryNode {
        Procedure p;

        private LiveQueryNode(Procedure p) {
            super(null);
            this.p = p;
        }

        @Override
        public String getQuery() {
            return this.p.getQueryPlan();
        }
    }

    private static final class LiveTableQueryNode
    extends QueryNode {
        Table t;

        private LiveTableQueryNode(Table t) {
            super(null);
            this.t = t;
        }

        @Override
        public String getQuery() {
            return this.t.getSelectTransformation();
        }
    }

    private final class VirtualFileInputStreamFactory
    extends InputStreamFactory {
        private final VDBResources.Resource r;

        private VirtualFileInputStreamFactory(VDBResources.Resource r) {
            this.r = r;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.r.openStream();
        }

        @Override
        public long getLength() {
            return this.r.getSize();
        }

        @Override
        public InputStreamFactory.StorageMode getStorageMode() {
            return InputStreamFactory.StorageMode.PERSISTENT;
        }
    }
}

