/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class StringToBigDecimalTransform
extends Transform {
    public StringToBigDecimalTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        try {
            return new BigDecimal(((String)value).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10063, value));
        }
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

