/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToIntegerTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;

    public NumberToIntegerTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType, boolean isNarrowing) {
        super(dataTypeManager);
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.isNarrowing) {
            this.checkValueRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        return ((Number)value).intValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

