/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.ui.view.server;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.tools.bpel.runtimes.module.JBTBPELPublisher;

public class BPELModuleContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModuleServer) {
            IServer s = ((ModuleServer)parentElement).server;
            IModule[] module = ((ModuleServer)parentElement).module;
            IModule mod = module.length > 0 ? module[module.length - 1] : null;
            String typeId = mod.getModuleType().getId();
            if (mod != null && mod.getProject() != null && (typeId.equals("jbt.bpel.module") || typeId.equals("bpel.module"))) {
                String[] versions = JBTBPELPublisher.getDeployedPathsFromDescriptor(s, mod.getProject());
                return this.wrap((ModuleServer)parentElement, versions);
            }
        }
        return new Object[0];
    }

    protected BPELVersionDeployment[] wrap(ModuleServer ms, String[] vals) {
        BPELVersionDeployment[] versions = new BPELVersionDeployment[vals.length];
        int i = 0;
        while (i < vals.length) {
            versions[i] = new BPELVersionDeployment(ms, vals[i]);
            ++i;
        }
        return versions;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static class BPELVersionDeployment {
        private String path;
        private ModuleServer ms;

        public BPELVersionDeployment(ModuleServer ms, String path) {
            this.path = path;
            this.ms = ms;
        }

        public String getPath() {
            return this.path;
        }

        public ModuleServer getModuleServer() {
            return this.ms;
        }

        public IProject getProject() {
            if (this.ms.module != null && this.ms.module.length > 0) {
                return this.ms.module[this.ms.module.length - 1].getProject();
            }
            return null;
        }
    }
}

