/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.webtools.modules.LocalZippedPublisherUtil;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.IPublishCopyCallbackHandler;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.LocalCopyCallback;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.PublishCopyUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.bpel.runtimes.module.Messages;
import org.jboss.tools.jmx.core.IMemento;
import org.jboss.tools.jmx.core.util.XMLMemento;

public class JBTBPELPublisher
implements IJBossServerPublisher {
    private IServer server;
    private int publishState = 2;
    private static final String DEPLOYMENTS = "deployments";
    private static final String PROJECT = "project";
    private static final String NAME = "name";
    private static final String VERSION = "version";

    public int getPublishState() {
        return this.publishState;
    }

    public boolean accepts(String method, IServer server, IModule[] module) {
        return "local".equals(method) && module != null && module.length > 0 && module[module.length - 1] != null && (module[module.length - 1].getModuleType().getId().equals("jbt.bpel.module") || module[module.length - 1].getModuleType().getId().equals("bpel.module"));
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        this.server = server;
        IModule last = module[module.length - 1];
        IStatus status = null;
        if (publishType == 3) {
            if (last.getProject() != null) {
                JBTBPELPublisher.removeAll(server, last.getProject());
            }
        } else if (publishType == 2) {
            status = this.publish(module, delta, publishType, monitor);
            this.publishState = 1;
        } else if (publishType == 1) {
            this.publishState = 2;
        }
        if (status != null && !status.isOK()) {
            final IStatus s = status;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeployError, (String)s.getMessage());
                }
            });
        }
        return status == null ? Status.OK_STATUS : status;
    }

    protected IStatus publish(IModule[] moduleTree, IModuleResourceDelta[] delta, int publishType, IProgressMonitor monitor) throws CoreException {
        BPELZippedPublisherUtil util;
        ArrayList<IStatus> resultList = new ArrayList<IStatus>();
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        IModule last = moduleTree[moduleTree.length - 1];
        IPath deployPath = JBTBPELPublisher.getDeployPath(moduleTree, ds);
        IPath tempDeployPath = ds.getTempDeploymentLocation(moduleTree, false);
        IModuleResource[] members = ModuleResourceUtil.getResources((IModule)last, (IProgressMonitor)new NullProgressMonitor());
        boolean hasDeployXML = false;
        int i = 0;
        while (i < members.length) {
            IModuleResource res = members[i];
            String name = res.getName();
            if ("deploy.xml".equals(name) || "bpel-deploy.xml".equals(name)) {
                hasDeployXML = true;
                break;
            }
            ++i;
        }
        if (!hasDeployXML) {
            Status ms = new Status(4, "org.jboss.ide.eclipse.as.core", 0x62020002, NLS.bind((String)Messages.MissingDeployXML, (Object)last.getName()), null);
            return ms;
        }
        if (this.shouldZip()) {
            IPath deployRoot = ds.getDeploymentLocation(moduleTree, false);
            util = new BPELZippedPublisherUtil(deployPath);
            IStatus ret = util.publishModule(this.server, deployRoot.toString(), moduleTree, publishType, delta, monitor);
            resultList.add(ret);
        } else {
            LocalCopyCallback handler = new LocalCopyCallback(this.server, deployPath, tempDeployPath);
            util = new PublishCopyUtil((IPublishCopyCallbackHandler)handler);
            resultList.addAll(Arrays.asList(util.initFullPublish(members, null, monitor)));
        }
        JBTBPELPublisher.addDeployedPathToDescriptor(this.server, last.getProject(), deployPath);
        this.pruneList(resultList);
        if (resultList.size() > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x62020002, NLS.bind((String)org.jboss.ide.eclipse.as.core.Messages.FullPublishFail, (Object)last.getName()), null);
            int i2 = 0;
            while (i2 < resultList.size()) {
                ms.add(resultList.get(i2));
                ++i2;
            }
            return ms;
        }
        return Status.OK_STATUS;
    }

    protected void pruneList(ArrayList<IStatus> list) {
        Iterator<IStatus> i = list.iterator();
        while (i.hasNext()) {
            if (!i.next().isOK()) continue;
            i.remove();
        }
    }

    protected boolean shouldZip() {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        return ds == null || ds.zipsWTPDeployments();
    }

    public static IPath getDeployPath(IModule[] moduleTree, IDeployableServer server) {
        IPath path = server.getDeploymentLocation(moduleTree, true);
        path = path.removeLastSegments(1).append(JBTBPELPublisher.getNewLastSegment(moduleTree));
        return path;
    }

    public static String getNewLastSegment(IModule[] moduleTree) {
        IModule last = moduleTree[moduleTree.length - 1];
        Calendar cal = Calendar.getInstance();
        StringBuffer lastSeg = new StringBuffer(JBTBPELPublisher.formatString(cal.get(1)));
        lastSeg.append(JBTBPELPublisher.formatString(cal.get(2) + 1));
        lastSeg.append(JBTBPELPublisher.formatString(cal.get(5)));
        lastSeg.append(JBTBPELPublisher.formatString(cal.get(11)));
        lastSeg.append(JBTBPELPublisher.formatString(cal.get(12)));
        lastSeg.append(JBTBPELPublisher.formatString(cal.get(13)));
        return String.valueOf(last.getName()) + "-" + lastSeg.toString() + ".jar";
    }

    private static String formatString(int dateUnit) {
        if (String.valueOf(dateUnit).length() < 2) {
            return "0" + dateUnit;
        }
        return String.valueOf(dateUnit);
    }

    protected static void save(IServer server, XMLMemento memento) {
        try {
            memento.save((OutputStream)new FileOutputStream(JBTBPELPublisher.getDeployDetailsFile(server)));
        }
        catch (IOException iOException) {}
    }

    public static void removeAll(IServer server, IProject project) {
        String[] paths = JBTBPELPublisher.getDeployedPathsFromDescriptor(server, project);
        int i = 0;
        while (i < paths.length) {
            FileUtil.safeDelete((File)new File(paths[i]));
            ++i;
        }
        JBTBPELPublisher.removeProjectFromDescriptor(server, project);
    }

    public static void removeVersion(IServer server, IProject project, String path) {
        FileUtil.safeDelete((File)new File(path));
        JBTBPELPublisher.removeVersionFromDescriptor(server, project, path);
    }

    public static void removeVersionFromDescriptor(IServer server, IProject project, String path) {
        File f = JBTBPELPublisher.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
            IMemento[] projects = memento.getChildren(PROJECT);
            int i = 0;
            while (i < projects.length) {
                if (project.getName().equals(projects[i].getString(NAME))) {
                    IMemento[] versions = projects[i].getChildren(VERSION);
                    int j = 0;
                    while (j < versions.length) {
                        if (((XMLMemento)versions[j]).getTextData().equals(path)) {
                            ((XMLMemento)projects[i]).removeChild((XMLMemento)versions[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            JBTBPELPublisher.save(server, memento);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void removeProjectFromDescriptor(IServer server, IProject project) {
        File f = JBTBPELPublisher.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
            IMemento[] projects = memento.getChildren(PROJECT);
            int i = 0;
            while (i < projects.length) {
                if (project.getName().equals(projects[i].getString(NAME))) {
                    memento.removeChild((XMLMemento)projects[i]);
                }
                ++i;
            }
            JBTBPELPublisher.save(server, memento);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void addDeployedPathToDescriptor(IServer server, IProject project, IPath path) {
        XMLMemento child;
        File f = JBTBPELPublisher.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)DEPLOYMENTS);
        }
        IMemento[] projects = memento.getChildren(PROJECT);
        boolean projectFound = false;
        int i = 0;
        while (i < projects.length) {
            if (project.getName().equals(projects[i].getString(NAME))) {
                projectFound = true;
                child = (XMLMemento)projects[i].createChild(VERSION);
                child.putTextData(path.toOSString());
            }
            ++i;
        }
        if (!projectFound) {
            XMLMemento proj = (XMLMemento)memento.createChild(PROJECT);
            proj.putString(NAME, project.getName());
            child = (XMLMemento)proj.createChild(VERSION);
            child.putTextData(path.toOSString());
        }
        JBTBPELPublisher.save(server, memento);
    }

    public static String[] getDeployedPathsFromDescriptor(IServer server, IProject project) {
        File f = JBTBPELPublisher.getDeployDetailsFile(server);
        ArrayList<String> list = new ArrayList<String>();
        if (f.exists()) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
                IMemento[] projects = memento.getChildren(PROJECT);
                int i = 0;
                while (i < projects.length) {
                    if (project.getName().equals(projects[i].getString(NAME))) {
                        IMemento[] deployments = projects[i].getChildren(VERSION);
                        int j = 0;
                        while (j < deployments.length) {
                            String s = ((XMLMemento)deployments[j]).getTextData();
                            if (s != null && !s.equals("")) {
                                list.add(s);
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return list.toArray(new String[list.size()]);
    }

    public static File getDeployDetailsFile(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation((IServer)server).append("bpel.deployment.versions").toFile();
    }

    public static class BPELZippedPublisherUtil
    extends LocalZippedPublisherUtil {
        private IPath deployPath;

        public BPELZippedPublisherUtil(IPath deployPath) {
            this.deployPath = deployPath;
        }

        public IPath getOutputFilePath(IModule[] module) {
            return this.getOutputFilePath();
        }

        public IPath getOutputFilePath() {
            return this.deployPath;
        }
    }
}

