/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.switchyard.ArtifactsModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.impl.SwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateArtifactReferenceOperation;
import org.switchyard.tools.ui.wizards.ArtifactDetailsWizardPage;

public abstract class NewArtifactReferenceWizard
extends Wizard
implements IWorkbenchWizard {
    private boolean _supportsDownload;
    private IWorkbench _workbench;
    private IProject _project;
    private SwitchYardProject _switchYardProject;
    private SwitchYardModel _switchYardModel;
    private ArtifactDetailsWizardPage _artifactDetailsPage;

    protected NewArtifactReferenceWizard(boolean supportsDownload) {
        this._supportsDownload = supportsDownload;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._workbench = workbench;
        this._project = (IProject)selection.getFirstElement();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.loadSwitchYardModel();
    }

    public boolean performFinish() {
        IWorkspaceRunnable downloadOperation = null;
        if (this._artifactDetailsPage != null && this._artifactDetailsPage.isDownloadArtifact()) {
            downloadOperation = this.createDownloadOperation();
        }
        final CreateArtifactReferenceOperation op = new CreateArtifactReferenceOperation(this._switchYardProject, this.getArtifactName(), this.getArtifactURL(), downloadOperation, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            boolean partialSuccess = false;
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                partialSuccess = ((CoreException)realException).getStatus().getSeverity() < 4;
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewArtifactReferenceWizard_logMessage_errorAddingArtifactReference, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewArtifactReferenceWizard_errorMessage_errorAddingArtifactReference, (String)realException.getMessage());
            return partialSuccess;
        }
        return true;
    }

    protected IWorkspaceRunnable createDownloadOperation() {
        return null;
    }

    public ArtifactsModel getArtifacts() {
        return this._switchYardModel.getArtifacts();
    }

    protected String getProviderURL() {
        return null;
    }

    protected String getProviderName() {
        return null;
    }

    protected ArtifactDetailsWizardPage getArtifactDetailsPage() {
        if (this._artifactDetailsPage == null) {
            this._artifactDetailsPage = new ArtifactDetailsWizardPage(this._supportsDownload);
        }
        return this._artifactDetailsPage;
    }

    protected String getArtifactName() {
        if (this._artifactDetailsPage == null) {
            return null;
        }
        return this._artifactDetailsPage.getArtifactName();
    }

    protected String getArtifactURL() {
        if (this._artifactDetailsPage == null) {
            return null;
        }
        return this._artifactDetailsPage.getArtifactURL();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if ((page = super.getNextPage(page)) == this._artifactDetailsPage && this._artifactDetailsPage != null) {
            this.updateArtifactDetails();
        }
        return page;
    }

    protected IWorkbench getWorkbench() {
        return this._workbench;
    }

    protected IProject getProject() {
        return this._project;
    }

    protected void updateArtifactDetails() {
        String temp = this.getProviderName();
        if (temp != null && temp.length() > 0) {
            this._artifactDetailsPage.setArtifactName(temp);
        }
        if ((temp = this.getProviderURL()) != null && temp.length() > 0) {
            this._artifactDetailsPage.setArtifactURL(temp);
        }
    }

    public boolean canFinish() {
        if (this._artifactDetailsPage == null) {
            return super.canFinish();
        }
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page == this._artifactDetailsPage) break;
            if (page == currentPage) {
                return false;
            }
            ++n2;
        }
        return super.canFinish();
    }

    private void loadSwitchYardModel() {
        this._switchYardProject = (SwitchYardProject)SwitchYardProjectManager.instance().getSwitchYardProject(this._project);
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        NewArtifactReferenceWizard.this._switchYardModel = NewArtifactReferenceWizard.this._switchYardProject.loadSwitchYardModel(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (this._switchYardModel == null) {
            this._switchYardModel = (SwitchYardModel)new ModelPuller().pull(new QName(this._switchYardProject.getSwitchYardNamespaceUri(), "switchyard"));
        }
    }
}

