/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.ExchangePattern;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.ui.validation.SwitchYardProjectValidator;
import org.switchyard.tools.ui.validation.ValidationProblem;
import org.switchyard.tools.ui.validation.WiringValidationContext;

public class ServiceWiringConstraints
extends AbstractModelConstraint {
    private WiringValidationContext _wiring;

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Contract) {
            IStatus contextProblems = this.initialize(ctx);
            if (contextProblems == null) {
                return this.validate(ctx, (Contract)eObj);
            }
            IStatus validationProblems = this.validate(ctx, (Contract)eObj);
            if (validationProblems == null) {
                return contextProblems;
            }
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, Arrays.asList(contextProblems, validationProblems));
        }
        return ctx.createSuccessStatus();
    }

    private IStatus initialize(IValidationContext ctx) {
        this._wiring = (WiringValidationContext)ctx.getCurrentConstraintData();
        if (this._wiring == null) {
            this._wiring = new WiringValidationContext(ctx, SwitchYardProjectValidator.getSwitchYard(ctx.getTarget().eResource()));
            ctx.putCurrentConstraintData((Object)this._wiring);
            return this._wiring.getContextStatus();
        }
        return null;
    }

    private IStatus validate(IValidationContext ctx, Contract contract) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IStatus status = this.validateUniqueName(ctx, contract);
        if (status != null) {
            statuses.add(status);
        }
        if ((status = this.validateInterfaceResolution(ctx, contract)) != null) {
            statuses.add(status);
        }
        if ((status = this.validateInterfaceCompatibility(ctx, contract)) != null) {
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private IStatus validateInterfaceCompatibility(IValidationContext ctx, Contract contract) {
        if (contract instanceof Reference) {
            return this.validateInterfaceCompatibility(ctx, (Reference)contract);
        }
        if (contract instanceof Service) {
            return this.validateInterfaceCompatibility(ctx, (Service)contract);
        }
        if (contract instanceof ComponentReference) {
            return this.validateInterfaceCompatibility(ctx, (ComponentReference)contract);
        }
        return null;
    }

    private IStatus validateInterfaceCompatibility(IValidationContext ctx, Reference reference) {
        Set<Contract> promotions = this._wiring.getWires().get(reference);
        if (promotions == null || promotions.isEmpty()) {
            ValidationProblem problem = ValidationProblem.UnusedReference;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)reference, null, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{reference.getName()});
        }
        return null;
    }

    private IStatus validateInterfaceCompatibility(IValidationContext ctx, Service service) {
        Set<Contract> services = this._wiring.getWires().get(service);
        if (services == null || services.isEmpty()) {
            ValidationProblem problem = ValidationProblem.UnboundService;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)service, null, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{service.getName()});
        }
        return this.validateInterfaces(ctx, (Contract)service, services.iterator().next());
    }

    private IStatus validateInterfaceResolution(IValidationContext ctx, Contract contract) {
        if (this._wiring.getServiceInterfaces().get(contract) == WiringValidationContext.URESOLVABLE_SERVICE_INTERFACE) {
            ValidationProblem problem = ValidationProblem.UnresolvableServiceInterface;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)contract, null, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[0]);
        }
        return null;
    }

    private IStatus validateInterfaces(IValidationContext ctx, Contract source, Contract target) {
        Map<Contract, ServiceInterface> interfaces = this._wiring.getServiceInterfaces();
        if (!interfaces.containsKey(source) || !interfaces.containsKey(target)) {
            return null;
        }
        ServiceInterface sourceInterface = interfaces.get(source);
        ServiceInterface targetInterface = interfaces.get(target);
        if (sourceInterface == WiringValidationContext.URESOLVABLE_SERVICE_INTERFACE) {
            return null;
        }
        if (sourceInterface.getOperations().size() == 1 && targetInterface.getOperations().size() == 1) {
            return this.validateOperation(ctx, source, target, (ServiceOperation)sourceInterface.getOperations().iterator().next(), (ServiceOperation)targetInterface.getOperations().iterator().next());
        }
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        for (ServiceOperation operation : sourceInterface.getOperations()) {
            IStatus status = this.validateOperation(ctx, source, target, operation, targetInterface.getOperation(operation.getName()));
            if (status == null) continue;
            problems.add(status);
        }
        if (problems.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
        }
        return null;
    }

    private IStatus validateOperation(IValidationContext ctx, Contract source, Contract target, ServiceOperation sourceOperation, ServiceOperation targetOperation) {
        if (targetOperation == null) {
            ValidationProblem problem = ValidationProblem.UnboundOperation;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)source, Arrays.asList(source, target), (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{sourceOperation.getName()});
        }
        ArrayList<Object> problems = new ArrayList<Object>();
        IStatus status = this.validateTransformation(ctx, source, target, sourceOperation.getInputType(), targetOperation.getInputType());
        if (status != null) {
            problems.add(status);
        }
        if (sourceOperation.getExchangePattern() == ExchangePattern.IN_ONLY) {
            if (targetOperation.getExchangePattern() == ExchangePattern.IN_OUT) {
                ValidationProblem problem = ValidationProblem.UnusedReturnValue;
                problems.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)source, Arrays.asList(source, target), (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{sourceOperation.getName()}));
            }
        } else if (targetOperation.getExchangePattern() == ExchangePattern.IN_ONLY) {
            ValidationProblem problem = ValidationProblem.IncomptaibleMEP;
            problems.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)source, Arrays.asList(source, target), (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{sourceOperation.getName()}));
        } else {
            status = this.validateTransformation(ctx, source, target, targetOperation.getOutputType(), sourceOperation.getOutputType());
            if (status != null) {
                problems.add(status);
            }
            if (targetOperation.getFaultType() != null) {
                if (sourceOperation.getFaultType() == null) {
                    ValidationProblem problem = ValidationProblem.UnhandledFault;
                    problems.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)source, Arrays.asList(source, target), (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{sourceOperation.getName()}));
                } else {
                    status = this.validateTransformation(ctx, source, target, targetOperation.getFaultType(), sourceOperation.getFaultType());
                    if (status != null) {
                        problems.add(status);
                    }
                }
            }
        }
        if (problems.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
        }
        return null;
    }

    private IStatus validateTransformation(IValidationContext ctx, Contract source, Contract target, QName fromType, QName toType) {
        if (fromType == null || toType == null || fromType.equals(toType) || this._wiring.getTranformers() == null) {
            return null;
        }
        Set<QName> tos = this._wiring.getTranformers().get(fromType);
        if (tos == null || !tos.contains(toType)) {
            ValidationProblem problem = ValidationProblem.MissingTransformation;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)source, Arrays.asList(source, target), (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{fromType, toType});
        }
        return null;
    }

    private IStatus validateInterfaceCompatibility(IValidationContext ctx, ComponentReference reference) {
        Set<Contract> targets = this._wiring.getWires().get(reference);
        if (targets == null || targets.isEmpty()) {
            ValidationProblem problem = ValidationProblem.UnresolvedReference;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)reference, targets, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{reference.getName()});
        }
        if (targets.size() > 1) {
            ValidationProblem problem = ValidationProblem.AmbiguousReference;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)reference, targets, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{reference.getName()});
        }
        return this.validateInterfaces(ctx, (Contract)reference, targets.iterator().next());
    }

    private IStatus validateUniqueName(IValidationContext ctx, Contract contract) {
        String name = contract.getName();
        if (!(contract instanceof Reference) && !(contract instanceof ComponentService) || name == null) {
            return null;
        }
        Map<String, Set<Contract>> names = this._wiring.getNames();
        if (!names.containsKey(name)) {
            return null;
        }
        Set<Contract> contracts = names.get(name);
        boolean dupd = false;
        for (Contract other : contracts) {
            if (other == contract || other instanceof Service) continue;
            dupd = true;
            break;
        }
        if (dupd) {
            ValidationProblem problem = ValidationProblem.DuplicateName;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)contract, contracts, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{name});
        }
        return null;
    }
}

