/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.validation.SwitchYardProjectValidator;
import org.switchyard.tools.ui.validation.ValidationProblem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CamelComponentConstraint
extends AbstractModelConstraint {
    private static final String CONFIGURE_METHOD = "configure";
    private static final String TO_TAG = "to";
    private static final String URI_ATTRIBUTE = "uri";
    private static final String FROM_TAG = "from";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CamelImplementationType) {
            CamelImplementationType camelImpl = (CamelImplementationType)eObj;
            if (camelImpl.getJava() != null) {
                return this.validateJava(ctx, camelImpl);
            }
            if (camelImpl.getXml() != null) {
                return this.validateXML(ctx, camelImpl);
            }
            Component component = (Component)camelImpl.eContainer();
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelImplementationIncomplete.getSeverity(), (int)ValidationProblem.CamelImplementationIncomplete.ordinal(), (String)ValidationProblem.CamelImplementationIncomplete.getMessage(), (Object[])new Object[]{component.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateXML(IValidationContext ctx, CamelImplementationType camelImpl) {
        Component component = (Component)camelImpl.eContainer();
        String xmlName = camelImpl.getXml().getPath();
        if (xmlName == null || xmlName.trim().isEmpty()) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelXMLUnspecified.getSeverity(), (int)ValidationProblem.CamelXMLUnspecified.ordinal(), (String)ValidationProblem.CamelXMLUnspecified.getMessage(), (Object[])new Object[]{component.getName()});
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        SwitchYardProjectValidator.ValidationAdapter adapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)camelImpl.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        IJavaProject javaProject = adapter.getJavaProject();
        IFile xmlFileResource = PlatformResourceAdapterFactory.getFileForObject(camelImpl, javaProject.getProject());
        if (xmlFileResource == null) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelXMLNotFound.getSeverity(), (int)ValidationProblem.CamelXMLNotFound.ordinal(), (String)ValidationProblem.CamelXMLNotFound.getMessage(), (Object[])new Object[]{xmlName, component.getName()});
        }
        if (xmlFileResource != null && xmlFileResource instanceof IFile) {
            IFile xmlFile = xmlFileResource;
            IPath location = xmlFile.getLocation();
            File file = location.toFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                NodeList toTags;
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(file);
                NodeList fromTags = document.getElementsByTagName(FROM_TAG);
                if (fromTags.getLength() > 0) {
                    if (fromTags.getLength() > 1) {
                        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteMoreThanOneFromFound.getSeverity(), (int)ValidationProblem.CamelRouteMoreThanOneFromFound.ordinal(), (String)ValidationProblem.CamelRouteMoreThanOneFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                    }
                    int i = 0;
                    while (i < fromTags.getLength()) {
                        String switchyardString;
                        IStatus status;
                        Node fromTag = fromTags.item(i);
                        Node uriAttribute = fromTag.getAttributes().getNamedItem(URI_ATTRIBUTE);
                        if (uriAttribute != null && (status = this.verifyURI(switchyardString = uriAttribute.getNodeValue(), ctx, component, true, javaProject)) != Status.OK_STATUS) {
                            statuses.add(status);
                        }
                        ++i;
                    }
                }
                if ((toTags = document.getElementsByTagName(TO_TAG)).getLength() > 0) {
                    int i = 0;
                    while (i < toTags.getLength()) {
                        String switchyardString;
                        IStatus status;
                        Node fromTag = toTags.item(i);
                        Node uriAttribute = fromTag.getAttributes().getNamedItem(URI_ATTRIBUTE);
                        if (uriAttribute != null && (status = this.verifyURI(switchyardString = uriAttribute.getNodeValue(), ctx, component, false, javaProject)) != Status.OK_STATUS) {
                            statuses.add(status);
                        }
                        ++i;
                    }
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private IStatus validateJava(IValidationContext ctx, CamelImplementationType camelImpl) {
        Component component = (Component)camelImpl.eContainer();
        String className = camelImpl.getJava().getClass_();
        if (className == null || className.length() == 0) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnspecifiedClass.getSeverity(), (int)ValidationProblem.CamelJavaUnspecifiedClass.ordinal(), (String)ValidationProblem.CamelJavaUnspecifiedClass.getMessage(), (Object[])new Object[]{component.getName()});
        }
        SwitchYardProjectValidator.ValidationAdapter adapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)camelImpl.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        IJavaProject javaProject = adapter.getJavaProject();
        try {
            IType javaClass;
            IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
            if (javaClass == null) {
                return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
            }
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            adapter.addDependency(javaClass.getResource());
            statuses.add(this.validateRouteClass(camelImpl, className, javaProject, ctx, component));
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        catch (JavaModelException javaModelException) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
        }
    }

    private boolean canFindSuperClass(IType searchType, String superClassName) throws JavaModelException {
        if (searchType.getSuperclassName() != null && searchType.getSuperclassName().contentEquals(superClassName)) {
            return true;
        }
        ITypeHierarchy supertypehierarchy = searchType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType supertype = supertypehierarchy.getSuperclass(searchType);
        if (supertype != null) {
            return this.canFindSuperClass(supertype, superClassName);
        }
        return false;
    }

    private IStatus validateRouteClass(CamelImplementationType impl, String className, IJavaProject javaProject, IValidationContext ctx, Component component) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        try {
            IType javaClass;
            IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
            if (javaClass != null) {
                boolean extendsRouteBuilder = this.canFindSuperClass(javaClass, "RouteBuilder");
                if (!extendsRouteBuilder) {
                    return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaWrongSuperclass.getSeverity(), (int)ValidationProblem.CamelJavaWrongSuperclass.ordinal(), (String)ValidationProblem.CamelJavaWrongSuperclass.getMessage(), (Object[])new Object[]{className, component.getName()});
                }
                IMethod[] methods = javaClass.getMethods();
                IMethod configureMethod = null;
                if (methods != null && methods.length > 0) {
                    int i = 0;
                    while (i < methods.length) {
                        IMethod method = methods[i];
                        if (method.getElementName().contentEquals(CONFIGURE_METHOD)) {
                            configureMethod = method;
                            break;
                        }
                        ++i;
                    }
                }
                if (configureMethod != null) {
                    String source = configureMethod.getSource();
                    String tryThis = ".?from\\(\".*?\"\\)(.?)";
                    Pattern fromPattern = Pattern.compile(tryThis);
                    Matcher fromMatcher = fromPattern.matcher(source);
                    int fromCount = 0;
                    while (fromMatcher.find()) {
                        ++fromCount;
                    }
                    if (fromCount > 1) {
                        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteMoreThanOneFromFound.getSeverity(), (int)ValidationProblem.CamelRouteMoreThanOneFromFound.ordinal(), (String)ValidationProblem.CamelRouteMoreThanOneFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                    }
                    String tryThisNext = ".?(from|to)\\(\".*?\"\\)(.?)";
                    Pattern fromToPattern = Pattern.compile(tryThisNext);
                    Matcher fromToMatcher = fromToPattern.matcher(source);
                    while (fromToMatcher.find()) {
                        String fromToString = source.substring(fromToMatcher.start(), fromToMatcher.end());
                        Pattern switchyardPattern = Pattern.compile("switchyard://.*\"");
                        Matcher switchyardMatcher = switchyardPattern.matcher(fromToString);
                        boolean isFrom = fromToString.matches(tryThis);
                        while (switchyardMatcher.find()) {
                            String switchyardString = fromToString.substring(switchyardMatcher.start(), switchyardMatcher.end() - 1);
                            IStatus status = this.verifyURI(switchyardString, ctx, component, isFrom, javaProject);
                            if (status == Status.OK_STATUS) continue;
                            statuses.add(status);
                        }
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private ComponentService findService(String serviceName, Component component) {
        if (component != null && !component.getService().isEmpty()) {
            EList list = component.getService();
            for (ComponentService cs : list) {
                if (!cs.getName().equals(serviceName)) continue;
                return cs;
            }
        }
        return null;
    }

    private ComponentReference findReference(String referenceName, Component component) {
        if (component != null && !component.getReference().isEmpty()) {
            EList list = component.getReference();
            for (ComponentReference cr : list) {
                if (!cr.getName().equals(referenceName)) continue;
                return cr;
            }
        }
        return null;
    }

    private IStatus verifyURI(String uriValue, IValidationContext ctx, Component component, boolean isFrom, IJavaProject javaProject) {
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        try {
            URI testURI = new URI(uriValue);
            String scheme = testURI.getScheme();
            ComponentService serviceFound = null;
            ComponentReference referenceFound = null;
            if (scheme.equals("switchyard")) {
                String schemeName = testURI.getAuthority();
                if (isFrom) {
                    String serviceName = schemeName;
                    serviceFound = this.findService(serviceName, component);
                    if (serviceFound == null) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.MissingServiceDeclaration.getSeverity(), (int)ValidationProblem.MissingServiceDeclaration.ordinal(), (String)ValidationProblem.MissingServiceDeclaration.getMessage(), (Object[])new Object[]{serviceName, component.getName()}));
                    }
                } else {
                    String referenceName = schemeName;
                    referenceFound = this.findReference(referenceName, component);
                    if (referenceFound == null) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.MissingReferenceDeclaration.getSeverity(), (int)ValidationProblem.MissingReferenceDeclaration.ordinal(), (String)ValidationProblem.MissingReferenceDeclaration.getMessage(), (Object[])new Object[]{referenceName, component.getName()}));
                    }
                }
                String query = testURI.getQuery();
                String operationName = null;
                if (query != null) {
                    int posEquals = query.indexOf(61);
                    if (query != null && posEquals > -1) {
                        operationName = query.substring(posEquals + 1);
                    } else {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.InvalidCamelRouteOperationReference.getSeverity(), (int)ValidationProblem.InvalidCamelRouteOperationReference.ordinal(), (String)ValidationProblem.InvalidCamelRouteOperationReference.getMessage(), (Object[])new Object[]{component.getName(), query}));
                    }
                }
                if (!isFrom && operationName != null && referenceFound != null) {
                    if (!this.checkInterfaceForOperation(referenceFound.getInterface(), operationName, javaProject)) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationNotFoundAsReference.getSeverity(), (int)ValidationProblem.CamelRouteOperationNotFoundAsReference.ordinal(), (String)ValidationProblem.CamelRouteOperationNotFoundAsReference.getMessage(), (Object[])new Object[]{operationName, referenceFound.getName()}));
                    }
                } else if (isFrom && operationName != null && serviceFound != null && !this.checkInterfaceForOperation(serviceFound.getInterface(), operationName, javaProject)) {
                    statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationNotFoundAsService.getSeverity(), (int)ValidationProblem.CamelRouteOperationNotFoundAsService.ordinal(), (String)ValidationProblem.CamelRouteOperationNotFoundAsService.getMessage(), (Object[])new Object[]{operationName, serviceFound.getName()}));
                }
                if (operationName == null && referenceFound != null && !this.checkInterfaceForNumberOfOperations(referenceFound.getInterface(), javaProject)) {
                    statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationRequiredNotSpecified.getSeverity(), (int)ValidationProblem.CamelRouteOperationRequiredNotSpecified.ordinal(), (String)ValidationProblem.CamelRouteOperationRequiredNotSpecified.getMessage(), (Object[])new Object[]{component.getName()}));
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkInterfaceForOperation(Interface intfc, String opName, IJavaProject javaProject) {
        try {
            if (intfc instanceof JavaInterface) {
                IType javaClass;
                JavaInterface javaIntfc = (JavaInterface)intfc;
                String className = javaIntfc.getInterface();
                IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
                if (javaClass != null && javaClass.getMethods() != null && javaClass.getMethods().length > 0) {
                    int i = 0;
                    while (i < javaClass.getMethods().length) {
                        IMethod method = javaClass.getMethods()[i];
                        if (method.getElementName().equals(opName)) {
                            return true;
                        }
                        ++i;
                    }
                }
            } else {
                if (intfc instanceof EsbInterface) {
                    return true;
                }
                ServiceInterface serviceIntfc = SwitchYardModelUtils.getServiceInterface(intfc);
                if (serviceIntfc != null && serviceIntfc.getOperations() != null && serviceIntfc.getOperation(opName) != null) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkInterfaceForNumberOfOperations(Interface intfc, IJavaProject javaProject) {
        block7: {
            block6: {
                IType javaClass;
                if (!(intfc instanceof JavaInterface)) break block6;
                JavaInterface javaIntfc = (JavaInterface)intfc;
                String className = javaIntfc.getInterface();
                IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
                if (javaClass != null && javaClass.getMethods() != null && javaClass.getMethods().length < 2) {
                    return true;
                }
            }
            if (!(intfc instanceof EsbInterface)) break block7;
            return true;
        }
        try {
            ServiceInterface serviceIntfc = SwitchYardModelUtils.getServiceInterface(intfc);
            if (serviceIntfc != null && serviceIntfc.getOperations() != null && serviceIntfc.getOperations().size() < 2) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

