/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.properties;

import java.util.Set;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.ui.internal.SharedWorkingCopyManager;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.ILayoutUtilities;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.SwitchYardSettingsGroup;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.operations.UpdateProjectPomOperation;

public class SwitchYardSettingsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
ILayoutUtilities {
    private SwitchYardSettingsGroup _settingsGroup;
    private ISwitchYardProjectWorkingCopy _switchYardProject;
    private IFacetedProject _ifp;
    private IFacetedProjectWorkingCopy _ifpwc;
    private Set<IRuntime> _configuredRuntimes;

    public SwitchYardSettingsPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this._settingsGroup = new SwitchYardSettingsGroup(content, this, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.initControls();
        return content;
    }

    public void dispose() {
        if (this._switchYardProject != null) {
            this._switchYardProject.dispose();
        }
        if (this._ifpwc != null) {
            SharedWorkingCopyManager.releaseWorkingCopy((IFacetedProject)this._ifp);
        }
        super.dispose();
    }

    public boolean performOk() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    new UpdateProjectPomOperation(SwitchYardSettingsPropertyPage.this._switchYardProject).run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
                if (SwitchYardSettingsPropertyPage.this._ifpwc != null && SwitchYardSettingsPropertyPage.this._ifpwc.isDirty()) {
                    try {
                        SwitchYardSettingsPropertyPage.this._ifpwc.commitChanges((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        });
        return true;
    }

    private void initControls() {
        this._switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(this.getProject()).createWorkingCopy();
        if (this._switchYardProject.needsLoading()) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SwitchYardSettingsPropertyPage.this._switchYardProject.load((IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        try {
            this._ifp = ProjectFacetsManager.create((IProject)this._switchYardProject.getProject());
            this._ifpwc = SharedWorkingCopyManager.getWorkingCopy((IFacetedProject)this._ifp);
            this._configuredRuntimes = this._ifpwc.getTargetedRuntimes();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        this._settingsGroup.setProject(this._ifpwc);
        this.initTargetRuntime();
        this.initRuntimeVersion();
        this.initComponentsTable();
    }

    private void initTargetRuntime() {
        if (this._ifpwc == null) {
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.NULL_RUNTIME));
            this._settingsGroup.getTargetRuntimesList().getControl().setEnabled(false);
            return;
        }
        IRuntime runtime = this._ifpwc.getPrimaryRuntime();
        if (runtime == null) {
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.NULL_RUNTIME));
        } else {
            for (IRuntimeComponent component : runtime.getRuntimeComponents()) {
                if (!"switchyard.runtime".equals(component.getRuntimeComponentType().getId()) && !"fuseServiceWorks.runtime".equals(component.getRuntimeComponentType().getId())) continue;
                this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection((Object)component), true);
            }
        }
        this._settingsGroup.getTargetRuntimesList().getControl().setEnabled(!this._switchYardProject.isUsingDependencyManagement());
        this._settingsGroup.getTargetRuntimesList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty() || selection.getFirstElement() == SwitchYardSettingsGroup.NULL_RUNTIME) {
                    IRuntime primaryRuntime = SwitchYardSettingsPropertyPage.this._ifpwc.getPrimaryRuntime();
                    if (primaryRuntime != null && !SwitchYardSettingsPropertyPage.this._configuredRuntimes.contains(primaryRuntime)) {
                        SwitchYardSettingsPropertyPage.this._ifpwc.removeTargetedRuntime(primaryRuntime);
                    }
                } else {
                    IRuntime runtime = ((IRuntimeComponent)selection.getFirstElement()).getRuntime();
                    SwitchYardSettingsPropertyPage.this._ifpwc.addTargetedRuntime(runtime);
                    SwitchYardSettingsPropertyPage.this._ifpwc.setPrimaryRuntime(runtime);
                }
            }
        });
    }

    private void initRuntimeVersion() {
        DefaultArtifactVersion version = null;
        String versionString = this._switchYardProject.getVersion();
        if (versionString != null && versionString.length() > 0) {
            version = new DefaultArtifactVersion(versionString);
        }
        if (version != null) {
            this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection((Object)version), true);
        }
        this._settingsGroup.getRuntimeVersionsList().getControl().setEnabled(!this._switchYardProject.isUsingDependencyManagement());
        this._settingsGroup.getRuntimeVersionsList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                SwitchYardSettingsPropertyPage.this._switchYardProject.setRuntimeVersion(((IStructuredSelection)selection).getFirstElement().toString());
            }
        });
    }

    private void initComponentsTable() {
        this._settingsGroup.setCheckedComponents(this._switchYardProject.getComponents(), true);
        this._settingsGroup.getComponentsTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof ISwitchYardComponentExtension) {
                    if (event.getChecked()) {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.addComponent((ISwitchYardComponentExtension)event.getElement());
                    } else {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.removeComponent((ISwitchYardComponentExtension)event.getElement());
                    }
                } else if (event.getElement() instanceof ISwitchYardComponentExtension.Category) {
                    if (event.getChecked()) {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.addComponents(SwitchYardComponentExtensionManager.instance().getComponentExtensions((ISwitchYardComponentExtension.Category)((Object)event.getElement())));
                    } else {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.removeComponents(SwitchYardComponentExtensionManager.instance().getComponentExtensions((ISwitchYardComponentExtension.Category)((Object)event.getElement())));
                    }
                }
            }
        });
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

